/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config.bidder.model;

import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ObjectUtils;
import org.prebid.server.auction.versionconverter.OrtbVersion;
import org.prebid.server.spring.config.bidder.model.CompressionType;
import org.prebid.server.spring.config.bidder.model.Debug;
import org.prebid.server.spring.config.bidder.model.DefaultBidderConfigurationProperties;
import org.prebid.server.spring.config.bidder.model.MetaInfo;
import org.prebid.server.spring.config.bidder.model.usersync.UsersyncConfigurationProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;

@Validated
public class BidderConfigurationProperties {
    @Autowired
    DefaultBidderConfigurationProperties defaultProperties;
    private Boolean enabled;
    private OrtbVersion ortbVersion;
    @NotBlank
    private String endpoint;
    private Boolean pbsEnforcesCcpa;
    private Boolean modifyingVastXmlAllowed;
    private List<String> deprecatedNames;
    private Map<String, Object> aliases;
    private Debug debug;
    @NotNull
    private MetaInfo metaInfo;
    private UsersyncConfigurationProperties usersync;
    private CompressionType endpointCompression;
    private final Class<? extends BidderConfigurationProperties> selfClass = this.getClass();

    @PostConstruct
    private void init() {
        this.enabled = (Boolean)ObjectUtils.defaultIfNull((Object)this.enabled, (Object)this.defaultProperties.getEnabled());
        this.ortbVersion = (OrtbVersion)((Object)ObjectUtils.defaultIfNull((Object)((Object)this.ortbVersion), (Object)((Object)this.defaultProperties.getOrtbVersion())));
        this.pbsEnforcesCcpa = (Boolean)ObjectUtils.defaultIfNull((Object)this.pbsEnforcesCcpa, (Object)this.defaultProperties.getPbsEnforcesCcpa());
        this.modifyingVastXmlAllowed = (Boolean)ObjectUtils.defaultIfNull((Object)this.modifyingVastXmlAllowed, (Object)this.defaultProperties.getModifyingVastXmlAllowed());
        this.debug = (Debug)ObjectUtils.defaultIfNull((Object)this.debug, (Object)this.defaultProperties.getDebug());
        this.aliases = (Map)ObjectUtils.defaultIfNull(this.aliases, this.defaultProperties.getAliases());
        this.deprecatedNames = (List)ObjectUtils.defaultIfNull(this.deprecatedNames, this.defaultProperties.getDeprecatedNames());
        this.endpointCompression = (CompressionType)((Object)ObjectUtils.defaultIfNull((Object)((Object)this.endpointCompression), (Object)((Object)this.defaultProperties.getEndpointCompression())));
        if (this.usersync != null && this.usersync.getEnabled() == null) {
            this.usersync.setEnabled(true);
        }
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public OrtbVersion getOrtbVersion() {
        return this.ortbVersion;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Boolean getPbsEnforcesCcpa() {
        return this.pbsEnforcesCcpa;
    }

    public Boolean getModifyingVastXmlAllowed() {
        return this.modifyingVastXmlAllowed;
    }

    public List<String> getDeprecatedNames() {
        return this.deprecatedNames;
    }

    public Map<String, Object> getAliases() {
        return this.aliases;
    }

    public Debug getDebug() {
        return this.debug;
    }

    @NotNull
    public MetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    public UsersyncConfigurationProperties getUsersync() {
        return this.usersync;
    }

    public CompressionType getEndpointCompression() {
        return this.endpointCompression;
    }

    public Class<? extends BidderConfigurationProperties> getSelfClass() {
        return this.selfClass;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setOrtbVersion(OrtbVersion ortbVersion) {
        this.ortbVersion = ortbVersion;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setPbsEnforcesCcpa(Boolean pbsEnforcesCcpa) {
        this.pbsEnforcesCcpa = pbsEnforcesCcpa;
    }

    public void setModifyingVastXmlAllowed(Boolean modifyingVastXmlAllowed) {
        this.modifyingVastXmlAllowed = modifyingVastXmlAllowed;
    }

    public void setDeprecatedNames(List<String> deprecatedNames) {
        this.deprecatedNames = deprecatedNames;
    }

    public void setAliases(Map<String, Object> aliases) {
        this.aliases = aliases;
    }

    public void setDebug(Debug debug) {
        this.debug = debug;
    }

    public void setMetaInfo(@NotNull MetaInfo metaInfo) {
        this.metaInfo = metaInfo;
    }

    public void setUsersync(UsersyncConfigurationProperties usersync) {
        this.usersync = usersync;
    }

    public void setEndpointCompression(CompressionType endpointCompression) {
        this.endpointCompression = endpointCompression;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BidderConfigurationProperties)) {
            return false;
        }
        BidderConfigurationProperties other = (BidderConfigurationProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Boolean this$pbsEnforcesCcpa = this.getPbsEnforcesCcpa();
        Boolean other$pbsEnforcesCcpa = other.getPbsEnforcesCcpa();
        if (this$pbsEnforcesCcpa == null ? other$pbsEnforcesCcpa != null : !((Object)this$pbsEnforcesCcpa).equals(other$pbsEnforcesCcpa)) {
            return false;
        }
        Boolean this$modifyingVastXmlAllowed = this.getModifyingVastXmlAllowed();
        Boolean other$modifyingVastXmlAllowed = other.getModifyingVastXmlAllowed();
        if (this$modifyingVastXmlAllowed == null ? other$modifyingVastXmlAllowed != null : !((Object)this$modifyingVastXmlAllowed).equals(other$modifyingVastXmlAllowed)) {
            return false;
        }
        DefaultBidderConfigurationProperties this$defaultProperties = this.defaultProperties;
        DefaultBidderConfigurationProperties other$defaultProperties = other.defaultProperties;
        if (this$defaultProperties == null ? other$defaultProperties != null : !((Object)this$defaultProperties).equals(other$defaultProperties)) {
            return false;
        }
        OrtbVersion this$ortbVersion = this.getOrtbVersion();
        OrtbVersion other$ortbVersion = other.getOrtbVersion();
        if (this$ortbVersion == null ? other$ortbVersion != null : !((Object)((Object)this$ortbVersion)).equals((Object)other$ortbVersion)) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        List<String> this$deprecatedNames = this.getDeprecatedNames();
        List<String> other$deprecatedNames = other.getDeprecatedNames();
        if (this$deprecatedNames == null ? other$deprecatedNames != null : !((Object)this$deprecatedNames).equals(other$deprecatedNames)) {
            return false;
        }
        Map<String, Object> this$aliases = this.getAliases();
        Map<String, Object> other$aliases = other.getAliases();
        if (this$aliases == null ? other$aliases != null : !((Object)this$aliases).equals(other$aliases)) {
            return false;
        }
        Debug this$debug = this.getDebug();
        Debug other$debug = other.getDebug();
        if (this$debug == null ? other$debug != null : !((Object)this$debug).equals(other$debug)) {
            return false;
        }
        MetaInfo this$metaInfo = this.getMetaInfo();
        MetaInfo other$metaInfo = other.getMetaInfo();
        if (this$metaInfo == null ? other$metaInfo != null : !((Object)this$metaInfo).equals(other$metaInfo)) {
            return false;
        }
        UsersyncConfigurationProperties this$usersync = this.getUsersync();
        UsersyncConfigurationProperties other$usersync = other.getUsersync();
        if (this$usersync == null ? other$usersync != null : !((Object)this$usersync).equals(other$usersync)) {
            return false;
        }
        CompressionType this$endpointCompression = this.getEndpointCompression();
        CompressionType other$endpointCompression = other.getEndpointCompression();
        if (this$endpointCompression == null ? other$endpointCompression != null : !((Object)((Object)this$endpointCompression)).equals((Object)other$endpointCompression)) {
            return false;
        }
        Class<? extends BidderConfigurationProperties> this$selfClass = this.getSelfClass();
        Class<? extends BidderConfigurationProperties> other$selfClass = other.getSelfClass();
        return !(this$selfClass == null ? other$selfClass != null : !this$selfClass.equals(other$selfClass));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BidderConfigurationProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Boolean $pbsEnforcesCcpa = this.getPbsEnforcesCcpa();
        result = result * 59 + ($pbsEnforcesCcpa == null ? 43 : ((Object)$pbsEnforcesCcpa).hashCode());
        Boolean $modifyingVastXmlAllowed = this.getModifyingVastXmlAllowed();
        result = result * 59 + ($modifyingVastXmlAllowed == null ? 43 : ((Object)$modifyingVastXmlAllowed).hashCode());
        DefaultBidderConfigurationProperties $defaultProperties = this.defaultProperties;
        result = result * 59 + ($defaultProperties == null ? 43 : ((Object)$defaultProperties).hashCode());
        OrtbVersion $ortbVersion = this.getOrtbVersion();
        result = result * 59 + ($ortbVersion == null ? 43 : ((Object)((Object)$ortbVersion)).hashCode());
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        List<String> $deprecatedNames = this.getDeprecatedNames();
        result = result * 59 + ($deprecatedNames == null ? 43 : ((Object)$deprecatedNames).hashCode());
        Map<String, Object> $aliases = this.getAliases();
        result = result * 59 + ($aliases == null ? 43 : ((Object)$aliases).hashCode());
        Debug $debug = this.getDebug();
        result = result * 59 + ($debug == null ? 43 : ((Object)$debug).hashCode());
        MetaInfo $metaInfo = this.getMetaInfo();
        result = result * 59 + ($metaInfo == null ? 43 : ((Object)$metaInfo).hashCode());
        UsersyncConfigurationProperties $usersync = this.getUsersync();
        result = result * 59 + ($usersync == null ? 43 : ((Object)$usersync).hashCode());
        CompressionType $endpointCompression = this.getEndpointCompression();
        result = result * 59 + ($endpointCompression == null ? 43 : ((Object)((Object)$endpointCompression)).hashCode());
        Class<? extends BidderConfigurationProperties> $selfClass = this.getSelfClass();
        result = result * 59 + ($selfClass == null ? 43 : $selfClass.hashCode());
        return result;
    }

    public String toString() {
        return "BidderConfigurationProperties(defaultProperties=" + this.defaultProperties + ", enabled=" + this.getEnabled() + ", ortbVersion=" + this.getOrtbVersion() + ", endpoint=" + this.getEndpoint() + ", pbsEnforcesCcpa=" + this.getPbsEnforcesCcpa() + ", modifyingVastXmlAllowed=" + this.getModifyingVastXmlAllowed() + ", deprecatedNames=" + this.getDeprecatedNames() + ", aliases=" + this.getAliases() + ", debug=" + this.getDebug() + ", metaInfo=" + this.getMetaInfo() + ", usersync=" + this.getUsersync() + ", endpointCompression=" + this.getEndpointCompression() + ", selfClass=" + this.getSelfClass() + ")";
    }
}

