/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config.bidder;

import java.time.Clock;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.prebid.server.bidder.BidderDeps;
import org.prebid.server.bidder.huaweiads.ClientTimeFormatter;
import org.prebid.server.bidder.huaweiads.CountryCodeResolver;
import org.prebid.server.bidder.huaweiads.HuaweiAdSlotBuilder;
import org.prebid.server.bidder.huaweiads.HuaweiAdmBuilder;
import org.prebid.server.bidder.huaweiads.HuaweiAdsBidder;
import org.prebid.server.bidder.huaweiads.HuaweiAppBuilder;
import org.prebid.server.bidder.huaweiads.HuaweiDeviceBuilder;
import org.prebid.server.bidder.huaweiads.HuaweiEndpointResolver;
import org.prebid.server.bidder.huaweiads.HuaweiNetworkBuilder;
import org.prebid.server.bidder.huaweiads.model.request.PkgNameConvert;
import org.prebid.server.geolocation.CountryCodeMapper;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.spring.config.bidder.model.BidderConfigurationProperties;
import org.prebid.server.spring.config.bidder.util.BidderDepsAssembler;
import org.prebid.server.spring.config.bidder.util.UsersyncerCreator;
import org.prebid.server.spring.env.YamlPropertySourceFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.validation.annotation.Validated;

@Configuration
@PropertySource(value={"classpath:/bidder-config/huaweiads.yaml"}, factory=YamlPropertySourceFactory.class)
public class HuaweiAdsConfiguration {
    private static final String BIDDER_NAME = "huaweiads";

    @Bean(value={"huaweiadsConfigurationProperties"})
    @ConfigurationProperties(value="adapters.huaweiads")
    HuaweiAdsConfigurationProperties configurationProperties() {
        return new HuaweiAdsConfigurationProperties();
    }

    @Bean
    BidderDeps huaweiAdsBidderDeps(HuaweiAdsConfigurationProperties huaweiadsConfigurationProperties, CountryCodeMapper countryCodeMapper, Clock clock, @NotBlank @Value(value="${external-url}") String externalUrl, JacksonMapper mapper) {
        return BidderDepsAssembler.forBidder(BIDDER_NAME).withConfig(huaweiadsConfigurationProperties).usersyncerCreator(UsersyncerCreator.create(externalUrl)).bidderCreator(config -> {
            ExtraInfo extraInfo = config.getExtraInfo();
            return new HuaweiAdsBidder(mapper, new HuaweiAdSlotBuilder(mapper), new HuaweiAppBuilder(extraInfo.getPkgNameConvert()), new HuaweiDeviceBuilder(mapper, new ClientTimeFormatter(clock)), new HuaweiNetworkBuilder(), new HuaweiAdmBuilder(mapper), new CountryCodeResolver(countryCodeMapper), new HuaweiEndpointResolver(config.getEndpoint(), extraInfo.getChineseEndpoint(), extraInfo.getRussianEndpoint(), extraInfo.getEuropeanEndpoint(), extraInfo.getAsianEndpoint(), extraInfo.getCloseSiteSelectionByCountry()));
        }).assemble();
    }

    @Validated
    private static class HuaweiAdsConfigurationProperties
    extends BidderConfigurationProperties {
        @Valid
        @NotNull
        private ExtraInfo extraInfo = new ExtraInfo();

        @NotNull
        public ExtraInfo getExtraInfo() {
            return this.extraInfo;
        }

        public void setExtraInfo(@NotNull ExtraInfo extraInfo) {
            this.extraInfo = extraInfo;
        }

        @Override
        public String toString() {
            return "HuaweiAdsConfiguration.HuaweiAdsConfigurationProperties(extraInfo=" + this.getExtraInfo() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HuaweiAdsConfigurationProperties)) {
                return false;
            }
            HuaweiAdsConfigurationProperties other = (HuaweiAdsConfigurationProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ExtraInfo this$extraInfo = this.getExtraInfo();
            ExtraInfo other$extraInfo = other.getExtraInfo();
            return !(this$extraInfo == null ? other$extraInfo != null : !((Object)this$extraInfo).equals(other$extraInfo));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof HuaweiAdsConfigurationProperties;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            ExtraInfo $extraInfo = this.getExtraInfo();
            result = result * 59 + ($extraInfo == null ? 43 : ((Object)$extraInfo).hashCode());
            return result;
        }
    }

    private static class ExtraInfo {
        List<PkgNameConvert> pkgNameConvert;
        String closeSiteSelectionByCountry;
        String chineseEndpoint;
        String russianEndpoint;
        String europeanEndpoint;
        String asianEndpoint;

        public List<PkgNameConvert> getPkgNameConvert() {
            return this.pkgNameConvert;
        }

        public String getCloseSiteSelectionByCountry() {
            return this.closeSiteSelectionByCountry;
        }

        public String getChineseEndpoint() {
            return this.chineseEndpoint;
        }

        public String getRussianEndpoint() {
            return this.russianEndpoint;
        }

        public String getEuropeanEndpoint() {
            return this.europeanEndpoint;
        }

        public String getAsianEndpoint() {
            return this.asianEndpoint;
        }

        public void setPkgNameConvert(List<PkgNameConvert> pkgNameConvert) {
            this.pkgNameConvert = pkgNameConvert;
        }

        public void setCloseSiteSelectionByCountry(String closeSiteSelectionByCountry) {
            this.closeSiteSelectionByCountry = closeSiteSelectionByCountry;
        }

        public void setChineseEndpoint(String chineseEndpoint) {
            this.chineseEndpoint = chineseEndpoint;
        }

        public void setRussianEndpoint(String russianEndpoint) {
            this.russianEndpoint = russianEndpoint;
        }

        public void setEuropeanEndpoint(String europeanEndpoint) {
            this.europeanEndpoint = europeanEndpoint;
        }

        public void setAsianEndpoint(String asianEndpoint) {
            this.asianEndpoint = asianEndpoint;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExtraInfo)) {
                return false;
            }
            ExtraInfo other = (ExtraInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<PkgNameConvert> this$pkgNameConvert = this.getPkgNameConvert();
            List<PkgNameConvert> other$pkgNameConvert = other.getPkgNameConvert();
            if (this$pkgNameConvert == null ? other$pkgNameConvert != null : !((Object)this$pkgNameConvert).equals(other$pkgNameConvert)) {
                return false;
            }
            String this$closeSiteSelectionByCountry = this.getCloseSiteSelectionByCountry();
            String other$closeSiteSelectionByCountry = other.getCloseSiteSelectionByCountry();
            if (this$closeSiteSelectionByCountry == null ? other$closeSiteSelectionByCountry != null : !this$closeSiteSelectionByCountry.equals(other$closeSiteSelectionByCountry)) {
                return false;
            }
            String this$chineseEndpoint = this.getChineseEndpoint();
            String other$chineseEndpoint = other.getChineseEndpoint();
            if (this$chineseEndpoint == null ? other$chineseEndpoint != null : !this$chineseEndpoint.equals(other$chineseEndpoint)) {
                return false;
            }
            String this$russianEndpoint = this.getRussianEndpoint();
            String other$russianEndpoint = other.getRussianEndpoint();
            if (this$russianEndpoint == null ? other$russianEndpoint != null : !this$russianEndpoint.equals(other$russianEndpoint)) {
                return false;
            }
            String this$europeanEndpoint = this.getEuropeanEndpoint();
            String other$europeanEndpoint = other.getEuropeanEndpoint();
            if (this$europeanEndpoint == null ? other$europeanEndpoint != null : !this$europeanEndpoint.equals(other$europeanEndpoint)) {
                return false;
            }
            String this$asianEndpoint = this.getAsianEndpoint();
            String other$asianEndpoint = other.getAsianEndpoint();
            return !(this$asianEndpoint == null ? other$asianEndpoint != null : !this$asianEndpoint.equals(other$asianEndpoint));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ExtraInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<PkgNameConvert> $pkgNameConvert = this.getPkgNameConvert();
            result = result * 59 + ($pkgNameConvert == null ? 43 : ((Object)$pkgNameConvert).hashCode());
            String $closeSiteSelectionByCountry = this.getCloseSiteSelectionByCountry();
            result = result * 59 + ($closeSiteSelectionByCountry == null ? 43 : $closeSiteSelectionByCountry.hashCode());
            String $chineseEndpoint = this.getChineseEndpoint();
            result = result * 59 + ($chineseEndpoint == null ? 43 : $chineseEndpoint.hashCode());
            String $russianEndpoint = this.getRussianEndpoint();
            result = result * 59 + ($russianEndpoint == null ? 43 : $russianEndpoint.hashCode());
            String $europeanEndpoint = this.getEuropeanEndpoint();
            result = result * 59 + ($europeanEndpoint == null ? 43 : $europeanEndpoint.hashCode());
            String $asianEndpoint = this.getAsianEndpoint();
            result = result * 59 + ($asianEndpoint == null ? 43 : $asianEndpoint.hashCode());
            return result;
        }

        public String toString() {
            return "HuaweiAdsConfiguration.ExtraInfo(pkgNameConvert=" + this.getPkgNameConvert() + ", closeSiteSelectionByCountry=" + this.getCloseSiteSelectionByCountry() + ", chineseEndpoint=" + this.getChineseEndpoint() + ", russianEndpoint=" + this.getRussianEndpoint() + ", europeanEndpoint=" + this.getEuropeanEndpoint() + ", asianEndpoint=" + this.getAsianEndpoint() + ")";
        }
    }
}

