/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config.bidder;

import javax.validation.constraints.NotBlank;
import org.prebid.server.bidder.BidderDeps;
import org.prebid.server.bidder.beachfront.BeachfrontBidder;
import org.prebid.server.currency.CurrencyConversionService;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.spring.config.bidder.model.BidderConfigurationProperties;
import org.prebid.server.spring.config.bidder.util.BidderDepsAssembler;
import org.prebid.server.spring.config.bidder.util.UsersyncerCreator;
import org.prebid.server.spring.env.YamlPropertySourceFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.validation.annotation.Validated;

@Configuration
@PropertySource(value={"classpath:/bidder-config/beachfront.yaml"}, factory=YamlPropertySourceFactory.class)
public class BeachfrontConfiguration {
    private static final String BIDDER_NAME = "beachfront";

    @Bean(value={"beachfrontConfigurationProperties"})
    @ConfigurationProperties(value="adapters.beachfront")
    BeachfrontConfigurationProperties configurationProperties() {
        return new BeachfrontConfigurationProperties();
    }

    @Bean
    BidderDeps beachfrontBidderDeps(BeachfrontConfigurationProperties beachfrontConfigurationProperties, @NotBlank @Value(value="${external-url}") String externalUrl, CurrencyConversionService currencyConversionService, JacksonMapper mapper) {
        return BidderDepsAssembler.forBidder(BIDDER_NAME).withConfig(beachfrontConfigurationProperties).usersyncerCreator(UsersyncerCreator.create(externalUrl)).bidderCreator(config -> new BeachfrontBidder(config.getEndpoint(), config.getVideoEndpoint(), currencyConversionService, mapper)).assemble();
    }

    @Validated
    private static class BeachfrontConfigurationProperties
    extends BidderConfigurationProperties {
        @NotBlank
        private String videoEndpoint;

        public String getVideoEndpoint() {
            return this.videoEndpoint;
        }

        public void setVideoEndpoint(String videoEndpoint) {
            this.videoEndpoint = videoEndpoint;
        }

        @Override
        public String toString() {
            return "BeachfrontConfiguration.BeachfrontConfigurationProperties(videoEndpoint=" + this.getVideoEndpoint() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BeachfrontConfigurationProperties)) {
                return false;
            }
            BeachfrontConfigurationProperties other = (BeachfrontConfigurationProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$videoEndpoint = this.getVideoEndpoint();
            String other$videoEndpoint = other.getVideoEndpoint();
            return !(this$videoEndpoint == null ? other$videoEndpoint != null : !this$videoEndpoint.equals(other$videoEndpoint));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof BeachfrontConfigurationProperties;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $videoEndpoint = this.getVideoEndpoint();
            result = result * 59 + ($videoEndpoint == null ? 43 : $videoEndpoint.hashCode());
            return result;
        }
    }
}

