/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config.bidder;

import java.util.function.Function;
import javax.validation.constraints.NotNull;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.BidderDeps;
import org.prebid.server.bidder.audiencenetwork.AudienceNetworkBidder;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.spring.config.bidder.model.BidderConfigurationProperties;
import org.prebid.server.spring.config.bidder.util.BidderDepsAssembler;
import org.prebid.server.spring.config.bidder.util.UsersyncerCreator;
import org.prebid.server.spring.env.YamlPropertySourceFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Configuration
@PropertySource(value={"classpath:/bidder-config/audiencenetwork.yaml"}, factory=YamlPropertySourceFactory.class)
public class AudienceNetworkConfiguration {
    private static final String BIDDER_NAME = "audienceNetwork";

    @Bean
    BidderDeps audiencenetworkBidderDeps(AudienceNetworkConfigurationProperties audienceNetworkConfigurationProperties, JacksonMapper mapper) {
        Function<AudienceNetworkConfigurationProperties, Bidder> bidderCreator = config -> new AudienceNetworkBidder(config.getEndpoint(), config.getPlatformId(), config.getAppSecret(), audienceNetworkConfigurationProperties.getTimeoutNotificationUrlTemplate(), mapper);
        return BidderDepsAssembler.forBidder(BIDDER_NAME).withConfig(audienceNetworkConfigurationProperties).usersyncerCreator(UsersyncerCreator.create(null)).bidderCreator(audienceNetworkConfigurationProperties.getEnabled() != false ? bidderCreator : null).assemble();
    }

    @Validated
    @Component(value="audienceNetworkConfigurationProperties")
    @ConfigurationProperties(value="adapters.audiencenetwork")
    private static class AudienceNetworkConfigurationProperties
    extends BidderConfigurationProperties {
        @NotNull
        private String platformId;
        @NotNull
        private String appSecret;
        @NotNull
        private String timeoutNotificationUrlTemplate;

        @NotNull
        public String getPlatformId() {
            return this.platformId;
        }

        @NotNull
        public String getAppSecret() {
            return this.appSecret;
        }

        @NotNull
        public String getTimeoutNotificationUrlTemplate() {
            return this.timeoutNotificationUrlTemplate;
        }

        public void setPlatformId(@NotNull String platformId) {
            this.platformId = platformId;
        }

        public void setAppSecret(@NotNull String appSecret) {
            this.appSecret = appSecret;
        }

        public void setTimeoutNotificationUrlTemplate(@NotNull String timeoutNotificationUrlTemplate) {
            this.timeoutNotificationUrlTemplate = timeoutNotificationUrlTemplate;
        }

        @Override
        public String toString() {
            return "AudienceNetworkConfiguration.AudienceNetworkConfigurationProperties(platformId=" + this.getPlatformId() + ", appSecret=" + this.getAppSecret() + ", timeoutNotificationUrlTemplate=" + this.getTimeoutNotificationUrlTemplate() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AudienceNetworkConfigurationProperties)) {
                return false;
            }
            AudienceNetworkConfigurationProperties other = (AudienceNetworkConfigurationProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$platformId = this.getPlatformId();
            String other$platformId = other.getPlatformId();
            if (this$platformId == null ? other$platformId != null : !this$platformId.equals(other$platformId)) {
                return false;
            }
            String this$appSecret = this.getAppSecret();
            String other$appSecret = other.getAppSecret();
            if (this$appSecret == null ? other$appSecret != null : !this$appSecret.equals(other$appSecret)) {
                return false;
            }
            String this$timeoutNotificationUrlTemplate = this.getTimeoutNotificationUrlTemplate();
            String other$timeoutNotificationUrlTemplate = other.getTimeoutNotificationUrlTemplate();
            return !(this$timeoutNotificationUrlTemplate == null ? other$timeoutNotificationUrlTemplate != null : !this$timeoutNotificationUrlTemplate.equals(other$timeoutNotificationUrlTemplate));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof AudienceNetworkConfigurationProperties;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $platformId = this.getPlatformId();
            result = result * 59 + ($platformId == null ? 43 : $platformId.hashCode());
            String $appSecret = this.getAppSecret();
            result = result * 59 + ($appSecret == null ? 43 : $appSecret.hashCode());
            String $timeoutNotificationUrlTemplate = this.getTimeoutNotificationUrlTemplate();
            result = result * 59 + ($timeoutNotificationUrlTemplate == null ? 43 : $timeoutNotificationUrlTemplate.hashCode());
            return result;
        }
    }
}

