/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config.bidder;

import java.util.Map;
import javax.validation.constraints.NotBlank;
import org.prebid.server.bidder.BidderDeps;
import org.prebid.server.bidder.appnexus.AppnexusBidder;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.spring.config.bidder.model.BidderConfigurationProperties;
import org.prebid.server.spring.config.bidder.util.BidderDepsAssembler;
import org.prebid.server.spring.config.bidder.util.UsersyncerCreator;
import org.prebid.server.spring.env.YamlPropertySourceFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"classpath:/bidder-config/appnexus.yaml"}, factory=YamlPropertySourceFactory.class)
public class AppnexusConfiguration {
    private static final String BIDDER_NAME = "appnexus";

    @Bean(value={"appnexusConfigurationProperties"})
    @ConfigurationProperties(value="adapters.appnexus")
    AppnexusConfigurationProperties configurationProperties() {
        return new AppnexusConfigurationProperties();
    }

    @Bean
    BidderDeps appnexusBidderDeps(AppnexusConfigurationProperties appnexusConfigurationProperties, @NotBlank @Value(value="${external-url}") String externalUrl, JacksonMapper mapper) {
        return BidderDepsAssembler.forBidder(BIDDER_NAME).withConfig(appnexusConfigurationProperties).usersyncerCreator(UsersyncerCreator.create(externalUrl)).bidderCreator(config -> new AppnexusBidder(config.getEndpoint(), appnexusConfigurationProperties.getPlatformId(), appnexusConfigurationProperties.getIabCategories(), mapper)).assemble();
    }

    private static class AppnexusConfigurationProperties
    extends BidderConfigurationProperties {
        Integer platformId;
        Map<Integer, String> iabCategories;

        public Integer getPlatformId() {
            return this.platformId;
        }

        public Map<Integer, String> getIabCategories() {
            return this.iabCategories;
        }

        public void setPlatformId(Integer platformId) {
            this.platformId = platformId;
        }

        public void setIabCategories(Map<Integer, String> iabCategories) {
            this.iabCategories = iabCategories;
        }

        @Override
        public String toString() {
            return "AppnexusConfiguration.AppnexusConfigurationProperties(platformId=" + this.getPlatformId() + ", iabCategories=" + this.getIabCategories() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AppnexusConfigurationProperties)) {
                return false;
            }
            AppnexusConfigurationProperties other = (AppnexusConfigurationProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Integer this$platformId = this.getPlatformId();
            Integer other$platformId = other.getPlatformId();
            if (this$platformId == null ? other$platformId != null : !((Object)this$platformId).equals(other$platformId)) {
                return false;
            }
            Map<Integer, String> this$iabCategories = this.getIabCategories();
            Map<Integer, String> other$iabCategories = other.getIabCategories();
            return !(this$iabCategories == null ? other$iabCategories != null : !((Object)this$iabCategories).equals(other$iabCategories));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof AppnexusConfigurationProperties;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Integer $platformId = this.getPlatformId();
            result = result * 59 + ($platformId == null ? 43 : ((Object)$platformId).hashCode());
            Map<Integer, String> $iabCategories = this.getIabCategories();
            result = result * 59 + ($iabCategories == null ? 43 : ((Object)$iabCategories).hashCode());
            return result;
        }
    }
}

