/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config;

import io.vertx.core.Vertx;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.ListUtils;
import org.prebid.server.analytics.AnalyticsReporter;
import org.prebid.server.analytics.reporter.AnalyticsReporterDelegator;
import org.prebid.server.analytics.reporter.log.LogAnalyticsReporter;
import org.prebid.server.analytics.reporter.pubstack.PubstackAnalyticsReporter;
import org.prebid.server.analytics.reporter.pubstack.model.PubstackAnalyticsProperties;
import org.prebid.server.auction.PrivacyEnforcementService;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.metric.Metrics;
import org.prebid.server.vertx.http.HttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.annotation.Validated;

@Configuration
public class AnalyticsConfiguration {
    @Bean
    AnalyticsReporterDelegator analyticsReporterDelegator(@Autowired(required=false) List<AnalyticsReporter> delegates, Vertx vertx, PrivacyEnforcementService privacyEnforcementService, Metrics metrics, @Value(value="${logging.sampling-rate:0.01}") double logSamplingRate) {
        return new AnalyticsReporterDelegator(logSamplingRate, ListUtils.emptyIfNull(delegates), vertx, privacyEnforcementService, metrics);
    }

    @Bean
    @ConditionalOnProperty(prefix="analytics.log", name={"enabled"}, havingValue="true")
    LogAnalyticsReporter logAnalyticsReporter(JacksonMapper mapper) {
        return new LogAnalyticsReporter(mapper);
    }

    @Configuration
    @ConditionalOnProperty(prefix="analytics.pubstack", name={"enabled"}, havingValue="true")
    public static class PubstackAnalyticsConfiguration {
        @Bean
        PubstackAnalyticsReporter pubstackAnalyticsReporter(PubstackAnalyticsConfiguratinProperties pubstackAnalyticsConfiguratinProperties, HttpClient httpClient, JacksonMapper jacksonMapper, Vertx vertx) {
            return new PubstackAnalyticsReporter(pubstackAnalyticsConfiguratinProperties.toComponentProperties(), httpClient, jacksonMapper, vertx);
        }

        @Bean
        @ConfigurationProperties(prefix="analytics.pubstack")
        PubstackAnalyticsConfiguratinProperties pubstackAnalyticsConfiguratinProperties() {
            return new PubstackAnalyticsConfiguratinProperties();
        }

        @Validated
        private static class PubstackAnalyticsConfiguratinProperties {
            @NotNull
            String endpoint;
            @NotNull
            String scopeid;
            @NotNull
            Boolean enabled;
            @NotNull
            Long configurationRefreshDelayMs;
            @NotNull
            Long timeoutMs;
            @NotNull
            PubstackBufferProperties buffers;

            public PubstackAnalyticsProperties toComponentProperties() {
                return PubstackAnalyticsProperties.builder().endpoint(this.getEndpoint()).scopeId(this.getScopeid()).enabled(this.getEnabled()).configurationRefreshDelayMs(this.getConfigurationRefreshDelayMs()).sizeBytes(this.getBuffers().getSizeBytes()).count(this.getBuffers().getCount()).timeoutMs(this.getTimeoutMs()).reportTtlMs(this.getBuffers().getReportTtlMs()).build();
            }

            @NotNull
            public String getEndpoint() {
                return this.endpoint;
            }

            @NotNull
            public String getScopeid() {
                return this.scopeid;
            }

            @NotNull
            public Boolean getEnabled() {
                return this.enabled;
            }

            @NotNull
            public Long getConfigurationRefreshDelayMs() {
                return this.configurationRefreshDelayMs;
            }

            @NotNull
            public Long getTimeoutMs() {
                return this.timeoutMs;
            }

            @NotNull
            public PubstackBufferProperties getBuffers() {
                return this.buffers;
            }

            public void setEndpoint(@NotNull String endpoint) {
                this.endpoint = endpoint;
            }

            public void setScopeid(@NotNull String scopeid) {
                this.scopeid = scopeid;
            }

            public void setEnabled(@NotNull Boolean enabled) {
                this.enabled = enabled;
            }

            public void setConfigurationRefreshDelayMs(@NotNull Long configurationRefreshDelayMs) {
                this.configurationRefreshDelayMs = configurationRefreshDelayMs;
            }

            public void setTimeoutMs(@NotNull Long timeoutMs) {
                this.timeoutMs = timeoutMs;
            }

            public void setBuffers(@NotNull PubstackBufferProperties buffers) {
                this.buffers = buffers;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PubstackAnalyticsConfiguratinProperties)) {
                    return false;
                }
                PubstackAnalyticsConfiguratinProperties other = (PubstackAnalyticsConfiguratinProperties)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                    return false;
                }
                Long this$configurationRefreshDelayMs = this.getConfigurationRefreshDelayMs();
                Long other$configurationRefreshDelayMs = other.getConfigurationRefreshDelayMs();
                if (this$configurationRefreshDelayMs == null ? other$configurationRefreshDelayMs != null : !((Object)this$configurationRefreshDelayMs).equals(other$configurationRefreshDelayMs)) {
                    return false;
                }
                Long this$timeoutMs = this.getTimeoutMs();
                Long other$timeoutMs = other.getTimeoutMs();
                if (this$timeoutMs == null ? other$timeoutMs != null : !((Object)this$timeoutMs).equals(other$timeoutMs)) {
                    return false;
                }
                String this$endpoint = this.getEndpoint();
                String other$endpoint = other.getEndpoint();
                if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
                    return false;
                }
                String this$scopeid = this.getScopeid();
                String other$scopeid = other.getScopeid();
                if (this$scopeid == null ? other$scopeid != null : !this$scopeid.equals(other$scopeid)) {
                    return false;
                }
                PubstackBufferProperties this$buffers = this.getBuffers();
                PubstackBufferProperties other$buffers = other.getBuffers();
                return !(this$buffers == null ? other$buffers != null : !((Object)this$buffers).equals(other$buffers));
            }

            protected boolean canEqual(Object other) {
                return other instanceof PubstackAnalyticsConfiguratinProperties;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                Long $configurationRefreshDelayMs = this.getConfigurationRefreshDelayMs();
                result = result * 59 + ($configurationRefreshDelayMs == null ? 43 : ((Object)$configurationRefreshDelayMs).hashCode());
                Long $timeoutMs = this.getTimeoutMs();
                result = result * 59 + ($timeoutMs == null ? 43 : ((Object)$timeoutMs).hashCode());
                String $endpoint = this.getEndpoint();
                result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
                String $scopeid = this.getScopeid();
                result = result * 59 + ($scopeid == null ? 43 : $scopeid.hashCode());
                PubstackBufferProperties $buffers = this.getBuffers();
                result = result * 59 + ($buffers == null ? 43 : ((Object)$buffers).hashCode());
                return result;
            }

            public String toString() {
                return "AnalyticsConfiguration.PubstackAnalyticsConfiguration.PubstackAnalyticsConfiguratinProperties(endpoint=" + this.getEndpoint() + ", scopeid=" + this.getScopeid() + ", enabled=" + this.getEnabled() + ", configurationRefreshDelayMs=" + this.getConfigurationRefreshDelayMs() + ", timeoutMs=" + this.getTimeoutMs() + ", buffers=" + this.getBuffers() + ")";
            }
        }

        @Validated
        private static class PubstackBufferProperties {
            @NotNull
            Integer sizeBytes;
            @NotNull
            Integer count;
            @NotNull
            Long reportTtlMs;

            @NotNull
            public Integer getSizeBytes() {
                return this.sizeBytes;
            }

            @NotNull
            public Integer getCount() {
                return this.count;
            }

            @NotNull
            public Long getReportTtlMs() {
                return this.reportTtlMs;
            }

            public void setSizeBytes(@NotNull Integer sizeBytes) {
                this.sizeBytes = sizeBytes;
            }

            public void setCount(@NotNull Integer count) {
                this.count = count;
            }

            public void setReportTtlMs(@NotNull Long reportTtlMs) {
                this.reportTtlMs = reportTtlMs;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PubstackBufferProperties)) {
                    return false;
                }
                PubstackBufferProperties other = (PubstackBufferProperties)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Integer this$sizeBytes = this.getSizeBytes();
                Integer other$sizeBytes = other.getSizeBytes();
                if (this$sizeBytes == null ? other$sizeBytes != null : !((Object)this$sizeBytes).equals(other$sizeBytes)) {
                    return false;
                }
                Integer this$count = this.getCount();
                Integer other$count = other.getCount();
                if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
                    return false;
                }
                Long this$reportTtlMs = this.getReportTtlMs();
                Long other$reportTtlMs = other.getReportTtlMs();
                return !(this$reportTtlMs == null ? other$reportTtlMs != null : !((Object)this$reportTtlMs).equals(other$reportTtlMs));
            }

            protected boolean canEqual(Object other) {
                return other instanceof PubstackBufferProperties;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Integer $sizeBytes = this.getSizeBytes();
                result = result * 59 + ($sizeBytes == null ? 43 : ((Object)$sizeBytes).hashCode());
                Integer $count = this.getCount();
                result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
                Long $reportTtlMs = this.getReportTtlMs();
                result = result * 59 + ($reportTtlMs == null ? 43 : ((Object)$reportTtlMs).hashCode());
                return result;
            }

            public String toString() {
                return "AnalyticsConfiguration.PubstackAnalyticsConfiguration.PubstackBufferProperties(sizeBytes=" + this.getSizeBytes() + ", count=" + this.getCount() + ", reportTtlMs=" + this.getReportTtlMs() + ")";
            }
        }
    }
}

