/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.settings.helper;

import io.vertx.core.json.JsonArray;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.settings.helper.StoredItemResolver;
import org.prebid.server.settings.model.StoredDataResult;
import org.prebid.server.settings.model.StoredDataType;
import org.prebid.server.settings.model.StoredItem;

public class JdbcStoredDataResultMapper {
    private static final Logger logger = LoggerFactory.getLogger(JdbcStoredDataResultMapper.class);

    private JdbcStoredDataResultMapper() {
    }

    public static StoredDataResult map(ResultSet resultSet, String accountId, Set<String> requestIds, Set<String> impIds) {
        Map<String, String> storedIdToImp;
        Map<String, String> storedIdToRequest;
        ArrayList<String> errors = new ArrayList<String>();
        if (resultSet == null || CollectionUtils.isEmpty((Collection)resultSet.getResults())) {
            storedIdToRequest = Collections.emptyMap();
            storedIdToImp = Collections.emptyMap();
            if (requestIds.isEmpty() && impIds.isEmpty()) {
                errors.add("No stored requests or imps were found");
            } else {
                Object errorRequests = requestIds.isEmpty() ? "" : "stored requests for ids " + requestIds;
                String separator = requestIds.isEmpty() || impIds.isEmpty() ? "" : " and ";
                Object errorImps = impIds.isEmpty() ? "" : "stored imps for ids " + impIds;
                errors.add("No %s%s%s were found".formatted(errorRequests, separator, errorImps));
            }
        } else {
            HashMap<String, Set<StoredItem>> requestIdToStoredItems = new HashMap<String, Set<StoredItem>>();
            HashMap<String, Set<StoredItem>> impIdToStoredItems = new HashMap<String, Set<StoredItem>>();
            for (JsonArray result : resultSet.getResults()) {
                StoredDataType type;
                String typeAsString;
                String data;
                String id;
                String fetchedAccountId;
                try {
                    fetchedAccountId = result.getString(0);
                    id = result.getString(1);
                    data = result.getString(2);
                    typeAsString = result.getString(3);
                }
                catch (ClassCastException | IndexOutOfBoundsException e) {
                    String message = "Error occurred while mapping stored request data";
                    logger.error((Object)"Error occurred while mapping stored request data", (Throwable)e);
                    errors.add("Error occurred while mapping stored request data");
                    return StoredDataResult.of(Collections.emptyMap(), Collections.emptyMap(), errors);
                }
                try {
                    type = StoredDataType.valueOf(typeAsString);
                }
                catch (IllegalArgumentException e) {
                    logger.error((Object)"Stored request data with id={0} has invalid type: ''{1}'' and will be ignored.", (Throwable)e, new Object[]{id, typeAsString});
                    continue;
                }
                if (type == StoredDataType.request) {
                    JdbcStoredDataResultMapper.addStoredItem(fetchedAccountId, id, data, requestIdToStoredItems);
                    continue;
                }
                JdbcStoredDataResultMapper.addStoredItem(fetchedAccountId, id, data, impIdToStoredItems);
            }
            storedIdToRequest = JdbcStoredDataResultMapper.storedItemsOrAddError(StoredDataType.request, accountId, requestIds, requestIdToStoredItems, errors);
            storedIdToImp = JdbcStoredDataResultMapper.storedItemsOrAddError(StoredDataType.imp, accountId, impIds, impIdToStoredItems, errors);
        }
        return StoredDataResult.of(storedIdToRequest, storedIdToImp, errors);
    }

    public static StoredDataResult map(ResultSet resultSet) {
        return JdbcStoredDataResultMapper.map(resultSet, null, Collections.emptySet(), Collections.emptySet());
    }

    private static void addStoredItem(String accountId, String id, String data, Map<String, Set<StoredItem>> idToStoredItems) {
        StoredItem storedItem = StoredItem.of(accountId, data);
        Set<StoredItem> storedItems = idToStoredItems.get(id);
        if (storedItems == null) {
            idToStoredItems.put(id, new HashSet<StoredItem>(Collections.singleton(storedItem)));
        } else {
            storedItems.add(storedItem);
        }
    }

    private static Map<String, String> storedItemsOrAddError(StoredDataType type, String accountId, Set<String> searchIds, Map<String, Set<StoredItem>> foundIdToStoredItems, List<String> errors) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (searchIds.isEmpty()) {
            for (Map.Entry<String, Set<StoredItem>> entry : foundIdToStoredItems.entrySet()) {
                entry.getValue().forEach(storedItem -> result.put((String)entry.getKey(), storedItem.getData()));
            }
        } else {
            for (String id : searchIds) {
                try {
                    StoredItem resolvedStoredItem = StoredItemResolver.resolve(type, accountId, id, foundIdToStoredItems.get(id));
                    result.put(id, resolvedStoredItem.getData());
                }
                catch (PreBidException e) {
                    errors.add(e.getMessage());
                }
            }
        }
        return result;
    }
}

