/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.settings;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.execution.Timeout;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.settings.ApplicationSettings;
import org.prebid.server.settings.helper.JdbcStoredDataResultMapper;
import org.prebid.server.settings.helper.JdbcStoredResponseResultMapper;
import org.prebid.server.settings.model.Account;
import org.prebid.server.settings.model.StoredDataResult;
import org.prebid.server.settings.model.StoredResponseDataResult;
import org.prebid.server.vertx.jdbc.JdbcClient;

public class JdbcApplicationSettings
implements ApplicationSettings {
    private static final String ACCOUNT_ID_PLACEHOLDER = "%ACCOUNT_ID%";
    private static final String REQUEST_ID_PLACEHOLDER = "%REQUEST_ID_LIST%";
    private static final String IMP_ID_PLACEHOLDER = "%IMP_ID_LIST%";
    private static final String RESPONSE_ID_PLACEHOLDER = "%RESPONSE_ID_LIST%";
    private static final String QUERY_PARAM_PLACEHOLDER = "?";
    private final JdbcClient jdbcClient;
    private final JacksonMapper mapper;
    private final String selectAccountQuery;
    private final String selectStoredRequestsQuery;
    private final String selectAmpStoredRequestsQuery;
    private final String selectStoredResponsesQuery;

    public JdbcApplicationSettings(JdbcClient jdbcClient, JacksonMapper mapper, String selectAccountQuery, String selectStoredRequestsQuery, String selectAmpStoredRequestsQuery, String selectStoredResponsesQuery) {
        this.jdbcClient = Objects.requireNonNull(jdbcClient);
        this.mapper = Objects.requireNonNull(mapper);
        this.selectAccountQuery = Objects.requireNonNull(selectAccountQuery).replace(ACCOUNT_ID_PLACEHOLDER, QUERY_PARAM_PLACEHOLDER);
        this.selectStoredRequestsQuery = Objects.requireNonNull(selectStoredRequestsQuery);
        this.selectAmpStoredRequestsQuery = Objects.requireNonNull(selectAmpStoredRequestsQuery);
        this.selectStoredResponsesQuery = Objects.requireNonNull(selectStoredResponsesQuery);
    }

    @Override
    public Future<Account> getAccountById(String accountId, Timeout timeout) {
        return this.jdbcClient.executeQuery(this.selectAccountQuery, Collections.singletonList(accountId), result -> this.mapToModelOrError((ResultSet)result, row -> this.toAccount(row.getString(0))), timeout).compose(result -> JdbcApplicationSettings.failedIfNull(result, accountId, "Account"));
    }

    @Override
    public Future<Map<String, String>> getCategories(String primaryAdServer, String publisher, Timeout timeout) {
        return Future.failedFuture((Throwable)new PreBidException("Not supported"));
    }

    private <T> T mapToModelOrError(ResultSet result, Function<JsonArray, T> mapper) {
        return result != null && CollectionUtils.isNotEmpty((Collection)result.getResults()) ? (T)mapper.apply((JsonArray)result.getResults().get(0)) : null;
    }

    private static <T> Future<T> failedIfNull(T value, String id, String errorPrefix) {
        return value != null ? Future.succeededFuture(value) : Future.failedFuture((Throwable)new PreBidException("%s not found: %s".formatted(errorPrefix, id)));
    }

    private Account toAccount(String source) {
        try {
            return source != null ? this.mapper.decodeValue(source, Account.class) : null;
        }
        catch (DecodeException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    @Override
    public Future<StoredDataResult> getStoredData(String accountId, Set<String> requestIds, Set<String> impIds, Timeout timeout) {
        return this.fetchStoredData(this.selectStoredRequestsQuery, accountId, requestIds, impIds, timeout);
    }

    @Override
    public Future<StoredDataResult> getAmpStoredData(String accountId, Set<String> requestIds, Set<String> impIds, Timeout timeout) {
        return this.fetchStoredData(this.selectAmpStoredRequestsQuery, accountId, requestIds, Collections.emptySet(), timeout);
    }

    @Override
    public Future<StoredDataResult> getVideoStoredData(String accountId, Set<String> requestIds, Set<String> impIds, Timeout timeout) {
        return this.fetchStoredData(this.selectStoredRequestsQuery, accountId, requestIds, impIds, timeout);
    }

    @Override
    public Future<StoredResponseDataResult> getStoredResponses(Set<String> responseIds, Timeout timeout) {
        String queryResolvedWithParameters = this.selectStoredResponsesQuery.replaceAll(RESPONSE_ID_PLACEHOLDER, JdbcApplicationSettings.parameterHolders(responseIds.size()));
        ArrayList<Object> idsQueryParameters = new ArrayList<Object>();
        IntStream.rangeClosed(1, StringUtils.countMatches((CharSequence)this.selectStoredResponsesQuery, (CharSequence)RESPONSE_ID_PLACEHOLDER)).forEach(i -> idsQueryParameters.addAll(responseIds));
        return this.jdbcClient.executeQuery(queryResolvedWithParameters, idsQueryParameters, result -> JdbcStoredResponseResultMapper.map(result, responseIds), timeout);
    }

    private Future<StoredDataResult> fetchStoredData(String query, String accountId, Set<String> requestIds, Set<String> impIds, Timeout timeout) {
        Future<StoredDataResult> future;
        if (CollectionUtils.isEmpty(requestIds) && CollectionUtils.isEmpty(impIds)) {
            future = Future.succeededFuture((Object)StoredDataResult.of(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList()));
        } else {
            ArrayList<Object> idsQueryParameters = new ArrayList<Object>();
            IntStream.rangeClosed(1, StringUtils.countMatches((CharSequence)query, (CharSequence)REQUEST_ID_PLACEHOLDER)).forEach(i -> idsQueryParameters.addAll(requestIds));
            IntStream.rangeClosed(1, StringUtils.countMatches((CharSequence)query, (CharSequence)IMP_ID_PLACEHOLDER)).forEach(i -> idsQueryParameters.addAll(impIds));
            String parametrizedQuery = JdbcApplicationSettings.createParametrizedQuery(query, requestIds.size(), impIds.size());
            future = this.jdbcClient.executeQuery(parametrizedQuery, idsQueryParameters, result -> JdbcStoredDataResultMapper.map(result, accountId, requestIds, impIds), timeout);
        }
        return future;
    }

    private static String createParametrizedQuery(String query, int requestIdsSize, int impIdsSize) {
        return query.replace(REQUEST_ID_PLACEHOLDER, JdbcApplicationSettings.parameterHolders(requestIdsSize)).replace(IMP_ID_PLACEHOLDER, JdbcApplicationSettings.parameterHolders(impIdsSize));
    }

    private static String parameterHolders(int paramsSize) {
        return paramsSize == 0 ? "NULL" : IntStream.range(0, paramsSize).mapToObj(i -> QUERY_PARAM_PLACEHOLDER).collect(Collectors.joining(","));
    }
}

