/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.protobuf.response;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.protobuf.GeneratedMessageV3;
import com.iab.openrtb.response.Asset;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.DataObject;
import com.iab.openrtb.response.EventTracker;
import com.iab.openrtb.response.ImageObject;
import com.iab.openrtb.response.Link;
import com.iab.openrtb.response.Response;
import com.iab.openrtb.response.SeatBid;
import com.iab.openrtb.response.TitleObject;
import com.iab.openrtb.response.VideoObject;
import com.iabtechlab.openrtb.v2.OpenRtb;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.prebid.server.proto.openrtb.ext.response.ExtBidResponse;
import org.prebid.server.protobuf.ProtobufMapper;
import org.prebid.server.protobuf.response.ProtobufBackwardExtensionMapper;
import org.prebid.server.protobuf.response.ProtobufJsonExtensionMapper;
import org.prebid.server.protobuf.response.ResponseExtensionMappersSpecification;

public class ProtobufResponseUtils {
    private ProtobufResponseUtils() {
    }

    public static ProtobufMapper<OpenRtb.BidResponse, BidResponse> bidResponseMapper(ResponseExtensionMappersSpecification spec) {
        ProtobufMapper<OpenRtb.NativeResponse.Link, Link> linkMapper = ProtobufResponseUtils.linkMapper(spec.linkExtMapper());
        ProtobufMapper<OpenRtb.NativeResponse, Response> nativeResponseMapper = ProtobufResponseUtils.nativeResponseMapper(ProtobufResponseUtils.assetMapper(ProtobufResponseUtils.titleMapper(spec.titleExtMapper()), ProtobufResponseUtils.nativeImageMapper(spec.imageExtMapper()), ProtobufResponseUtils.nativeVideoMapper(), ProtobufResponseUtils.nativeDataMapper(spec.dataExtMapper()), linkMapper, spec.assetExtMapper()), linkMapper, ProtobufResponseUtils.eventTrackerMapper(spec.eventTrackerExtMapper()), spec.nativeResponseExtMapper());
        ProtobufMapper<OpenRtb.BidResponse.SeatBid, SeatBid> seatBidMapper = ProtobufResponseUtils.seatBidMapper(ProtobufResponseUtils.bidMapper(ProtobufResponseUtils.nativeResponseMapper(spec.objectMapper(), nativeResponseMapper), spec.bidExtMapper()), spec.seatBidExtMapper());
        return ProtobufResponseUtils.bidResponseMapper(seatBidMapper, spec.bidResponseExtMapper());
    }

    public static <ProtobufExtensionType> ProtobufMapper<OpenRtb.BidResponse, BidResponse> bidResponseMapper(ProtobufMapper<OpenRtb.BidResponse.SeatBid, SeatBid> seatBidMapper, ProtobufBackwardExtensionMapper<OpenRtb.BidResponse, ProtobufExtensionType, ExtBidResponse> extensionMapper) {
        return bidResponse -> BidResponse.builder().id(bidResponse.getId()).seatbid(bidResponse.getSeatbidList().stream().map(seatBidMapper::map).toList()).bidid(bidResponse.getBidid()).cur(bidResponse.getCur()).customdata(bidResponse.getCustomdata()).nbr(bidResponse.getNbr()).ext((ExtBidResponse)ProtobufResponseUtils.extractExtension(extensionMapper, bidResponse)).build();
    }

    public static <ProtobufExtensionType> ProtobufMapper<OpenRtb.NativeResponse.Asset, Asset> assetMapper(ProtobufMapper<OpenRtb.NativeResponse.Asset.Title, TitleObject> titleMapper, ProtobufMapper<OpenRtb.NativeResponse.Asset.Image, ImageObject> imageMapper, ProtobufMapper<OpenRtb.NativeResponse.Asset.Video, VideoObject> videoMapper, ProtobufMapper<OpenRtb.NativeResponse.Asset.Data, DataObject> dataMapper, ProtobufMapper<OpenRtb.NativeResponse.Link, Link> linkMapper, ProtobufJsonExtensionMapper<OpenRtb.NativeResponse.Asset, ProtobufExtensionType> extensionMapper) {
        return asset -> Asset.builder().id(asset.getId()).required(BooleanUtils.toInteger((boolean)asset.getRequired())).title((TitleObject)titleMapper.map(asset.getTitle())).img((ImageObject)imageMapper.map(asset.getImg())).video((VideoObject)videoMapper.map(asset.getVideo())).data((DataObject)dataMapper.map(asset.getData())).link((Link)linkMapper.map(asset.getLink())).ext((ObjectNode)ProtobufResponseUtils.extractExtension(extensionMapper, asset)).build();
    }

    public static <ProtobufExtensionType> ProtobufMapper<OpenRtb.BidResponse.SeatBid.Bid, Bid> bidMapper(ProtobufMapper<OpenRtb.NativeResponse, String> nativeResponseMapper, ProtobufJsonExtensionMapper<OpenRtb.BidResponse.SeatBid.Bid, ProtobufExtensionType> extensionMapper) {
        return bid -> {
            String adm = bid.getAdm();
            String resolvedAdm = adm.isEmpty() ? (String)nativeResponseMapper.map(bid.getAdmNative()) : adm;
            return Bid.builder().id(bid.getId()).impid(bid.getImpid()).price(BigDecimal.valueOf(bid.getPrice())).nurl(bid.getNurl()).burl(bid.getBurl()).lurl(bid.getLurl()).adm(resolvedAdm).adid(bid.getAdid()).adomain((List<String>)bid.getAdomainList()).bundle(bid.getBundle()).iurl(bid.getIurl()).cid(bid.getCid()).crid(bid.getCrid()).tactic(bid.getTactic()).cat((List<String>)bid.getCatList()).attr(bid.getAttrList()).api(bid.getApi()).protocol(bid.getProtocol()).qagmediarating(bid.getQagmediarating()).language(bid.getLanguage()).dealid(bid.getDealid()).w(bid.getW()).h(bid.getH()).wratio(bid.getWratio()).hratio(bid.getHratio()).exp(bid.getExp()).ext((ObjectNode)ProtobufResponseUtils.extractExtension(extensionMapper, bid)).build();
        };
    }

    public static <ProtobufExtensionType> ProtobufMapper<OpenRtb.NativeResponse.Asset.Data, DataObject> nativeDataMapper(ProtobufJsonExtensionMapper<OpenRtb.NativeResponse.Asset.Data, ProtobufExtensionType> extensionMapper) {
        return data -> DataObject.builder().type(data.getType()).len(data.getLen()).value(data.getValue()).ext((ObjectNode)ProtobufResponseUtils.extractExtension(extensionMapper, data)).build();
    }

    public static <ProtobufExtensionType> ProtobufMapper<OpenRtb.NativeResponse.EventTracker, EventTracker> eventTrackerMapper(ProtobufJsonExtensionMapper<OpenRtb.NativeResponse.EventTracker, ProtobufExtensionType> extensionMapper) {
        return eventTracker -> EventTracker.builder().event(eventTracker.getEvent()).method(eventTracker.getMethod()).url(eventTracker.getUrl()).ext((ObjectNode)ProtobufResponseUtils.extractExtension(extensionMapper, eventTracker)).build();
    }

    public static <ProtobufExtensionType> ProtobufMapper<OpenRtb.NativeResponse.Asset.Image, ImageObject> nativeImageMapper(ProtobufJsonExtensionMapper<OpenRtb.NativeResponse.Asset.Image, ProtobufExtensionType> extensionMapper) {
        return image -> ImageObject.builder().type(image.getType()).url(image.getUrl()).w(image.getW()).h(image.getH()).ext((ObjectNode)ProtobufResponseUtils.extractExtension(extensionMapper, image)).build();
    }

    public static <ProtobufExtensionType> ProtobufMapper<OpenRtb.NativeResponse.Link, Link> linkMapper(ProtobufJsonExtensionMapper<OpenRtb.NativeResponse.Link, ProtobufExtensionType> extensionMapper) {
        return link -> Link.of(link.getUrl(), (List<String>)link.getClicktrackersList(), link.getFallback(), (ObjectNode)ProtobufResponseUtils.extractExtension(extensionMapper, link));
    }

    public static ProtobufMapper<OpenRtb.NativeResponse, String> nativeResponseMapper(ObjectMapper objectMapper, ProtobufMapper<OpenRtb.NativeResponse, Response> responseMapper) {
        return nativeResponse -> {
            try {
                Response response = (Response)responseMapper.map((OpenRtb.NativeResponse)nativeResponse);
                return objectMapper.writeValueAsString((Object)response);
            }
            catch (JsonProcessingException e) {
                return null;
            }
        };
    }

    public static <ProtobufExtensionType> ProtobufMapper<OpenRtb.NativeResponse, Response> nativeResponseMapper(ProtobufMapper<OpenRtb.NativeResponse.Asset, Asset> assetMapper, ProtobufMapper<OpenRtb.NativeResponse.Link, Link> linkMapper, ProtobufMapper<OpenRtb.NativeResponse.EventTracker, EventTracker> eventTrackerMapper, ProtobufJsonExtensionMapper<OpenRtb.NativeResponse, ProtobufExtensionType> extensionMapper) {
        return response -> Response.builder().ver(response.getVer()).assets(response.getAssetsList().stream().map(assetMapper::map).toList()).assetsurl(response.getAssetsurl()).dcourl(response.getDcourl()).link((Link)linkMapper.map(response.getLink())).imptrackers((List<String>)response.getImptrackersList()).jstracker(response.getJstracker()).eventtrackers(response.getEventtrackersList().stream().map(eventTrackerMapper::map).toList()).privacy(response.getPrivacy()).ext((ObjectNode)ProtobufResponseUtils.extractExtension(extensionMapper, response)).build();
    }

    public static <ProtobufExtensionType> ProtobufMapper<OpenRtb.BidResponse.SeatBid, SeatBid> seatBidMapper(ProtobufMapper<OpenRtb.BidResponse.SeatBid.Bid, Bid> bidMapper, ProtobufJsonExtensionMapper<OpenRtb.BidResponse.SeatBid, ProtobufExtensionType> extensionMapper) {
        return seatBid -> SeatBid.builder().bid(seatBid.getBidList().stream().map(bidMapper::map).toList()).seat(seatBid.getSeat()).group(BooleanUtils.toInteger((boolean)seatBid.getGroup())).ext((ObjectNode)ProtobufResponseUtils.extractExtension(extensionMapper, seatBid)).build();
    }

    public static <ProtobufExtensionType> ProtobufMapper<OpenRtb.NativeResponse.Asset.Title, TitleObject> titleMapper(ProtobufJsonExtensionMapper<OpenRtb.NativeResponse.Asset.Title, ProtobufExtensionType> extensionMapper) {
        return title -> TitleObject.builder().text(title.getText()).len(title.getLen()).ext((ObjectNode)ProtobufResponseUtils.extractExtension(extensionMapper, title)).build();
    }

    public static ProtobufMapper<OpenRtb.NativeResponse.Asset.Video, VideoObject> nativeVideoMapper() {
        return video -> VideoObject.builder().vasttag(video.getVasttag()).build();
    }

    private static <ContainingType extends GeneratedMessageV3.ExtendableMessage<ContainingType>, FromType, ToType> ToType extractExtension(ProtobufBackwardExtensionMapper<ContainingType, FromType, ToType> mapper, ContainingType value) {
        if (mapper == null || value == null) {
            return null;
        }
        return mapper.map(value.getExtension(mapper.extensionDescriptor()));
    }
}

