/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.proto.response;

import java.beans.ConstructorProperties;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.proto.response.UsersyncInfo;

public final class BidderUsersyncStatus {
    private final String bidder;
    private final String error;
    private final Boolean noCookie;
    private final UsersyncInfo usersync;

    public boolean isError() {
        return StringUtils.isNotEmpty((CharSequence)this.error);
    }

    @ConstructorProperties(value={"bidder", "error", "noCookie", "usersync"})
    BidderUsersyncStatus(String bidder, String error, Boolean noCookie, UsersyncInfo usersync) {
        this.bidder = bidder;
        this.error = error;
        this.noCookie = noCookie;
        this.usersync = usersync;
    }

    public static BidderUsersyncStatusBuilder builder() {
        return new BidderUsersyncStatusBuilder();
    }

    public String getBidder() {
        return this.bidder;
    }

    public String getError() {
        return this.error;
    }

    public Boolean getNoCookie() {
        return this.noCookie;
    }

    public UsersyncInfo getUsersync() {
        return this.usersync;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BidderUsersyncStatus)) {
            return false;
        }
        BidderUsersyncStatus other = (BidderUsersyncStatus)o;
        Boolean this$noCookie = this.getNoCookie();
        Boolean other$noCookie = other.getNoCookie();
        if (this$noCookie == null ? other$noCookie != null : !((Object)this$noCookie).equals(other$noCookie)) {
            return false;
        }
        String this$bidder = this.getBidder();
        String other$bidder = other.getBidder();
        if (this$bidder == null ? other$bidder != null : !this$bidder.equals(other$bidder)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
            return false;
        }
        UsersyncInfo this$usersync = this.getUsersync();
        UsersyncInfo other$usersync = other.getUsersync();
        return !(this$usersync == null ? other$usersync != null : !((Object)this$usersync).equals(other$usersync));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $noCookie = this.getNoCookie();
        result = result * 59 + ($noCookie == null ? 43 : ((Object)$noCookie).hashCode());
        String $bidder = this.getBidder();
        result = result * 59 + ($bidder == null ? 43 : $bidder.hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        UsersyncInfo $usersync = this.getUsersync();
        result = result * 59 + ($usersync == null ? 43 : ((Object)$usersync).hashCode());
        return result;
    }

    public String toString() {
        return "BidderUsersyncStatus(bidder=" + this.getBidder() + ", error=" + this.getError() + ", noCookie=" + this.getNoCookie() + ", usersync=" + this.getUsersync() + ")";
    }

    public static class BidderUsersyncStatusBuilder {
        private String bidder;
        private String error;
        private Boolean noCookie;
        private UsersyncInfo usersync;

        public BidderUsersyncStatusBuilder conditionalError(boolean condition, String error) {
            this.error = condition ? error : this.error;
            return this;
        }

        BidderUsersyncStatusBuilder() {
        }

        public BidderUsersyncStatusBuilder bidder(String bidder) {
            this.bidder = bidder;
            return this;
        }

        public BidderUsersyncStatusBuilder error(String error) {
            this.error = error;
            return this;
        }

        public BidderUsersyncStatusBuilder noCookie(Boolean noCookie) {
            this.noCookie = noCookie;
            return this;
        }

        public BidderUsersyncStatusBuilder usersync(UsersyncInfo usersync) {
            this.usersync = usersync;
            return this;
        }

        public BidderUsersyncStatus build() {
            return new BidderUsersyncStatus(this.bidder, this.error, this.noCookie, this.usersync);
        }

        public String toString() {
            return "BidderUsersyncStatus.BidderUsersyncStatusBuilder(bidder=" + this.bidder + ", error=" + this.error + ", noCookie=" + this.noCookie + ", usersync=" + this.usersync + ")";
        }
    }
}

