/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.proto.openrtb.ext.request;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.TreeMap;
import org.prebid.server.proto.openrtb.ext.request.ImpMediaType;

public final class ExtRequestBidAdjustmentFactors {
    private final Map<String, BigDecimal> adjustments = new TreeMap<String, BigDecimal>(String.CASE_INSENSITIVE_ORDER);
    private final EnumMap<ImpMediaType, Map<String, BigDecimal>> mediatypes;

    @JsonAnyGetter
    public Map<String, BigDecimal> getAdjustments() {
        return Collections.unmodifiableMap(this.adjustments);
    }

    @JsonAnySetter
    public void addFactor(String key, BigDecimal value) {
        this.adjustments.put(key, value);
    }

    @ConstructorProperties(value={"mediatypes"})
    ExtRequestBidAdjustmentFactors(EnumMap<ImpMediaType, Map<String, BigDecimal>> mediatypes) {
        this.mediatypes = mediatypes;
    }

    public static ExtRequestBidAdjustmentFactorsBuilder builder() {
        return new ExtRequestBidAdjustmentFactorsBuilder();
    }

    public ExtRequestBidAdjustmentFactorsBuilder toBuilder() {
        return new ExtRequestBidAdjustmentFactorsBuilder().mediatypes(this.mediatypes);
    }

    public EnumMap<ImpMediaType, Map<String, BigDecimal>> getMediatypes() {
        return this.mediatypes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExtRequestBidAdjustmentFactors)) {
            return false;
        }
        ExtRequestBidAdjustmentFactors other = (ExtRequestBidAdjustmentFactors)o;
        Map<String, BigDecimal> this$adjustments = this.getAdjustments();
        Map<String, BigDecimal> other$adjustments = other.getAdjustments();
        if (this$adjustments == null ? other$adjustments != null : !((Object)this$adjustments).equals(other$adjustments)) {
            return false;
        }
        EnumMap<ImpMediaType, Map<String, BigDecimal>> this$mediatypes = this.getMediatypes();
        EnumMap<ImpMediaType, Map<String, BigDecimal>> other$mediatypes = other.getMediatypes();
        return !(this$mediatypes == null ? other$mediatypes != null : !((Object)this$mediatypes).equals(other$mediatypes));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, BigDecimal> $adjustments = this.getAdjustments();
        result = result * 59 + ($adjustments == null ? 43 : ((Object)$adjustments).hashCode());
        EnumMap<ImpMediaType, Map<String, BigDecimal>> $mediatypes = this.getMediatypes();
        result = result * 59 + ($mediatypes == null ? 43 : ((Object)$mediatypes).hashCode());
        return result;
    }

    public String toString() {
        return "ExtRequestBidAdjustmentFactors(adjustments=" + this.getAdjustments() + ", mediatypes=" + this.getMediatypes() + ")";
    }

    public static class ExtRequestBidAdjustmentFactorsBuilder {
        private EnumMap<ImpMediaType, Map<String, BigDecimal>> mediatypes;

        ExtRequestBidAdjustmentFactorsBuilder() {
        }

        public ExtRequestBidAdjustmentFactorsBuilder mediatypes(EnumMap<ImpMediaType, Map<String, BigDecimal>> mediatypes) {
            this.mediatypes = mediatypes;
            return this;
        }

        public ExtRequestBidAdjustmentFactors build() {
            return new ExtRequestBidAdjustmentFactors(this.mediatypes);
        }

        public String toString() {
            return "ExtRequestBidAdjustmentFactors.ExtRequestBidAdjustmentFactorsBuilder(mediatypes=" + this.mediatypes + ")";
        }
    }
}

