/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.privacy.gdpr.tcfstrategies.purpose.typestrategies;

import com.iabtcf.decoder.TCString;
import com.iabtcf.utils.IntIterable;
import java.util.Collection;
import org.prebid.server.privacy.gdpr.model.VendorPermission;
import org.prebid.server.privacy.gdpr.model.VendorPermissionWithGvl;
import org.prebid.server.privacy.gdpr.vendorlist.proto.PurposeCode;

public abstract class EnforcePurposeStrategy {
    public abstract Collection<VendorPermission> allowedByTypeStrategy(PurposeCode var1, TCString var2, Collection<VendorPermissionWithGvl> var3, Collection<VendorPermissionWithGvl> var4, boolean var5);

    protected boolean isAllowedBySimpleConsentOrLegitimateInterest(PurposeCode purpose, Integer vendorId, boolean isEnforceVendor, TCString tcString) {
        return this.isAllowedBySimpleConsent(purpose, vendorId, isEnforceVendor, tcString) || this.isAllowedByLegitimateInterest(purpose, vendorId, isEnforceVendor, tcString);
    }

    protected boolean isAllowedBySimpleConsent(PurposeCode purpose, Integer vendorId, boolean isEnforceVendor, TCString tcString) {
        IntIterable purposesConsent = tcString.getPurposesConsent();
        IntIterable vendorConsent = tcString.getVendorConsent();
        return this.isAllowedByConsents(purpose, vendorId, isEnforceVendor, purposesConsent, vendorConsent);
    }

    protected boolean isAllowedByLegitimateInterest(PurposeCode purpose, Integer vendorId, boolean isEnforceVendor, TCString tcString) {
        IntIterable purposesConsent = tcString.getPurposesLITransparency();
        IntIterable vendorConsent = tcString.getVendorLegitimateInterest();
        return this.isAllowedByConsents(purpose, vendorId, isEnforceVendor, purposesConsent, vendorConsent);
    }

    private boolean isAllowedByConsents(PurposeCode purpose, Integer vendorId, boolean isEnforceVendors, IntIterable purposesConsent, IntIterable vendorConsent) {
        boolean isPurposeAllowed = purposesConsent.contains(purpose.code());
        boolean isVendorAllowed = !isEnforceVendors || vendorConsent.contains(vendorId.intValue());
        return isPurposeAllowed && isVendorAllowed;
    }

    protected static Collection<VendorPermission> toVendorPermissions(Collection<VendorPermissionWithGvl> vendorPermissionWithGvls) {
        return vendorPermissionWithGvls.stream().map(VendorPermissionWithGvl::getVendorPermission).toList();
    }
}

