/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.privacy.gdpr;

import com.iabtcf.decoder.DecoderOption;
import com.iabtcf.decoder.TCString;
import io.vertx.core.Future;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.auction.IpAddressHelper;
import org.prebid.server.auction.model.IpAddress;
import org.prebid.server.bidder.BidderCatalog;
import org.prebid.server.execution.Timeout;
import org.prebid.server.geolocation.GeoLocationService;
import org.prebid.server.geolocation.model.GeoInfo;
import org.prebid.server.log.ConditionalLogger;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.Metrics;
import org.prebid.server.privacy.gdpr.Tcf2Service;
import org.prebid.server.privacy.gdpr.VendorIdResolver;
import org.prebid.server.privacy.gdpr.model.PrivacyEnforcementAction;
import org.prebid.server.privacy.gdpr.model.RequestLogInfo;
import org.prebid.server.privacy.gdpr.model.TCStringEmpty;
import org.prebid.server.privacy.gdpr.model.TcfContext;
import org.prebid.server.privacy.gdpr.model.TcfResponse;
import org.prebid.server.privacy.gdpr.model.VendorPermission;
import org.prebid.server.privacy.model.Privacy;
import org.prebid.server.settings.model.AccountGdprConfig;
import org.prebid.server.settings.model.EnabledForRequestType;
import org.prebid.server.settings.model.GdprConfig;

public class TcfDefinerService {
    private static final Logger logger = LoggerFactory.getLogger(TcfDefinerService.class);
    private static final ConditionalLogger AMP_CORRUPT_CONSENT_LOGGER = new ConditionalLogger("amp_corrupt_consent", logger);
    private static final ConditionalLogger APP_CORRUPT_CONSENT_LOGGER = new ConditionalLogger("app_corrupt_consent", logger);
    private static final ConditionalLogger SITE_CORRUPT_CONSENT_LOGGER = new ConditionalLogger("site_corrupt_consent", logger);
    private static final ConditionalLogger DOOH_CORRUPT_CONSENT_LOGGER = new ConditionalLogger("dooh_corrupt_consent", logger);
    private static final ConditionalLogger UNDEFINED_CORRUPT_CONSENT_LOGGER = new ConditionalLogger("undefined_corrupt_consent", logger);
    private static final String GDPR_ENABLED = "1";
    private final boolean gdprEnabled;
    private final String gdprDefaultValue;
    private final boolean consentStringMeansInScope;
    private final Tcf2Service tcf2Service;
    private final Set<String> eeaCountries;
    private final GeoLocationService geoLocationService;
    private final BidderCatalog bidderCatalog;
    private final IpAddressHelper ipAddressHelper;
    private final Metrics metrics;

    public TcfDefinerService(GdprConfig gdprConfig, Set<String> eeaCountries, Tcf2Service tcf2Service, GeoLocationService geoLocationService, BidderCatalog bidderCatalog, IpAddressHelper ipAddressHelper, Metrics metrics) {
        this.gdprEnabled = gdprConfig != null && BooleanUtils.isNotFalse((Boolean)gdprConfig.getEnabled());
        this.gdprDefaultValue = gdprConfig != null ? gdprConfig.getDefaultValue() : null;
        this.consentStringMeansInScope = gdprConfig != null && BooleanUtils.isTrue((Boolean)gdprConfig.getConsentStringMeansInScope());
        this.tcf2Service = Objects.requireNonNull(tcf2Service);
        this.eeaCountries = Objects.requireNonNull(eeaCountries);
        this.geoLocationService = geoLocationService;
        this.bidderCatalog = Objects.requireNonNull(bidderCatalog);
        this.ipAddressHelper = Objects.requireNonNull(ipAddressHelper);
        this.metrics = Objects.requireNonNull(metrics);
    }

    public Future<TcfContext> resolveTcfContext(Privacy privacy, String country, String ipAddress, AccountGdprConfig accountGdprConfig, MetricName requestType, RequestLogInfo requestLogInfo, Timeout timeout) {
        Future<TcfContext> tcfContextFuture = !this.isGdprEnabled(accountGdprConfig, requestType) ? Future.succeededFuture((Object)TcfContext.empty()) : this.prepareTcfContext(privacy, country, ipAddress, requestLogInfo, timeout);
        return tcfContextFuture.map(this::updateTcfGeoMetrics);
    }

    public Future<TcfContext> resolveTcfContext(Privacy privacy, String ipAddress, AccountGdprConfig accountGdprConfig, MetricName requestType, RequestLogInfo requestLogInfo, Timeout timeout) {
        return this.resolveTcfContext(privacy, null, ipAddress, accountGdprConfig, requestType, requestLogInfo, timeout);
    }

    public Future<TcfResponse<Integer>> resultForVendorIds(Set<Integer> vendorIds, TcfContext tcfContext) {
        return this.resultForInternal(tcfContext, country -> this.createAllowAllTcfResponse((Set)vendorIds, (String)country), (tcfConsent, country) -> this.tcf2Service.permissionsFor(vendorIds, (TCString)tcfConsent).map(vendorPermissions -> TcfDefinerService.createVendorIdTcfResponse(vendorPermissions, country)));
    }

    public Future<TcfResponse<String>> resultForBidderNames(Set<String> bidderNames, VendorIdResolver vendorIdResolver, TcfContext tcfContext, AccountGdprConfig accountGdprConfig) {
        return this.resultForInternal(tcfContext, country -> this.createAllowAllTcfResponse((Set)bidderNames, (String)country), (consentString, country) -> this.tcf2Service.permissionsFor(bidderNames, vendorIdResolver, (TCString)consentString, accountGdprConfig).map(vendorPermissions -> TcfDefinerService.createBidderNameTcfResponse(vendorPermissions, country)));
    }

    public Future<TcfResponse<String>> resultForBidderNames(Set<String> bidderNames, TcfContext tcfContext, AccountGdprConfig accountGdprConfig) {
        return this.resultForBidderNames(bidderNames, VendorIdResolver.of(this.bidderCatalog), tcfContext, accountGdprConfig);
    }

    private <T> Future<TcfResponse<T>> resultForInternal(TcfContext tcfContext, Function<String, Future<TcfResponse<T>>> allowAllTcfResponseCreator, BiFunction<TCString, String, Future<TcfResponse<T>>> tcf2Strategy) {
        String country;
        GeoInfo geoInfo = tcfContext.getGeoInfo();
        String string = country = geoInfo != null ? geoInfo.getCountry() : null;
        if (!tcfContext.isInGdprScope()) {
            return allowAllTcfResponseCreator.apply(country);
        }
        return tcf2Strategy.apply(tcfContext.getConsent(), country);
    }

    private boolean isGdprEnabled(AccountGdprConfig accountGdprConfig, MetricName requestType) {
        Boolean accountGdprEnabled;
        Boolean bl = accountGdprEnabled = accountGdprConfig != null ? accountGdprConfig.getEnabled() : null;
        if (requestType == null) {
            return (Boolean)ObjectUtils.firstNonNull((Object[])new Boolean[]{accountGdprEnabled, this.gdprEnabled});
        }
        EnabledForRequestType enabledForRequestType = accountGdprConfig != null ? accountGdprConfig.getEnabledForRequestType() : null;
        Boolean enabledForType = enabledForRequestType != null ? enabledForRequestType.isEnabledFor(requestType) : null;
        return (Boolean)ObjectUtils.firstNonNull((Object[])new Boolean[]{enabledForType, accountGdprEnabled, this.gdprEnabled});
    }

    private Future<TcfContext> prepareTcfContext(Privacy privacy, String country, String ipAddress, RequestLogInfo requestLogInfo, Timeout timeout) {
        String consentString = privacy.getConsentString();
        TCStringParsingResult consentStringParsingResult = this.parseConsentString(consentString, requestLogInfo);
        TCString consent = consentStringParsingResult.getResult();
        boolean consentValid = TcfDefinerService.isConsentValid(consent);
        String effectiveIpAddress = this.maybeMaskIp(ipAddress, consent);
        Boolean inEea = this.isCountryInEea(country);
        TcfContext defaultContext = TcfContext.builder().inGdprScope(TcfDefinerService.inScopeOfGdpr(this.gdprDefaultValue)).consentString(consentString).consent(consent).consentValid(consentValid).inEea(inEea).ipAddress(effectiveIpAddress).warnings(consentStringParsingResult.getWarnings()).build();
        if (this.consentStringMeansInScope && consentValid) {
            return Future.succeededFuture((Object)defaultContext.toBuilder().inGdprScope(true).build());
        }
        String gdpr = privacy.getGdpr();
        if (StringUtils.isNotEmpty((CharSequence)gdpr)) {
            return Future.succeededFuture((Object)defaultContext.toBuilder().inGdprScope(TcfDefinerService.inScopeOfGdpr(gdpr)).build());
        }
        if (country != null) {
            return Future.succeededFuture((Object)defaultContext.toBuilder().inGdprScope(this.inScopeOfGdpr(inEea)).build());
        }
        if (ipAddress != null && this.geoLocationService != null) {
            return this.geoLocationService.lookup(effectiveIpAddress, timeout).map(geoInfo -> this.updateMetricsAndEnrichWithGeo((GeoInfo)geoInfo, defaultContext)).recover(error -> this.logError((Throwable)error, defaultContext));
        }
        return Future.succeededFuture((Object)defaultContext);
    }

    private String maybeMaskIp(String ipAddress, TCString consent) {
        if (!TcfDefinerService.shouldMaskIp(consent)) {
            return ipAddress;
        }
        IpAddress ip = this.ipAddressHelper.toIpAddress(ipAddress);
        if (ip == null) {
            return ipAddress;
        }
        return ip.getVersion() == IpAddress.IP.v4 ? this.ipAddressHelper.maskIpv4(ipAddress) : this.ipAddressHelper.anonymizeIpv6(ipAddress);
    }

    private static boolean shouldMaskIp(TCString consent) {
        return TcfDefinerService.isConsentValid(consent) && consent.getVersion() == 2 && !consent.getSpecialFeatureOptIns().contains(1);
    }

    private TcfContext updateMetricsAndEnrichWithGeo(GeoInfo geoInfo, TcfContext tcfContext) {
        this.metrics.updateGeoLocationMetric(true);
        Boolean inEea = this.isCountryInEea(geoInfo.getCountry());
        boolean inScope = this.inScopeOfGdpr(inEea);
        return tcfContext.toBuilder().geoInfo(geoInfo).inGdprScope(inScope).inEea(inEea).build();
    }

    private Future<TcfContext> logError(Throwable error, TcfContext tcfContext) {
        String message = "Geolocation lookup failed: " + error.getMessage();
        logger.warn((Object)message);
        logger.debug((Object)message, error);
        this.metrics.updateGeoLocationMetric(false);
        return Future.succeededFuture((Object)tcfContext);
    }

    private Boolean isCountryInEea(String country) {
        return country != null ? Boolean.valueOf(this.eeaCountries.contains(country)) : null;
    }

    private TcfContext updateTcfGeoMetrics(TcfContext tcfContext) {
        if (tcfContext.isInGdprScope()) {
            this.metrics.updatePrivacyTcfGeoMetric(tcfContext.getConsent().getVersion(), tcfContext.getInEea());
        }
        return tcfContext;
    }

    private <T> Future<TcfResponse<T>> createAllowAllTcfResponse(Set<T> keys, String country) {
        return Future.succeededFuture(TcfResponse.of(false, TcfDefinerService.allowAll(keys), country));
    }

    private static TcfResponse<Integer> createVendorIdTcfResponse(Collection<VendorPermission> vendorPermissions, String country) {
        return TcfResponse.of(true, vendorPermissions.stream().collect(Collectors.toMap(VendorPermission::getVendorId, VendorPermission::getPrivacyEnforcementAction)), country);
    }

    private static TcfResponse<String> createBidderNameTcfResponse(Collection<VendorPermission> vendorPermissions, String country) {
        return TcfResponse.of(true, vendorPermissions.stream().collect(Collectors.toMap(VendorPermission::getBidderName, VendorPermission::getPrivacyEnforcementAction)), country);
    }

    private static <T> Map<T, PrivacyEnforcementAction> allowAll(Collection<T> identifiers) {
        return identifiers.stream().collect(Collectors.toMap(Function.identity(), ignored -> PrivacyEnforcementAction.allowAll()));
    }

    private static boolean inScopeOfGdpr(String gdpr) {
        return Objects.equals(gdpr, GDPR_ENABLED);
    }

    private boolean inScopeOfGdpr(Boolean inEea) {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)inEea, (boolean)TcfDefinerService.inScopeOfGdpr(this.gdprDefaultValue));
    }

    private TCStringParsingResult parseConsentString(String consentString, RequestLogInfo requestLogInfo) {
        ArrayList<String> warnings = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)consentString)) {
            this.metrics.updatePrivacyTcfMissingMetric();
            return TCStringParsingResult.of(TCStringEmpty.create(), warnings);
        }
        TCString tcString = this.decodeTcString(consentString, requestLogInfo, warnings);
        if (tcString == null) {
            this.metrics.updatePrivacyTcfInvalidMetric();
            return TCStringParsingResult.of(TCStringEmpty.create(), warnings);
        }
        return this.toValidResult(consentString, TCStringParsingResult.of(tcString, warnings));
    }

    private TCStringParsingResult toValidResult(String consentString, TCStringParsingResult parsingResult) {
        List<String> warnings = parsingResult.getWarnings();
        TCString tcString = parsingResult.getResult();
        int version = tcString.getVersion();
        this.metrics.updatePrivacyTcfRequestsMetric(version);
        if (version == 1) {
            warnings.add("Parsing consent string:\"" + consentString + "\" failed. TCF version 1 is deprecated and treated as corrupted TCF version 2");
            return TCStringParsingResult.of(TCStringEmpty.create(), warnings);
        }
        int tcfPolicyVersion = tcString.getTcfPolicyVersion();
        if (tcfPolicyVersion > 4) {
            warnings.add("Parsing consent string: %s failed. TCF policy version %d is not supported".formatted(consentString, tcfPolicyVersion));
            return TCStringParsingResult.of(TCStringEmpty.create(), warnings);
        }
        return TCStringParsingResult.of(tcString, warnings);
    }

    private TCString decodeTcString(String consentString, RequestLogInfo requestLogInfo, List<String> warnings) {
        try {
            return TCString.decode((String)consentString, (DecoderOption[])new DecoderOption[0]);
        }
        catch (Exception e) {
            TcfDefinerService.logWarn(consentString, e.getMessage(), requestLogInfo);
            warnings.add("Parsing consent string:\"%s\" - failed. %s".formatted(consentString, e.getMessage()));
            return null;
        }
    }

    private static void logWarn(String consent, String message, RequestLogInfo requestLogInfo) {
        if (requestLogInfo == null || requestLogInfo.getRequestType() == null) {
            String exceptionMessage = "Parsing consent string:\"%s\" failed for undefined type with exception %s".formatted(consent, message);
            UNDEFINED_CORRUPT_CONSENT_LOGGER.info(exceptionMessage, 100);
            return;
        }
        switch (requestLogInfo.getRequestType()) {
            case amp: {
                AMP_CORRUPT_CONSENT_LOGGER.info(TcfDefinerService.logMessage(consent, MetricName.amp.toString(), requestLogInfo, message), 100);
                break;
            }
            case openrtb2app: {
                APP_CORRUPT_CONSENT_LOGGER.info(TcfDefinerService.logMessage(consent, MetricName.openrtb2app.toString(), requestLogInfo, message), 100);
                break;
            }
            case openrtb2dooh: {
                DOOH_CORRUPT_CONSENT_LOGGER.info(TcfDefinerService.logMessage(consent, MetricName.openrtb2dooh.toString(), requestLogInfo, message), 100);
                break;
            }
            case openrtb2web: {
                SITE_CORRUPT_CONSENT_LOGGER.info(TcfDefinerService.logMessage(consent, MetricName.openrtb2web.toString(), requestLogInfo, message), 100);
                break;
            }
            default: {
                UNDEFINED_CORRUPT_CONSENT_LOGGER.info(TcfDefinerService.logMessage(consent, "video or sync or setuid", requestLogInfo, message), 100);
            }
        }
    }

    private static String logMessage(String consent, String type, RequestLogInfo requestLogInfo, String message) {
        return "Parsing consent string: \"%s\" failed for: %s type for account id: %s with ref: %s with exception: %s".formatted(consent, type, requestLogInfo.getAccountId(), requestLogInfo.getRefUrl(), message);
    }

    private static boolean isConsentValid(TCString consent) {
        return consent != null && !(consent instanceof TCStringEmpty);
    }

    public static boolean isConsentStringValid(String consentString) {
        try {
            TCString.decode((String)consentString, (DecoderOption[])new DecoderOption[0]);
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private static final class TCStringParsingResult {
        private final TCString result;
        private final List<String> warnings;

        @ConstructorProperties(value={"result", "warnings"})
        private TCStringParsingResult(TCString result, List<String> warnings) {
            this.result = result;
            this.warnings = warnings;
        }

        public static TCStringParsingResult of(TCString result, List<String> warnings) {
            return new TCStringParsingResult(result, warnings);
        }

        public TCString getResult() {
            return this.result;
        }

        public List<String> getWarnings() {
            return this.warnings;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TCStringParsingResult)) {
                return false;
            }
            TCStringParsingResult other = (TCStringParsingResult)o;
            TCString this$result = this.getResult();
            TCString other$result = other.getResult();
            if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
                return false;
            }
            List<String> this$warnings = this.getWarnings();
            List<String> other$warnings = other.getWarnings();
            return !(this$warnings == null ? other$warnings != null : !((Object)this$warnings).equals(other$warnings));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TCString $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            List<String> $warnings = this.getWarnings();
            result = result * 59 + ($warnings == null ? 43 : ((Object)$warnings).hashCode());
            return result;
        }

        public String toString() {
            return "TcfDefinerService.TCStringParsingResult(result=" + this.getResult() + ", warnings=" + this.getWarnings() + ")";
        }
    }
}

