/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.privacy;

import io.vertx.core.Future;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.prebid.server.execution.Timeout;
import org.prebid.server.metric.MetricName;
import org.prebid.server.privacy.gdpr.TcfDefinerService;
import org.prebid.server.privacy.gdpr.VendorIdResolver;
import org.prebid.server.privacy.gdpr.model.HostVendorTcfResponse;
import org.prebid.server.privacy.gdpr.model.PrivacyEnforcementAction;
import org.prebid.server.privacy.gdpr.model.RequestLogInfo;
import org.prebid.server.privacy.gdpr.model.TcfContext;
import org.prebid.server.privacy.gdpr.model.TcfResponse;
import org.prebid.server.privacy.model.Privacy;
import org.prebid.server.settings.model.AccountGdprConfig;

public class HostVendorTcfDefinerService {
    private static final Logger logger = LoggerFactory.getLogger(HostVendorTcfDefinerService.class);
    private final TcfDefinerService tcfDefinerService;
    private final Integer gdprHostVendorId;

    public HostVendorTcfDefinerService(TcfDefinerService tcfDefinerService, Integer gdprHostVendorId) {
        this.tcfDefinerService = Objects.requireNonNull(tcfDefinerService);
        this.gdprHostVendorId = HostVendorTcfDefinerService.validateHostVendorId(gdprHostVendorId);
    }

    private static Integer validateHostVendorId(Integer gdprHostVendorId) {
        if (gdprHostVendorId == null) {
            logger.warn((Object)"gdpr.host-vendor-id not specified. Will skip host company GDPR checks");
        }
        return gdprHostVendorId;
    }

    public Integer getGdprHostVendorId() {
        return this.gdprHostVendorId;
    }

    public Future<HostVendorTcfResponse> isAllowedForHostVendorId(TcfContext tcfContext) {
        return this.gdprHostVendorId == null ? Future.succeededFuture((Object)HostVendorTcfResponse.allowedVendor()) : this.tcfDefinerService.resultForVendorIds(Collections.singleton(this.gdprHostVendorId), tcfContext).map(this::toHostVendorTcfResponse);
    }

    private HostVendorTcfResponse toHostVendorTcfResponse(TcfResponse<Integer> tcfResponse) {
        return HostVendorTcfResponse.of(tcfResponse.getUserInGdprScope(), tcfResponse.getCountry(), this.isCookieSyncAllowed(tcfResponse));
    }

    private boolean isCookieSyncAllowed(TcfResponse<Integer> hostTcfResponse) {
        return Optional.ofNullable(hostTcfResponse.getActions()).map(vendorIdToAction -> (PrivacyEnforcementAction)vendorIdToAction.get(this.gdprHostVendorId)).map(hostActions -> !hostActions.isBlockPixelSync()).orElse(false);
    }

    public Future<TcfContext> resolveTcfContext(Privacy privacy, String country, String ipAddress, AccountGdprConfig accountGdprConfig, MetricName requestType, RequestLogInfo requestLogInfo, Timeout timeout) {
        return this.tcfDefinerService.resolveTcfContext(privacy, country, ipAddress, accountGdprConfig, requestType, requestLogInfo, timeout);
    }

    public Future<TcfContext> resolveTcfContext(Privacy privacy, String ipAddress, AccountGdprConfig accountGdprConfig, MetricName requestType, RequestLogInfo requestLogInfo, Timeout timeout) {
        return this.tcfDefinerService.resolveTcfContext(privacy, ipAddress, accountGdprConfig, requestType, requestLogInfo, timeout);
    }

    public Future<TcfResponse<Integer>> resultForVendorIds(Set<Integer> vendorIds, TcfContext tcfContext) {
        return this.tcfDefinerService.resultForVendorIds(vendorIds, tcfContext);
    }

    public Future<TcfResponse<String>> resultForBidderNames(Set<String> bidderNames, VendorIdResolver vendorIdResolver, TcfContext tcfContext, AccountGdprConfig accountGdprConfig) {
        return this.tcfDefinerService.resultForBidderNames(bidderNames, vendorIdResolver, tcfContext, accountGdprConfig);
    }

    public Future<TcfResponse<String>> resultForBidderNames(Set<String> bidderNames, TcfContext tcfContext, AccountGdprConfig accountGdprConfig) {
        return this.tcfDefinerService.resultForBidderNames(bidderNames, tcfContext, accountGdprConfig);
    }
}

