/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.metric;

import com.codahale.metrics.MetricRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.prebid.server.metric.CounterType;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.TcfMetrics;
import org.prebid.server.metric.UpdatableMetrics;

class UserSyncMetrics
extends UpdatableMetrics {
    private final Function<String, BidderUserSyncMetrics> bidderUserSyncMetricsCreator = bidder -> new BidderUserSyncMetrics(metricRegistry, counterType, (String)bidder);
    private final Map<String, BidderUserSyncMetrics> bidderUserSyncMetrics = new HashMap<String, BidderUserSyncMetrics>();

    UserSyncMetrics(MetricRegistry metricRegistry, CounterType counterType) {
        super(Objects.requireNonNull(metricRegistry), Objects.requireNonNull(counterType), metricName -> "usersync." + metricName);
    }

    BidderUserSyncMetrics forBidder(String bidder) {
        return this.bidderUserSyncMetrics.computeIfAbsent(bidder.toLowerCase(), this.bidderUserSyncMetricsCreator);
    }

    static class BidderUserSyncMetrics
    extends UpdatableMetrics {
        private final TcfMetrics tcfMetrics;

        BidderUserSyncMetrics(MetricRegistry metricRegistry, CounterType counterType, String bidder) {
            super(Objects.requireNonNull(metricRegistry), Objects.requireNonNull(counterType), BidderUserSyncMetrics.nameCreator(Objects.requireNonNull(BidderUserSyncMetrics.createUserSyncPrefix(bidder))));
            this.tcfMetrics = new TcfMetrics(metricRegistry, counterType, BidderUserSyncMetrics.createUserSyncPrefix(bidder));
        }

        TcfMetrics tcf() {
            return this.tcfMetrics;
        }

        private static String createUserSyncPrefix(String bidder) {
            return "usersync." + bidder;
        }

        private static Function<MetricName, String> nameCreator(String prefix) {
            return metricName -> "%s.%s".formatted(prefix, metricName);
        }
    }
}

