/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.metric;

import com.codahale.metrics.MetricRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.prebid.server.metric.CounterType;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.UpdatableMetrics;

class SettingsCacheMetrics
extends UpdatableMetrics {
    private final Function<MetricName, RefreshSettingsCacheMetrics> refreshSettingsCacheMetricsCreator = refreshType -> new RefreshSettingsCacheMetrics(metricRegistry, counterType, SettingsCacheMetrics.createPrefix(type), (MetricName)((Object)refreshType));
    private final Map<MetricName, RefreshSettingsCacheMetrics> refreshSettingsCacheMetrics = new HashMap<MetricName, RefreshSettingsCacheMetrics>();

    SettingsCacheMetrics(MetricRegistry metricRegistry, CounterType counterType, MetricName type) {
        super(Objects.requireNonNull(metricRegistry), Objects.requireNonNull(counterType), SettingsCacheMetrics.nameCreator(SettingsCacheMetrics.createPrefix(Objects.requireNonNull(type))));
    }

    RefreshSettingsCacheMetrics forRefreshType(MetricName refreshType) {
        return this.refreshSettingsCacheMetrics.computeIfAbsent(refreshType, this.refreshSettingsCacheMetricsCreator);
    }

    private static String createPrefix(MetricName type) {
        return "settings.cache." + type.toString();
    }

    private static Function<MetricName, String> nameCreator(String prefix) {
        return metricName -> "%s.%s".formatted(prefix, metricName);
    }

    static class RefreshSettingsCacheMetrics
    extends UpdatableMetrics {
        RefreshSettingsCacheMetrics(MetricRegistry metricRegistry, CounterType counterType, String prefix, MetricName type) {
            super(Objects.requireNonNull(metricRegistry), Objects.requireNonNull(counterType), RefreshSettingsCacheMetrics.nameCreator(RefreshSettingsCacheMetrics.createPrefix(Objects.requireNonNull(prefix), Objects.requireNonNull(type))));
        }

        private static String createPrefix(String prefix, MetricName type) {
            return "%s.refresh.%s".formatted(new Object[]{prefix, type});
        }

        private static Function<MetricName, String> nameCreator(String prefix) {
            return metricName -> "%s.%s".formatted(prefix, metricName);
        }
    }
}

