/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.metric;

import com.codahale.metrics.MetricRegistry;
import com.iab.openrtb.request.Imp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.prebid.server.activity.Activity;
import org.prebid.server.hooks.execution.model.ExecutionAction;
import org.prebid.server.hooks.execution.model.ExecutionStatus;
import org.prebid.server.hooks.execution.model.Stage;
import org.prebid.server.metric.AccountMetrics;
import org.prebid.server.metric.AccountMetricsVerbosityResolver;
import org.prebid.server.metric.AdapterTypeMetrics;
import org.prebid.server.metric.AlertsAccountConfigMetric;
import org.prebid.server.metric.AlertsConfigMetrics;
import org.prebid.server.metric.AnalyticsReporterMetrics;
import org.prebid.server.metric.BidderCardinalityMetrics;
import org.prebid.server.metric.CacheMetrics;
import org.prebid.server.metric.CircuitBreakerMetrics;
import org.prebid.server.metric.CookieSyncMetrics;
import org.prebid.server.metric.CounterType;
import org.prebid.server.metric.CurrencyRatesMetrics;
import org.prebid.server.metric.HookImplMetrics;
import org.prebid.server.metric.HooksMetrics;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.ModuleMetrics;
import org.prebid.server.metric.PgMetrics;
import org.prebid.server.metric.PriceFloorMetrics;
import org.prebid.server.metric.PrivacyMetrics;
import org.prebid.server.metric.RequestStatusMetrics;
import org.prebid.server.metric.RequestsMetrics;
import org.prebid.server.metric.SettingsCacheMetrics;
import org.prebid.server.metric.TcfMetrics;
import org.prebid.server.metric.TimeoutNotificationMetrics;
import org.prebid.server.metric.UpdatableMetrics;
import org.prebid.server.metric.UserSyncMetrics;
import org.prebid.server.metric.model.AccountMetricsVerbosityLevel;
import org.prebid.server.settings.model.Account;

public class Metrics
extends UpdatableMetrics {
    private static final String ALL_REQUEST_BIDDERS = "all";
    private final AccountMetricsVerbosityResolver accountMetricsVerbosityResolver;
    private final Function<MetricName, RequestStatusMetrics> requestMetricsCreator;
    private final Function<String, AccountMetrics> accountMetricsCreator;
    private final Function<String, AdapterTypeMetrics> adapterMetricsCreator;
    private final Function<String, AnalyticsReporterMetrics> analyticMetricsCreator;
    private final Function<String, PriceFloorMetrics> priceFloorsMetricsCreator;
    private final Function<Integer, BidderCardinalityMetrics> bidderCardinalityMetricsCreator;
    private final Function<MetricName, CircuitBreakerMetrics> circuitBreakerMetricsCreator;
    private final Function<MetricName, SettingsCacheMetrics> settingsCacheMetricsCreator;
    private final RequestsMetrics requestsMetrics;
    private final Map<MetricName, RequestStatusMetrics> requestMetrics;
    private final Map<String, AccountMetrics> accountMetrics;
    private final Map<String, AdapterTypeMetrics> adapterMetrics;
    private final Map<String, AnalyticsReporterMetrics> analyticMetrics;
    private final Map<String, PriceFloorMetrics> priceFloorsMetrics;
    private final AlertsConfigMetrics alertsMetrics;
    private final Map<Integer, BidderCardinalityMetrics> bidderCardinailtyMetrics;
    private final UserSyncMetrics userSyncMetrics;
    private final CookieSyncMetrics cookieSyncMetrics;
    private final PrivacyMetrics privacyMetrics;
    private final Map<MetricName, CircuitBreakerMetrics> circuitBreakerMetrics;
    private final CacheMetrics cacheMetrics;
    private final TimeoutNotificationMetrics timeoutNotificationMetrics;
    private final CurrencyRatesMetrics currencyRatesMetrics;
    private final Map<MetricName, SettingsCacheMetrics> settingsCacheMetrics;
    private final HooksMetrics hooksMetrics;
    private final PgMetrics pgMetrics;

    public Metrics(MetricRegistry metricRegistry, CounterType counterType, AccountMetricsVerbosityResolver accountMetricsVerbosityResolver) {
        super(metricRegistry, counterType, MetricName::toString);
        this.accountMetricsVerbosityResolver = Objects.requireNonNull(accountMetricsVerbosityResolver);
        this.requestMetricsCreator = requestType -> new RequestStatusMetrics(metricRegistry, counterType, (MetricName)((Object)requestType));
        this.accountMetricsCreator = account -> new AccountMetrics(metricRegistry, counterType, (String)account);
        this.adapterMetricsCreator = adapterType -> new AdapterTypeMetrics(metricRegistry, counterType, (String)adapterType);
        this.bidderCardinalityMetricsCreator = cardinality -> new BidderCardinalityMetrics(metricRegistry, counterType, (Integer)cardinality);
        this.analyticMetricsCreator = analyticCode -> new AnalyticsReporterMetrics(metricRegistry, counterType, (String)analyticCode);
        this.priceFloorsMetricsCreator = moduleType -> new PriceFloorMetrics(metricRegistry, counterType, (String)moduleType);
        this.circuitBreakerMetricsCreator = type -> new CircuitBreakerMetrics(metricRegistry, counterType, (MetricName)((Object)type));
        this.settingsCacheMetricsCreator = type -> new SettingsCacheMetrics(metricRegistry, counterType, (MetricName)((Object)type));
        this.requestsMetrics = new RequestsMetrics(metricRegistry, counterType);
        this.requestMetrics = new EnumMap<MetricName, RequestStatusMetrics>(MetricName.class);
        this.accountMetrics = new HashMap<String, AccountMetrics>();
        this.adapterMetrics = new HashMap<String, AdapterTypeMetrics>();
        this.analyticMetrics = new HashMap<String, AnalyticsReporterMetrics>();
        this.priceFloorsMetrics = new HashMap<String, PriceFloorMetrics>();
        this.alertsMetrics = new AlertsConfigMetrics(metricRegistry, counterType);
        this.bidderCardinailtyMetrics = new HashMap<Integer, BidderCardinalityMetrics>();
        this.userSyncMetrics = new UserSyncMetrics(metricRegistry, counterType);
        this.cookieSyncMetrics = new CookieSyncMetrics(metricRegistry, counterType);
        this.privacyMetrics = new PrivacyMetrics(metricRegistry, counterType);
        this.circuitBreakerMetrics = new HashMap<MetricName, CircuitBreakerMetrics>();
        this.cacheMetrics = new CacheMetrics(metricRegistry, counterType);
        this.timeoutNotificationMetrics = new TimeoutNotificationMetrics(metricRegistry, counterType);
        this.currencyRatesMetrics = new CurrencyRatesMetrics(metricRegistry, counterType);
        this.settingsCacheMetrics = new HashMap<MetricName, SettingsCacheMetrics>();
        this.hooksMetrics = new HooksMetrics(metricRegistry, counterType);
        this.pgMetrics = new PgMetrics(metricRegistry, counterType);
    }

    RequestsMetrics requests() {
        return this.requestsMetrics;
    }

    RequestStatusMetrics forRequestType(MetricName requestType) {
        return this.requestMetrics.computeIfAbsent(requestType, this.requestMetricsCreator);
    }

    BidderCardinalityMetrics forBidderCardinality(int cardinality) {
        return this.bidderCardinailtyMetrics.computeIfAbsent(cardinality, this.bidderCardinalityMetricsCreator);
    }

    AccountMetrics forAccount(String accountId) {
        return this.accountMetrics.computeIfAbsent(accountId, this.accountMetricsCreator);
    }

    AdapterTypeMetrics forAdapter(String adapterType) {
        return this.adapterMetrics.computeIfAbsent(adapterType.toLowerCase(), this.adapterMetricsCreator);
    }

    AnalyticsReporterMetrics forAnalyticReporter(String analyticCode) {
        return this.analyticMetrics.computeIfAbsent(analyticCode, this.analyticMetricsCreator);
    }

    PriceFloorMetrics forPriceFloorFetch() {
        return this.priceFloorsMetrics.computeIfAbsent("fetch", this.priceFloorsMetricsCreator);
    }

    PriceFloorMetrics forPriceFloorGeneralErrors() {
        return this.priceFloorsMetrics.computeIfAbsent("general", this.priceFloorsMetricsCreator);
    }

    AlertsAccountConfigMetric configFailedForAccount(String accountId) {
        return this.alertsMetrics.accountConfig(accountId);
    }

    UserSyncMetrics userSync() {
        return this.userSyncMetrics;
    }

    PgMetrics pgMetrics() {
        return this.pgMetrics;
    }

    CookieSyncMetrics cookieSync() {
        return this.cookieSyncMetrics;
    }

    PrivacyMetrics privacy() {
        return this.privacyMetrics;
    }

    CircuitBreakerMetrics forCircuitBreakerType(MetricName type) {
        return this.circuitBreakerMetrics.computeIfAbsent(type, this.circuitBreakerMetricsCreator);
    }

    CacheMetrics cache() {
        return this.cacheMetrics;
    }

    CurrencyRatesMetrics currencyRates() {
        return this.currencyRatesMetrics;
    }

    SettingsCacheMetrics forSettingsCacheType(MetricName type) {
        return this.settingsCacheMetrics.computeIfAbsent(type, this.settingsCacheMetricsCreator);
    }

    HooksMetrics hooks() {
        return this.hooksMetrics;
    }

    public void updateAppAndNoCookieAndImpsRequestedMetrics(boolean isApp, boolean liveUidsPresent, int numImps) {
        if (isApp) {
            this.incCounter(MetricName.app_requests);
        } else if (!liveUidsPresent) {
            this.incCounter(MetricName.no_cookie_requests);
        }
        this.incCounter(MetricName.imps_requested, numImps);
    }

    public void updateImpTypesMetrics(List<Imp> imps) {
        Map<String, Long> mediaTypeToCount = imps.stream().map(Metrics::getPresentMediaTypes).flatMap(Collection::stream).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        this.updateImpTypesMetrics(mediaTypeToCount);
    }

    void updateImpTypesMetrics(Map<String, Long> countPerMediaType) {
        for (Map.Entry<String, Long> mediaTypeCount : countPerMediaType.entrySet()) {
            switch (mediaTypeCount.getKey()) {
                case "banner": {
                    this.incCounter(MetricName.imps_banner, mediaTypeCount.getValue());
                    break;
                }
                case "video": {
                    this.incCounter(MetricName.imps_video, mediaTypeCount.getValue());
                    break;
                }
                case "native": {
                    this.incCounter(MetricName.imps_native, mediaTypeCount.getValue());
                    break;
                }
                case "audio": {
                    this.incCounter(MetricName.imps_audio, mediaTypeCount.getValue());
                }
            }
        }
    }

    private static List<String> getPresentMediaTypes(Imp imp) {
        ArrayList<String> impMediaTypes = new ArrayList<String>();
        if (imp.getBanner() != null) {
            impMediaTypes.add("banner");
        }
        if (imp.getVideo() != null) {
            impMediaTypes.add("video");
        }
        if (imp.getXNative() != null) {
            impMediaTypes.add("native");
        }
        if (imp.getAudio() != null) {
            impMediaTypes.add("audio");
        }
        return impMediaTypes;
    }

    public void updateRequestTimeMetric(MetricName requestType, long millis) {
        this.updateTimer(requestType, millis);
    }

    public void updateRequestTypeMetric(MetricName requestType, MetricName requestStatus) {
        this.forRequestType(requestType).incCounter(requestStatus);
    }

    public void updateRequestBidderCardinalityMetric(int bidderCardinality) {
        this.forBidderCardinality(bidderCardinality).incCounter(MetricName.requests);
    }

    public void updateAccountRequestMetrics(Account account, MetricName requestType) {
        AccountMetricsVerbosityLevel verbosityLevel = this.accountMetricsVerbosityResolver.forAccount(account);
        if (verbosityLevel.isAtLeast(AccountMetricsVerbosityLevel.basic)) {
            AccountMetrics accountMetrics = this.forAccount(account.getId());
            accountMetrics.incCounter(MetricName.requests);
            if (verbosityLevel.isAtLeast(AccountMetricsVerbosityLevel.detailed)) {
                accountMetrics.requestType(requestType).incCounter(MetricName.requests);
            }
        }
    }

    public void updateAccountRequestRejectedByInvalidAccountMetrics(String accountId) {
        this.updateAccountRequestsMetrics(accountId, MetricName.rejected_by_invalid_account);
    }

    public void updateAccountRequestRejectedByInvalidStoredImpMetrics(String accountId) {
        this.updateAccountRequestsMetrics(accountId, MetricName.rejected_by_invalid_stored_impr);
    }

    public void updateAccountRequestRejectedByInvalidStoredRequestMetrics(String accountId) {
        this.updateAccountRequestsMetrics(accountId, MetricName.rejected_by_invalid_stored_request);
    }

    private void updateAccountRequestsMetrics(String accountId, MetricName metricName) {
        this.forAccount(accountId).requests().incCounter(metricName);
    }

    public void updateAdapterRequestTypeAndNoCookieMetrics(String bidder, MetricName requestType, boolean noCookie) {
        AdapterTypeMetrics adapterTypeMetrics = this.forAdapter(bidder);
        adapterTypeMetrics.requestType(requestType).incCounter(MetricName.requests);
        if (noCookie) {
            adapterTypeMetrics.incCounter(MetricName.no_cookie_requests);
        }
    }

    public void updateAdapterResponseTime(String bidder, Account account, int responseTime) {
        AdapterTypeMetrics adapterTypeMetrics = this.forAdapter(bidder);
        adapterTypeMetrics.updateTimer(MetricName.request_time, responseTime);
        if (this.accountMetricsVerbosityResolver.forAccount(account).isAtLeast(AccountMetricsVerbosityLevel.detailed)) {
            AdapterTypeMetrics accountAdapterMetrics = this.forAccount(account.getId()).adapter().forAdapter(bidder);
            accountAdapterMetrics.updateTimer(MetricName.request_time, responseTime);
        }
    }

    public void updateAdapterRequestNobidMetrics(String bidder, Account account) {
        this.forAdapter(bidder).request().incCounter(MetricName.nobid);
        if (this.accountMetricsVerbosityResolver.forAccount(account).isAtLeast(AccountMetricsVerbosityLevel.detailed)) {
            this.forAccount(account.getId()).adapter().forAdapter(bidder).request().incCounter(MetricName.nobid);
        }
    }

    public void updateAdapterRequestGotbidsMetrics(String bidder, Account account) {
        this.forAdapter(bidder).request().incCounter(MetricName.gotbids);
        if (this.accountMetricsVerbosityResolver.forAccount(account).isAtLeast(AccountMetricsVerbosityLevel.detailed)) {
            this.forAccount(account.getId()).adapter().forAdapter(bidder).request().incCounter(MetricName.gotbids);
        }
    }

    public void updateAdapterBidMetrics(String bidder, Account account, long cpm, boolean isAdm, String bidType) {
        AdapterTypeMetrics adapterTypeMetrics = this.forAdapter(bidder);
        adapterTypeMetrics.updateHistogram(MetricName.prices, cpm);
        adapterTypeMetrics.incCounter(MetricName.bids_received);
        adapterTypeMetrics.forBidType(bidType).incCounter(isAdm ? MetricName.adm_bids_received : MetricName.nurl_bids_received);
        if (this.accountMetricsVerbosityResolver.forAccount(account).isAtLeast(AccountMetricsVerbosityLevel.detailed)) {
            AdapterTypeMetrics accountAdapterMetrics = this.forAccount(account.getId()).adapter().forAdapter(bidder);
            accountAdapterMetrics.updateHistogram(MetricName.prices, cpm);
            accountAdapterMetrics.incCounter(MetricName.bids_received);
        }
    }

    public void updateAdapterRequestErrorMetric(String bidder, MetricName errorMetric) {
        this.forAdapter(bidder).request().incCounter(errorMetric);
    }

    public void updateAnalyticEventMetric(String analyticCode, MetricName eventType, MetricName result) {
        this.forAnalyticReporter(analyticCode).forEventType(eventType).incCounter(result);
    }

    public void updatePriceFloorFetchMetric(MetricName result) {
        this.forPriceFloorFetch().incCounter(result);
    }

    public void updatePriceFloorGeneralAlertsMetric(MetricName result) {
        this.forPriceFloorGeneralErrors().incCounter(result);
    }

    public void updateAlertsMetrics(MetricName metricName) {
        this.alertsMetrics.incCounter(metricName);
    }

    public void updateAlertsConfigFailed(String accountId, MetricName metricName) {
        this.configFailedForAccount(accountId).incCounter(metricName);
    }

    public void updateSizeValidationMetrics(String bidder, String accountId, MetricName type) {
        this.forAdapter(bidder).response().validation().size().incCounter(type);
        this.forAccount(accountId).response().validation().size().incCounter(type);
    }

    public void updateSecureValidationMetrics(String bidder, String accountId, MetricName type) {
        this.forAdapter(bidder).response().validation().secure().incCounter(type);
        this.forAccount(accountId).response().validation().secure().incCounter(type);
    }

    public void updateUserSyncOptoutMetric() {
        this.userSync().incCounter(MetricName.opt_outs);
    }

    public void updateUserSyncBadRequestMetric() {
        this.userSync().incCounter(MetricName.bad_requests);
    }

    public void updateUserSyncSetsMetric(String bidder) {
        this.userSync().forBidder(bidder).incCounter(MetricName.sets);
    }

    public void updateUserSyncTcfBlockedMetric(String bidder) {
        this.userSync().forBidder(bidder).tcf().incCounter(MetricName.blocked);
    }

    public void updateUserSyncSizeBlockedMetric(String cookieFamilyName) {
        this.userSync().forBidder(cookieFamilyName).incCounter(MetricName.sizeblocked);
    }

    public void updateUserSyncSizedOutMetric(String cookieFamilyName) {
        this.userSync().forBidder(cookieFamilyName).incCounter(MetricName.sizedout);
    }

    public void updateUserSyncTcfInvalidMetric(String bidder) {
        this.userSync().forBidder(bidder).tcf().incCounter(MetricName.invalid);
    }

    public void updateUserSyncTcfInvalidMetric() {
        this.updateUserSyncTcfInvalidMetric(ALL_REQUEST_BIDDERS);
    }

    public void updateCookieSyncFilteredMetric(String bidder) {
        this.cookieSync().forBidder(bidder).incCounter(MetricName.filtered);
    }

    public void updateCookieSyncRequestMetric() {
        this.incCounter(MetricName.cookie_sync_requests);
    }

    public void updateCookieSyncTcfBlockedMetric(String bidder) {
        this.cookieSync().forBidder(bidder).tcf().incCounter(MetricName.blocked);
    }

    public void updateAuctionTcfMetrics(String bidder, MetricName requestType, boolean userIdRemoved, boolean geoMasked, boolean analyticsBlocked, boolean requestBlocked) {
        TcfMetrics tcf = this.forAdapter(bidder).requestType(requestType).tcf();
        if (userIdRemoved) {
            tcf.incCounter(MetricName.userid_removed);
        }
        if (geoMasked) {
            tcf.incCounter(MetricName.geo_masked);
        }
        if (analyticsBlocked) {
            tcf.incCounter(MetricName.analytics_blocked);
        }
        if (requestBlocked) {
            tcf.incCounter(MetricName.request_blocked);
        }
    }

    public void updatePrivacyCoppaMetric() {
        this.privacy().incCounter(MetricName.coppa);
    }

    public void updatePrivacyLmtMetric() {
        this.privacy().incCounter(MetricName.lmt);
    }

    public void updatePrivacyCcpaMetrics(boolean isSpecified, boolean isEnforced) {
        if (isSpecified) {
            this.privacy().usp().incCounter(MetricName.specified);
        }
        if (isEnforced) {
            this.privacy().usp().incCounter(MetricName.opt_out);
        }
    }

    public void updatePrivacyTcfMissingMetric() {
        this.privacy().tcf().incCounter(MetricName.missing);
    }

    public void updatePrivacyTcfInvalidMetric() {
        this.privacy().tcf().incCounter(MetricName.invalid);
    }

    public void updatePrivacyTcfRequestsMetric(int version) {
        TcfMetrics.TcfVersionMetrics versionMetrics = this.privacy().tcf().fromVersion(version);
        versionMetrics.incCounter(MetricName.requests);
    }

    public void updatePrivacyTcfGeoMetric(int version, Boolean inEea) {
        TcfMetrics.TcfVersionMetrics versionMetrics = this.privacy().tcf().fromVersion(version);
        MetricName metricName = inEea == null ? MetricName.unknown_geo : (inEea != false ? MetricName.in_geo : MetricName.out_geo);
        versionMetrics.incCounter(metricName);
    }

    public void updatePrivacyTcfVendorListMissingMetric(int version) {
        this.updatePrivacyTcfVendorListMetric(version, MetricName.missing);
    }

    public void updatePrivacyTcfVendorListOkMetric(int version) {
        this.updatePrivacyTcfVendorListMetric(version, MetricName.ok);
    }

    public void updatePrivacyTcfVendorListErrorMetric(int version) {
        this.updatePrivacyTcfVendorListMetric(version, MetricName.err);
    }

    public void updatePrivacyTcfVendorListFallbackMetric(int version) {
        this.updatePrivacyTcfVendorListMetric(version, MetricName.fallback);
    }

    private void updatePrivacyTcfVendorListMetric(int version, MetricName metricName) {
        TcfMetrics tcfMetrics = this.privacy().tcf();
        tcfMetrics.fromVersion(version).vendorList().incCounter(metricName);
    }

    public void updateConnectionAcceptErrors() {
        this.incCounter(MetricName.connection_accept_errors);
    }

    public void updateDatabaseQueryTimeMetric(long millis) {
        this.updateTimer(MetricName.db_query_time, millis);
    }

    public void createDatabaseCircuitBreakerGauge(BooleanSupplier stateSupplier) {
        this.forCircuitBreakerType(MetricName.db).createGauge(MetricName.opened, () -> stateSupplier.getAsBoolean() ? 1L : 0L);
    }

    public void createHttpClientCircuitBreakerGauge(String name, BooleanSupplier stateSupplier) {
        this.forCircuitBreakerType(MetricName.http).forName(name).createGauge(MetricName.opened, () -> stateSupplier.getAsBoolean() ? 1L : 0L);
    }

    public void removeHttpClientCircuitBreakerGauge(String name) {
        this.forCircuitBreakerType(MetricName.http).forName(name).removeMetric(MetricName.opened);
    }

    public void createHttpClientCircuitBreakerNumberGauge(LongSupplier numberSupplier) {
        this.forCircuitBreakerType(MetricName.http).createGauge(MetricName.existing, numberSupplier);
    }

    public void updatePlannerRequestMetric(boolean successful) {
        this.pgMetrics().incCounter(MetricName.planner_requests);
        if (successful) {
            this.pgMetrics().incCounter(MetricName.planner_request_successful);
        } else {
            this.pgMetrics().incCounter(MetricName.planner_request_failed);
        }
    }

    public void updateDeliveryRequestMetric(boolean successful) {
        this.pgMetrics().incCounter(MetricName.delivery_requests);
        if (successful) {
            this.pgMetrics().incCounter(MetricName.delivery_request_successful);
        } else {
            this.pgMetrics().incCounter(MetricName.delivery_request_failed);
        }
    }

    public void updateWinEventRequestMetric(boolean successful) {
        this.incCounter(MetricName.win_requests);
        if (successful) {
            this.incCounter(MetricName.win_request_successful);
        } else {
            this.incCounter(MetricName.win_request_failed);
        }
    }

    public void updateUserDetailsRequestMetric(boolean successful) {
        this.incCounter(MetricName.user_details_requests);
        if (successful) {
            this.incCounter(MetricName.user_details_request_successful);
        } else {
            this.incCounter(MetricName.user_details_request_failed);
        }
    }

    public void updateWinRequestTime(long millis) {
        this.updateTimer(MetricName.win_request_time, millis);
    }

    public void updateLineItemsNumberMetric(long count) {
        this.pgMetrics().incCounter(MetricName.planner_lineitems_received, count);
    }

    public void updatePlannerRequestTime(long millis) {
        this.pgMetrics().updateTimer(MetricName.planner_request_time, millis);
    }

    public void updateDeliveryRequestTime(long millis) {
        this.pgMetrics().updateTimer(MetricName.delivery_request_time, millis);
    }

    public void updateGeoLocationMetric(boolean successful) {
        this.incCounter(MetricName.geolocation_requests);
        if (successful) {
            this.incCounter(MetricName.geolocation_successful);
        } else {
            this.incCounter(MetricName.geolocation_fail);
        }
    }

    public void createGeoLocationCircuitBreakerGauge(BooleanSupplier stateSupplier) {
        this.forCircuitBreakerType(MetricName.geo).createGauge(MetricName.opened, () -> stateSupplier.getAsBoolean() ? 1L : 0L);
    }

    public void updateStoredRequestMetric(boolean found) {
        if (found) {
            this.incCounter(MetricName.stored_requests_found);
        } else {
            this.incCounter(MetricName.stored_requests_missing);
        }
    }

    public void updateStoredImpsMetric(boolean found) {
        if (found) {
            this.incCounter(MetricName.stored_imps_found);
        } else {
            this.incCounter(MetricName.stored_imps_missing);
        }
    }

    public void updateCacheRequestSuccessTime(String accountId, long timeElapsed) {
        this.cache().requests().updateTimer(MetricName.ok, timeElapsed);
        this.forAccount(accountId).cache().requests().updateTimer(MetricName.ok, timeElapsed);
    }

    public void updateCacheRequestFailedTime(String accountId, long timeElapsed) {
        this.cache().requests().updateTimer(MetricName.err, timeElapsed);
        this.forAccount(accountId).cache().requests().updateTimer(MetricName.err, timeElapsed);
    }

    public void updateCacheCreativeSize(String accountId, int creativeSize, MetricName creativeType) {
        this.cache().creativeSize().updateHistogram(creativeType, creativeSize);
        this.forAccount(accountId).cache().creativeSize().updateHistogram(creativeType, creativeSize);
    }

    public void updateTimeoutNotificationMetric(boolean success) {
        if (success) {
            this.timeoutNotificationMetrics.incCounter(MetricName.ok);
        } else {
            this.timeoutNotificationMetrics.incCounter(MetricName.failed);
        }
    }

    public void createCurrencyRatesGauge(BooleanSupplier stateSupplier) {
        this.currencyRates().createGauge(MetricName.stale, () -> stateSupplier.getAsBoolean() ? 1L : 0L);
    }

    public void updateSettingsCacheRefreshTime(MetricName cacheType, MetricName refreshType, long timeElapsed) {
        this.forSettingsCacheType(cacheType).forRefreshType(refreshType).updateTimer(MetricName.db_query_time, timeElapsed);
    }

    public void updateSettingsCacheRefreshErrorMetric(MetricName cacheType, MetricName refreshType) {
        this.forSettingsCacheType(cacheType).forRefreshType(refreshType).incCounter(MetricName.err);
    }

    public void updateSettingsCacheEventMetric(MetricName cacheType, MetricName event) {
        this.forSettingsCacheType(cacheType).incCounter(event);
    }

    public void updateHooksMetrics(String moduleCode, Stage stage, String hookImplCode, ExecutionStatus status, Long executionTime, ExecutionAction action) {
        HookImplMetrics hookImplMetrics = this.hooks().module(moduleCode).stage(stage).hookImpl(hookImplCode);
        hookImplMetrics.incCounter(MetricName.call);
        if (status == ExecutionStatus.success) {
            hookImplMetrics.success().incCounter(HookMetricMapper.fromAction(action));
        } else {
            hookImplMetrics.incCounter(HookMetricMapper.fromStatus(status));
        }
        hookImplMetrics.updateTimer(MetricName.duration, executionTime);
    }

    public void updateAccountHooksMetrics(Account account, String moduleCode, ExecutionStatus status, ExecutionAction action) {
        if (this.accountMetricsVerbosityResolver.forAccount(account).isAtLeast(AccountMetricsVerbosityLevel.detailed)) {
            ModuleMetrics accountModuleMetrics = this.forAccount(account.getId()).hooks().module(moduleCode);
            accountModuleMetrics.incCounter(MetricName.call);
            if (status == ExecutionStatus.success) {
                accountModuleMetrics.success().incCounter(HookMetricMapper.fromAction(action));
            } else {
                accountModuleMetrics.incCounter(MetricName.failure);
            }
        }
    }

    public void updateAccountModuleDurationMetric(Account account, String moduleCode, Long executionTime) {
        if (this.accountMetricsVerbosityResolver.forAccount(account).isAtLeast(AccountMetricsVerbosityLevel.detailed)) {
            this.forAccount(account.getId()).hooks().module(moduleCode).updateTimer(MetricName.duration, executionTime);
        }
    }

    public void updateWinNotificationMetric() {
        this.incCounter(MetricName.win_notifications);
    }

    public void updateWinRequestPreparationFailed() {
        this.incCounter(MetricName.win_request_preparation_failed);
    }

    public void updateUserDetailsRequestPreparationFailed() {
        this.incCounter(MetricName.user_details_request_preparation_failed);
    }

    public void updateRequestsActivityDisallowedCount(Activity activity) {
        this.requests().activities().forActivity(activity).incCounter(MetricName.disallowed_count);
    }

    public void updateAccountActivityDisallowedCount(String account, Activity activity) {
        this.forAccount(account).activities().forActivity(activity).incCounter(MetricName.disallowed_count);
    }

    public void updateAdapterActivityDisallowedCount(String adapter, Activity activity) {
        this.forAdapter(adapter).activities().forActivity(activity).incCounter(MetricName.disallowed_count);
    }

    public void updateRequestsActivityProcessedRulesCount() {
        this.requests().activities().incCounter(MetricName.processed_rules_count);
    }

    public void updateAccountActivityProcessedRulesCount(String account) {
        this.forAccount(account).activities().incCounter(MetricName.processed_rules_count);
    }

    private static class HookMetricMapper {
        private static final EnumMap<ExecutionStatus, MetricName> STATUS_TO_METRIC = new EnumMap(ExecutionStatus.class);
        private static final EnumMap<ExecutionAction, MetricName> ACTION_TO_METRIC = new EnumMap(ExecutionAction.class);

        private HookMetricMapper() {
        }

        static MetricName fromStatus(ExecutionStatus status) {
            return STATUS_TO_METRIC.getOrDefault((Object)status, MetricName.unknown);
        }

        static MetricName fromAction(ExecutionAction action) {
            return ACTION_TO_METRIC.getOrDefault((Object)action, MetricName.unknown);
        }

        static {
            STATUS_TO_METRIC.put(ExecutionStatus.failure, MetricName.failure);
            STATUS_TO_METRIC.put(ExecutionStatus.timeout, MetricName.timeout);
            STATUS_TO_METRIC.put(ExecutionStatus.invocation_failure, MetricName.execution_error);
            STATUS_TO_METRIC.put(ExecutionStatus.execution_failure, MetricName.execution_error);
            ACTION_TO_METRIC.put(ExecutionAction.no_action, MetricName.noop);
            ACTION_TO_METRIC.put(ExecutionAction.update, MetricName.update);
            ACTION_TO_METRIC.put(ExecutionAction.reject, MetricName.reject);
        }
    }
}

