/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.log;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.RoutingContext;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.auction.model.AuctionContext;
import org.prebid.server.auction.model.BidderRequest;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.log.model.HttpLogSpec;
import org.prebid.server.metric.MetricName;
import org.prebid.server.settings.model.Account;
import org.prebid.server.util.ObjectUtil;

public class HttpInteractionLogger {
    private static final String HTTP_INTERACTION_LOGGER_NAME = "http-interaction";
    private final Logger logger = LoggerFactory.getLogger((String)"http-interaction");
    private final JacksonMapper mapper;
    private final AtomicReference<SpecWithCounter> specWithCounter = new AtomicReference();

    public HttpInteractionLogger(JacksonMapper mapper) {
        this.mapper = Objects.requireNonNull(mapper);
    }

    public void setSpec(HttpLogSpec spec) {
        this.specWithCounter.set(SpecWithCounter.of(spec));
    }

    public void maybeLogOpenrtb2Auction(AuctionContext auctionContext, RoutingContext routingContext, int statusCode, String responseBody) {
        if (this.interactionSatisfiesSpec(HttpLogSpec.Endpoint.auction, statusCode, auctionContext)) {
            this.logger.info((Object)"Requested URL: \"{0}\", request body: \"{1}\", response status: \"{2}\", response body: \"{3}\"", new Object[]{routingContext.request().uri(), this.toOneLineString(routingContext.getBodyAsString()), statusCode, responseBody});
            this.incLoggedInteractions();
        }
    }

    private String toOneLineString(String value) {
        try {
            return this.mapper.encodeToString(this.mapper.mapper().readTree(value));
        }
        catch (JsonProcessingException e) {
            return "Not parseable JSON passed: " + value.replaceAll("[\r\n]+", " ");
        }
    }

    public void maybeLogOpenrtb2Amp(AuctionContext auctionContext, RoutingContext routingContext, int statusCode, String responseBody) {
        if (this.interactionSatisfiesSpec(HttpLogSpec.Endpoint.amp, statusCode, auctionContext)) {
            this.logger.info((Object)"Requested URL: \"{0}\", response status: \"{1}\", response body: \"{2}\"", new Object[]{routingContext.request().uri(), statusCode, responseBody});
            this.incLoggedInteractions();
        }
    }

    public void maybeLogBidderRequest(AuctionContext context, BidderRequest bidderRequest) {
        String bidder = bidderRequest.getBidder();
        if (this.interactionSatisfiesSpec(context, bidder)) {
            BidRequest bidRequest = bidderRequest.getBidRequest();
            BidRequest updatedBidRequest = this.bidRequestWithBidderName(bidder, bidRequest);
            String jsonBidRequest = this.mapper.encodeToString(updatedBidRequest);
            this.logger.info((Object)"Request body to {0}: \"{1}\"", new Object[]{bidder, jsonBidRequest});
            this.incLoggedInteractions();
        }
    }

    private boolean interactionSatisfiesSpec(HttpLogSpec.Endpoint requestEndpoint, int requestStatusCode, AuctionContext auctionContext) {
        SpecWithCounter specWithCounter = this.specWithCounter.get();
        if (specWithCounter == null) {
            return false;
        }
        Account requestAccount = ObjectUtil.getIfNotNull(auctionContext, AuctionContext::getAccount);
        String requestAccountId = ObjectUtil.getIfNotNull(requestAccount, Account::getId);
        HttpLogSpec spec = specWithCounter.getSpec();
        HttpLogSpec.Endpoint endpoint = spec.getEndpoint();
        Integer statusCode = spec.getStatusCode();
        String account = spec.getAccount();
        return !(endpoint != null && endpoint != requestEndpoint || statusCode != null && statusCode != requestStatusCode || account != null && !account.equals(requestAccountId));
    }

    private boolean interactionSatisfiesSpec(AuctionContext auctionContext, String requestBidder) {
        SpecWithCounter specWithCounter = this.specWithCounter.get();
        if (specWithCounter == null) {
            return false;
        }
        HttpLogSpec.Endpoint requestEndpoint = this.parseHttpLogEndpoint(ObjectUtil.getIfNotNull(auctionContext, AuctionContext::getRequestTypeMetric));
        Account requestAccount = ObjectUtil.getIfNotNull(auctionContext, AuctionContext::getAccount);
        String requestAccountId = requestAccount != null ? requestAccount.getId() : null;
        HttpLogSpec spec = specWithCounter.getSpec();
        HttpLogSpec.Endpoint endpoint = spec.getEndpoint();
        String account = spec.getAccount();
        String bidder = spec.getBidder();
        return !(endpoint != null && endpoint != requestEndpoint || account != null && !account.equals(requestAccountId) || bidder == null || !bidder.equals(requestBidder));
    }

    private HttpLogSpec.Endpoint parseHttpLogEndpoint(MetricName requestTypeMetric) {
        if (requestTypeMetric != null) {
            if (requestTypeMetric == MetricName.amp) {
                return HttpLogSpec.Endpoint.amp;
            }
            if (requestTypeMetric == MetricName.openrtb2app || requestTypeMetric == MetricName.openrtb2web || requestTypeMetric == MetricName.openrtb2dooh) {
                return HttpLogSpec.Endpoint.auction;
            }
        }
        return null;
    }

    private void incLoggedInteractions() {
        SpecWithCounter specWithCounter = this.specWithCounter.get();
        if (specWithCounter != null && specWithCounter.getLoggedInteractions().incrementAndGet() >= (long)specWithCounter.getSpec().getLimit()) {
            this.specWithCounter.set(null);
        }
    }

    private BidRequest bidRequestWithBidderName(String bidder, BidRequest bidRequest) {
        List<Imp> imps = bidRequest.getImp();
        if (CollectionUtils.isEmpty(imps)) {
            return bidRequest;
        }
        List<Imp> updatedImps = imps.stream().map(imp -> this.makeImpExtBidderName(bidder, (Imp)imp)).toList();
        return bidRequest.toBuilder().imp(updatedImps).build();
    }

    private Imp makeImpExtBidderName(String bidder, Imp imp) {
        ObjectNode originalImpExt = imp.getExt();
        if (originalImpExt == null) {
            return imp;
        }
        ObjectNode impExt = originalImpExt.deepCopy();
        Imp updatedImp = imp.toBuilder().ext(impExt).build();
        JsonNode impExtBidder = impExt.remove("bidder");
        if (impExtBidder != null) {
            impExt.set(bidder, impExtBidder);
        }
        return updatedImp;
    }

    private static final class SpecWithCounter {
        private final HttpLogSpec spec;
        private final AtomicLong loggedInteractions = new AtomicLong(0L);

        @ConstructorProperties(value={"spec"})
        private SpecWithCounter(HttpLogSpec spec) {
            this.spec = spec;
        }

        public static SpecWithCounter of(HttpLogSpec spec) {
            return new SpecWithCounter(spec);
        }

        public HttpLogSpec getSpec() {
            return this.spec;
        }

        public AtomicLong getLoggedInteractions() {
            return this.loggedInteractions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpecWithCounter)) {
                return false;
            }
            SpecWithCounter other = (SpecWithCounter)o;
            HttpLogSpec this$spec = this.getSpec();
            HttpLogSpec other$spec = other.getSpec();
            if (this$spec == null ? other$spec != null : !((Object)this$spec).equals(other$spec)) {
                return false;
            }
            AtomicLong this$loggedInteractions = this.getLoggedInteractions();
            AtomicLong other$loggedInteractions = other.getLoggedInteractions();
            return !(this$loggedInteractions == null ? other$loggedInteractions != null : !this$loggedInteractions.equals(other$loggedInteractions));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            HttpLogSpec $spec = this.getSpec();
            result = result * 59 + ($spec == null ? 43 : ((Object)$spec).hashCode());
            AtomicLong $loggedInteractions = this.getLoggedInteractions();
            result = result * 59 + ($loggedInteractions == null ? 43 : $loggedInteractions.hashCode());
            return result;
        }

        public String toString() {
            return "HttpInteractionLogger.SpecWithCounter(spec=" + this.getSpec() + ", loggedInteractions=" + this.getLoggedInteractions() + ")";
        }
    }
}

