/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.log;

import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.response.BidResponse;
import io.vertx.core.impl.ConcurrentHashSet;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.prebid.server.json.EncodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.log.Criteria;

public class CriteriaLogManager {
    private static final Logger logger = LoggerFactory.getLogger(CriteriaLogManager.class);
    private final Set<Criteria> criterias = new ConcurrentHashSet();
    private final JacksonMapper mapper;

    public CriteriaLogManager(JacksonMapper mapper) {
        this.mapper = Objects.requireNonNull(mapper);
    }

    public void log(Logger logger, Criteria criteria, Object message, Consumer<Object> defaultLogger) {
        if (this.criterias.isEmpty()) {
            defaultLogger.accept(message);
        }
        this.criterias.forEach(cr -> cr.log(criteria, logger, message, defaultLogger));
    }

    public void log(Logger logger, String account, Object message, Consumer<Object> defaultLogger) {
        this.log(logger, Criteria.builder().account(account).build(), message, defaultLogger);
    }

    public void log(Logger logger, String account, String bidder, String lineItemId, Object message, Consumer<Object> defaultLogger) {
        this.log(logger, Criteria.builder().account(account).bidder(bidder).lineItemId(lineItemId).build(), message, defaultLogger);
    }

    public BidResponse traceResponse(Logger logger, BidResponse bidResponse, BidRequest bidRequest, boolean debugEnabled) {
        String jsonBidRequest;
        String jsonBidResponse;
        if (this.criterias.isEmpty()) {
            return bidResponse;
        }
        try {
            jsonBidResponse = this.mapper.encodeToString(bidResponse);
            jsonBidRequest = debugEnabled ? null : this.mapper.encodeToString(bidRequest);
        }
        catch (EncodeException e) {
            CriteriaLogManager.logger.warn((Object)"Failed to parse bidResponse or bidRequest to json string: {0}", (Throwable)e);
            return bidResponse;
        }
        if (debugEnabled) {
            this.criterias.forEach(criteria -> criteria.logResponse(jsonBidResponse, logger));
        } else {
            this.criterias.forEach(criteria -> criteria.logResponseAndRequest(jsonBidResponse, jsonBidRequest, logger));
        }
        return bidResponse;
    }

    public void removeCriteria(Criteria criteria) {
        this.criterias.remove(criteria);
    }

    public void addCriteria(Criteria criteria) {
        this.criterias.add(criteria);
    }

    public void removeAllCriteria() {
        this.criterias.clear();
    }
}

