/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.json.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.prebid.server.settings.model.activity.rule.AccountActivityRuleConfig;
import org.prebid.server.settings.model.activity.rule.resolver.AccountActivityRuleConfigResolver;

public class AccountActivityRulesConfigDeserializer
extends StdDeserializer<List<? extends AccountActivityRuleConfig>> {
    protected AccountActivityRulesConfigDeserializer() {
        super(List.class);
    }

    public List<? extends AccountActivityRuleConfig> deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        if (parser.currentToken() != JsonToken.START_ARRAY) {
            AccountActivityRulesConfigDeserializer.reportWrongTokenException(parser, context);
        }
        ObjectCodec codec = parser.getCodec();
        ArrayNode node = (ArrayNode)codec.readTree(parser);
        ArrayList<AccountActivityRuleConfig> rulesConfig = new ArrayList<AccountActivityRuleConfig>();
        for (JsonNode ruleNode : node) {
            Class<? extends AccountActivityRuleConfig> type = AccountActivityRuleConfigResolver.resolve(ruleNode);
            rulesConfig.add((AccountActivityRuleConfig)codec.treeToValue((TreeNode)ruleNode, type));
        }
        return Collections.unmodifiableList(rulesConfig);
    }

    private static void reportWrongTokenException(JsonParser parser, DeserializationContext context) throws IOException {
        context.reportWrongTokenException(JsonToken.class, JsonToken.START_ARRAY, "Failed to parse field %s to array with a reason: Expected array.".formatted(parser.getCurrentName()), new Object[0]);
    }
}

