/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.mergepatch.JsonMergePatch;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.prebid.server.exception.InvalidRequestException;
import org.prebid.server.json.JacksonMapper;

public class JsonMerger {
    private final JacksonMapper mapper;

    public JsonMerger(JacksonMapper mapper) {
        this.mapper = Objects.requireNonNull(mapper);
    }

    public <T> T merge(T originalObject, String storedData, String id, Class<T> classToCast) {
        JsonNode storedRequestJsonNode;
        JsonNode originJsonNode = this.mapper.mapper().valueToTree(originalObject);
        try {
            storedRequestJsonNode = this.mapper.mapper().readTree(storedData);
        }
        catch (IOException e) {
            throw new InvalidRequestException("Can't parse Json for stored request with id " + id);
        }
        try {
            return (T)this.mapper.mapper().treeToValue((TreeNode)JsonMergePatch.fromJson((JsonNode)originJsonNode).apply(storedRequestJsonNode), classToCast);
        }
        catch (JsonPatchException e) {
            throw new InvalidRequestException("Couldn't create merge patch from origin object node for id %s: %s".formatted(id, e.getMessage()));
        }
        catch (JsonProcessingException e) {
            throw new InvalidRequestException("Can't convert merging result for id %s: %s".formatted(id, e.getMessage()));
        }
    }

    public <T> T merge(T originalObject, T mergingObject, Class<T> classToCast) {
        if (!ObjectUtils.allNotNull((Object[])new Object[]{originalObject, mergingObject})) {
            return (T)ObjectUtils.defaultIfNull(originalObject, mergingObject);
        }
        JsonNode originJsonNode = this.mapper.mapper().valueToTree(originalObject);
        JsonNode mergingObjectJsonNode = this.mapper.mapper().valueToTree(mergingObject);
        try {
            JsonNode mergedNode = JsonMergePatch.fromJson((JsonNode)originJsonNode).apply(mergingObjectJsonNode);
            return (T)this.mapper.mapper().treeToValue((TreeNode)mergedNode, classToCast);
        }
        catch (JsonPatchException e) {
            throw new InvalidRequestException("Couldn't create merge patch for objects with class " + classToCast.getName());
        }
        catch (JsonProcessingException e) {
            throw new InvalidRequestException("Can't convert merging result class " + classToCast.getName());
        }
    }

    public JsonNode merge(JsonNode fromNode, JsonNode toNode) {
        try {
            return JsonMergePatch.fromJson((JsonNode)fromNode).apply(toNode);
        }
        catch (JsonPatchException e) {
            throw new InvalidRequestException("Couldn't create merge patch for json nodes");
        }
    }
}

