/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.buffer.ByteBufInputStream;
import io.vertx.core.buffer.Buffer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.EncodeException;
import org.prebid.server.proto.openrtb.ext.FlexibleExtension;

public class JacksonMapper {
    private static final String FAILED_TO_DECODE = "Failed to decode: %s";
    private final ObjectMapper mapper;

    public JacksonMapper(ObjectMapper mapper) {
        this.mapper = Objects.requireNonNull(mapper);
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public <T> String encodeToString(T obj) throws EncodeException {
        try {
            return this.mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new EncodeException("Failed to encode as JSON: " + e.getMessage());
        }
    }

    public <T> byte[] encodeToBytes(T obj) throws EncodeException {
        try {
            return this.mapper.writeValueAsBytes(obj);
        }
        catch (JsonProcessingException e) {
            throw new EncodeException("Failed to encode as byte array: " + e.getMessage());
        }
    }

    public <T> T decodeValue(String str, Class<T> clazz) throws DecodeException {
        try {
            return (T)this.mapper.readValue(str, clazz);
        }
        catch (JsonProcessingException e) {
            throw new DecodeException(FAILED_TO_DECODE.formatted(e.getMessage()));
        }
    }

    public <T> T decodeValue(byte[] bytes, Class<T> clazz) throws DecodeException {
        try {
            return (T)this.mapper.readValue(bytes, clazz);
        }
        catch (IOException e) {
            throw new DecodeException(FAILED_TO_DECODE.formatted(e.getMessage()));
        }
    }

    public <T> T decodeValue(String str, TypeReference<T> type) throws DecodeException {
        try {
            return (T)this.mapper.readValue(str, type);
        }
        catch (JsonProcessingException e) {
            throw new DecodeException(FAILED_TO_DECODE.formatted(e.getMessage()), e);
        }
    }

    public <T> T decodeValue(Buffer buf, Class<T> clazz) throws DecodeException {
        try {
            return (T)this.mapper.readValue((InputStream)new ByteBufInputStream(buf.getByteBuf()), clazz);
        }
        catch (IOException e) {
            throw new DecodeException(FAILED_TO_DECODE.formatted(e.getMessage()), e);
        }
    }

    public <T> T decodeValue(Buffer buf, TypeReference<T> type) throws DecodeException {
        try {
            return (T)this.mapper.readValue((InputStream)new ByteBufInputStream(buf.getByteBuf()), type);
        }
        catch (IOException e) {
            throw new DecodeException(FAILED_TO_DECODE.formatted(e.getMessage()), e);
        }
    }

    public <T extends FlexibleExtension, S> T fillExtension(T target, S source) {
        target.addProperties((Map)this.mapper.convertValue(source, FlexibleExtension.PROPERTIES_TYPE_REF));
        return target;
    }
}

