/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.hooks.execution;

import java.util.ArrayList;
import java.util.List;
import org.prebid.server.hooks.execution.GroupResult;
import org.prebid.server.hooks.execution.model.GroupExecutionOutcome;
import org.prebid.server.hooks.execution.model.StageExecutionOutcome;

class StageResult<T> {
    private boolean shouldReject = false;
    private T payload;
    private final String entity;
    private final List<GroupResult<T>> groupResults = new ArrayList<GroupResult<T>>();

    private StageResult(T payload, String entity) {
        this.payload = payload;
        this.entity = entity;
    }

    public static <T> StageResult<T> of(T payload, String entity) {
        return new StageResult<T>(payload, entity);
    }

    public StageResult<T> applyGroupResult(GroupResult<T> groupResult) {
        this.groupResults.add(groupResult);
        this.shouldReject = groupResult.shouldReject();
        this.payload = groupResult.payload();
        return this;
    }

    public StageExecutionOutcome toStageExecutionOutcome() {
        return StageExecutionOutcome.of(this.entity, this.groupExecutionOutcomes());
    }

    private List<GroupExecutionOutcome> groupExecutionOutcomes() {
        return this.groupResults.stream().map(GroupResult::toGroupExecutionOutcome).toList();
    }

    public boolean shouldReject() {
        return this.shouldReject;
    }

    public T payload() {
        return this.payload;
    }

    public String entity() {
        return this.entity;
    }

    public List<GroupResult<T>> groupResults() {
        return this.groupResults;
    }
}

