/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.hooks.execution;

import io.vertx.core.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.prebid.server.hooks.execution.FailedException;
import org.prebid.server.hooks.execution.GroupExecutor;
import org.prebid.server.hooks.execution.model.ExecutionAction;
import org.prebid.server.hooks.execution.model.ExecutionStatus;
import org.prebid.server.hooks.execution.model.GroupExecutionOutcome;
import org.prebid.server.hooks.execution.model.HookExecutionOutcome;
import org.prebid.server.hooks.execution.model.HookId;
import org.prebid.server.hooks.v1.InvocationAction;
import org.prebid.server.hooks.v1.InvocationResult;
import org.prebid.server.hooks.v1.InvocationStatus;
import org.prebid.server.hooks.v1.PayloadUpdate;
import org.prebid.server.log.ConditionalLogger;

class GroupResult<T> {
    private static final ConditionalLogger conditionalLogger = new ConditionalLogger(LoggerFactory.getLogger(GroupExecutor.class));
    private static final double LOG_SAMPLING_RATE = 0.01;
    private boolean shouldReject = false;
    private T payload;
    private final boolean rejectAllowed;
    private final List<HookExecutionOutcome> hookExecutionOutcomes = new ArrayList<HookExecutionOutcome>();

    private GroupResult(T payload, boolean rejectAllowed) {
        this.payload = payload;
        this.rejectAllowed = rejectAllowed;
    }

    public static <T> GroupResult<T> of(T payload, boolean rejectAllowed) {
        return new GroupResult<T>(payload, rejectAllowed);
    }

    public GroupResult<T> applyInvocationResult(InvocationResult<T> invocationResult, HookId hookId, long executionTime) {
        if (invocationResult.status() == InvocationStatus.success && invocationResult.action() != null) {
            try {
                this.applyAction(hookId, invocationResult.action(), invocationResult.payloadUpdate());
            }
            catch (Exception e) {
                this.hookExecutionOutcomes.add(GroupResult.toExecutionOutcome(e, hookId, executionTime));
                return this;
            }
        }
        this.hookExecutionOutcomes.add(GroupResult.toExecutionOutcome(invocationResult, hookId, executionTime));
        return this;
    }

    public GroupResult<T> applyFailure(Throwable throwable, HookId hookId, long executionTime) {
        this.hookExecutionOutcomes.add(GroupResult.toExecutionOutcome(throwable, hookId, executionTime));
        return this;
    }

    public GroupExecutionOutcome toGroupExecutionOutcome() {
        return GroupExecutionOutcome.of(this.hookExecutionOutcomes());
    }

    private void applyAction(HookId hookId, InvocationAction action, PayloadUpdate<T> payloadUpdate) {
        switch (action) {
            case reject: {
                this.applyReject(hookId);
                break;
            }
            case update: {
                this.applyPayloadUpdate(hookId, payloadUpdate);
            }
        }
    }

    private void applyReject(HookId hookId) {
        if (!this.rejectAllowed) {
            conditionalLogger.error("Hook implementation %s requested to reject an entity on a stage that does not support rejection".formatted(hookId), 0.01);
            throw new RejectionNotSupportedException("Rejection is not supported during this stage");
        }
        this.shouldReject = true;
        this.payload = null;
    }

    private void applyPayloadUpdate(HookId hookId, PayloadUpdate<T> payloadUpdate) {
        if (payloadUpdate == null) {
            conditionalLogger.error("Hook implementation %s requested to update an entity but not provided a payload update".formatted(hookId), 0.01);
            throw new PayloadUpdateException("Payload update is missing in invocation result");
        }
        try {
            this.payload = payloadUpdate.apply(this.payload);
        }
        catch (Exception e) {
            conditionalLogger.error("Hook implementation %s requested to update an entity but payload update has thrown an exception: %s".formatted(hookId, e), 0.01);
            throw new PayloadUpdateException("Payload update has thrown an exception: " + e);
        }
    }

    private static HookExecutionOutcome toExecutionOutcome(InvocationResult<?> invocationResult, HookId hookId, long executionTime) {
        return HookExecutionOutcome.builder().hookId(hookId).executionTime(executionTime).status(GroupResult.toExecutionStatus(invocationResult.status())).message(invocationResult.message()).action(GroupResult.toExecutionAction(invocationResult.action())).errors(invocationResult.errors()).warnings(invocationResult.warnings()).debugMessages(invocationResult.debugMessages()).analyticsTags(invocationResult.analyticsTags()).build();
    }

    private static HookExecutionOutcome toExecutionOutcome(Throwable throwable, HookId hookId, long executionTime) {
        return HookExecutionOutcome.builder().hookId(hookId).executionTime(executionTime).status(GroupResult.toFailureType(throwable)).message(throwable.getMessage()).build();
    }

    private static ExecutionStatus toFailureType(Throwable throwable) {
        if (throwable instanceof TimeoutException) {
            return ExecutionStatus.timeout;
        }
        if (throwable instanceof FailedException) {
            return ExecutionStatus.invocation_failure;
        }
        return ExecutionStatus.execution_failure;
    }

    private static ExecutionStatus toExecutionStatus(InvocationStatus status) {
        if (status == null) {
            return null;
        }
        return switch (status) {
            default -> throw new IncompatibleClassChangeError();
            case InvocationStatus.success -> ExecutionStatus.success;
            case InvocationStatus.failure -> ExecutionStatus.failure;
        };
    }

    private static ExecutionAction toExecutionAction(InvocationAction action) {
        if (action == null) {
            return null;
        }
        return switch (action) {
            default -> throw new IncompatibleClassChangeError();
            case InvocationAction.reject -> ExecutionAction.reject;
            case InvocationAction.update -> ExecutionAction.update;
            case InvocationAction.no_action -> ExecutionAction.no_action;
        };
    }

    public boolean shouldReject() {
        return this.shouldReject;
    }

    public T payload() {
        return this.payload;
    }

    public boolean rejectAllowed() {
        return this.rejectAllowed;
    }

    public List<HookExecutionOutcome> hookExecutionOutcomes() {
        return this.hookExecutionOutcomes;
    }

    private static class RejectionNotSupportedException
    extends RuntimeException {
        RejectionNotSupportedException(String message) {
            super(message);
        }
    }

    private static class PayloadUpdateException
    extends RuntimeException {
        PayloadUpdateException(String message) {
            super(message);
        }
    }
}

