/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.handler.info;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.prebid.server.bidder.BidderCatalog;
import org.prebid.server.bidder.BidderInfo;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.model.Endpoint;
import org.prebid.server.util.HttpUtil;

public class BidderDetailsHandler
implements Handler<RoutingContext> {
    private static final String BIDDER_NAME_PARAM = "bidderName";
    private static final String ALL_PARAM_VALUE = "all";
    private final JacksonMapper mapper;
    private final Map<String, String> bidderInfos;

    public BidderDetailsHandler(BidderCatalog bidderCatalog, JacksonMapper mapper) {
        BidderDetailsHandler.validateAliases(Objects.requireNonNull(bidderCatalog));
        this.mapper = Objects.requireNonNull(mapper);
        this.bidderInfos = this.createBidderInfos(bidderCatalog);
    }

    private static void validateAliases(BidderCatalog bidderCatalog) {
        if (bidderCatalog.names().contains(ALL_PARAM_VALUE)) {
            throw new IllegalArgumentException("There is '%s' bidder or alias configured which is unacceptable.".formatted(ALL_PARAM_VALUE));
        }
    }

    private Map<String, String> createBidderInfos(BidderCatalog bidderCatalog) {
        Map<String, ObjectNode> nameToInfo = bidderCatalog.names().stream().collect(Collectors.toMap(Function.identity(), name -> this.bidderNode(bidderCatalog, (String)name)));
        Map<String, ObjectNode> allToInfos = Collections.singletonMap(ALL_PARAM_VALUE, this.allInfos(nameToInfo));
        return (Map)Stream.of(nameToInfo, allToInfos).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, map -> this.mapper.encodeToString((ObjectNode)map.getValue()), (first, second) -> second, CaseInsensitiveMap::new));
    }

    private ObjectNode bidderNode(BidderCatalog bidderCatalog, String name) {
        BidderInfo bidderInfo = bidderCatalog.bidderInfoByName(name);
        return (ObjectNode)this.mapper.mapper().valueToTree((Object)BidderInfoResponseModel.from(bidderInfo));
    }

    private ObjectNode allInfos(Map<String, ObjectNode> nameToInfo) {
        return (ObjectNode)this.mapper.mapper().valueToTree(new TreeMap<String, ObjectNode>(nameToInfo));
    }

    public void handle(RoutingContext routingContext) {
        String bidderName = routingContext.request().getParam(BIDDER_NAME_PARAM);
        String endpoint = "%s/%s".formatted(Endpoint.info_bidders.value(), bidderName);
        String bidderInfo = this.bidderInfos.get(bidderName);
        if (bidderInfo != null) {
            HttpUtil.executeSafely(routingContext, endpoint, response -> response.putHeader(HttpUtil.CONTENT_TYPE_HEADER, (CharSequence)HttpHeaderValues.APPLICATION_JSON).end(bidderInfo));
        } else {
            HttpUtil.executeSafely(routingContext, endpoint, response -> response.setStatusCode(HttpResponseStatus.NOT_FOUND.code()).end());
        }
    }

    private static final class BidderInfoResponseModel {
        private static final String STATUS_ACTIVE = "ACTIVE";
        private static final String STATUS_DISABLED = "DISABLED";
        private final String status;
        @JsonProperty(value="usesHttps")
        private final boolean usesHttps;
        private final BidderInfo.MaintainerInfo maintainer;
        private final BidderInfo.CapabilitiesInfo capabilities;
        @JsonProperty(value="aliasOf")
        private final String aliasOf;

        private static BidderInfoResponseModel from(BidderInfo bidderInfo) {
            return BidderInfoResponseModel.of(bidderInfo.isEnabled() ? STATUS_ACTIVE : STATUS_DISABLED, bidderInfo.isUsesHttps(), bidderInfo.getMaintainer(), bidderInfo.getCapabilities(), bidderInfo.getAliasOf());
        }

        @ConstructorProperties(value={"status", "usesHttps", "maintainer", "capabilities", "aliasOf"})
        private BidderInfoResponseModel(String status, boolean usesHttps, BidderInfo.MaintainerInfo maintainer, BidderInfo.CapabilitiesInfo capabilities, String aliasOf) {
            this.status = status;
            this.usesHttps = usesHttps;
            this.maintainer = maintainer;
            this.capabilities = capabilities;
            this.aliasOf = aliasOf;
        }

        public static BidderInfoResponseModel of(String status, boolean usesHttps, BidderInfo.MaintainerInfo maintainer, BidderInfo.CapabilitiesInfo capabilities, String aliasOf) {
            return new BidderInfoResponseModel(status, usesHttps, maintainer, capabilities, aliasOf);
        }

        public String getStatus() {
            return this.status;
        }

        public boolean isUsesHttps() {
            return this.usesHttps;
        }

        public BidderInfo.MaintainerInfo getMaintainer() {
            return this.maintainer;
        }

        public BidderInfo.CapabilitiesInfo getCapabilities() {
            return this.capabilities;
        }

        public String getAliasOf() {
            return this.aliasOf;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BidderInfoResponseModel)) {
                return false;
            }
            BidderInfoResponseModel other = (BidderInfoResponseModel)o;
            if (this.isUsesHttps() != other.isUsesHttps()) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            BidderInfo.MaintainerInfo this$maintainer = this.getMaintainer();
            BidderInfo.MaintainerInfo other$maintainer = other.getMaintainer();
            if (this$maintainer == null ? other$maintainer != null : !((Object)this$maintainer).equals(other$maintainer)) {
                return false;
            }
            BidderInfo.CapabilitiesInfo this$capabilities = this.getCapabilities();
            BidderInfo.CapabilitiesInfo other$capabilities = other.getCapabilities();
            if (this$capabilities == null ? other$capabilities != null : !((Object)this$capabilities).equals(other$capabilities)) {
                return false;
            }
            String this$aliasOf = this.getAliasOf();
            String other$aliasOf = other.getAliasOf();
            return !(this$aliasOf == null ? other$aliasOf != null : !this$aliasOf.equals(other$aliasOf));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isUsesHttps() ? 79 : 97);
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            BidderInfo.MaintainerInfo $maintainer = this.getMaintainer();
            result = result * 59 + ($maintainer == null ? 43 : ((Object)$maintainer).hashCode());
            BidderInfo.CapabilitiesInfo $capabilities = this.getCapabilities();
            result = result * 59 + ($capabilities == null ? 43 : ((Object)$capabilities).hashCode());
            String $aliasOf = this.getAliasOf();
            result = result * 59 + ($aliasOf == null ? 43 : $aliasOf.hashCode());
            return result;
        }

        public String toString() {
            return "BidderDetailsHandler.BidderInfoResponseModel(status=" + this.getStatus() + ", usesHttps=" + this.isUsesHttps() + ", maintainer=" + this.getMaintainer() + ", capabilities=" + this.getCapabilities() + ", aliasOf=" + this.getAliasOf() + ")";
        }
    }
}

