/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.handler;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.Cookie;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.RoutingContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.cookie.UidsCookie;
import org.prebid.server.cookie.UidsCookieService;
import org.prebid.server.model.Endpoint;
import org.prebid.server.optout.GoogleRecaptchaVerifier;
import org.prebid.server.optout.model.RecaptchaResponse;
import org.prebid.server.util.HttpUtil;

public class OptoutHandler
implements Handler<RoutingContext> {
    private static final Logger logger = LoggerFactory.getLogger(OptoutHandler.class);
    private static final String RECAPTCHA_PARAM = "g-recaptcha-response";
    private static final String OPTOUT_PARAM = "optout";
    private final UidsCookieService uidsCookieService;
    private final GoogleRecaptchaVerifier googleRecaptchaVerifier;
    private final String optoutRedirectUrl;
    private final String optoutUrl;
    private final String optinUrl;

    public OptoutHandler(GoogleRecaptchaVerifier googleRecaptchaVerifier, UidsCookieService uidsCookieService, String optoutRedirectUrl, String optoutUrl, String optinUrl) {
        this.googleRecaptchaVerifier = Objects.requireNonNull(googleRecaptchaVerifier);
        this.uidsCookieService = Objects.requireNonNull(uidsCookieService);
        this.optoutRedirectUrl = Objects.requireNonNull(optoutRedirectUrl);
        this.optoutUrl = Objects.requireNonNull(optoutUrl);
        this.optinUrl = Objects.requireNonNull(optinUrl);
    }

    public void handle(RoutingContext routingContext) {
        String recaptcha = OptoutHandler.getRequestParam(routingContext, RECAPTCHA_PARAM);
        if (StringUtils.isBlank((CharSequence)recaptcha)) {
            this.respondWithRedirect(routingContext);
            return;
        }
        this.googleRecaptchaVerifier.verify(recaptcha).onComplete(result -> this.handleVerification(routingContext, (AsyncResult<RecaptchaResponse>)result));
    }

    private void handleVerification(RoutingContext routingContext, AsyncResult<RecaptchaResponse> result) {
        if (result.failed()) {
            this.respondWithUnauthorized(routingContext, result.cause());
        } else {
            boolean optout = OptoutHandler.isOptout(routingContext);
            this.respondWithRedirectAndCookie(routingContext, this.optCookie(optout, routingContext), this.optUrl(optout));
        }
    }

    private void respondWithRedirect(RoutingContext routingContext) {
        HttpUtil.executeSafely(routingContext, Endpoint.optout, response -> response.setStatusCode(HttpResponseStatus.MOVED_PERMANENTLY.code()).putHeader(HttpUtil.LOCATION_HEADER, (CharSequence)this.optoutRedirectUrl).end());
    }

    private void respondWithUnauthorized(RoutingContext routingContext, Throwable exception) {
        logger.warn((Object)"Opt Out failed optout", exception);
        HttpUtil.executeSafely(routingContext, Endpoint.optout, response -> response.setStatusCode(HttpResponseStatus.UNAUTHORIZED.code()).end());
    }

    private void respondWithRedirectAndCookie(RoutingContext routingContext, Cookie cookie, String url) {
        HttpUtil.executeSafely(routingContext, Endpoint.optout, response -> response.setStatusCode(HttpResponseStatus.MOVED_PERMANENTLY.code()).putHeader(HttpUtil.LOCATION_HEADER, (CharSequence)url).putHeader(HttpUtil.SET_COOKIE_HEADER, (CharSequence)cookie.encode()).end());
    }

    private static boolean isOptout(RoutingContext routingContext) {
        String optoutValue = OptoutHandler.getRequestParam(routingContext, OPTOUT_PARAM);
        return StringUtils.isNotEmpty((CharSequence)optoutValue);
    }

    private Cookie optCookie(boolean optout, RoutingContext routingContext) {
        UidsCookie uidsCookie = this.uidsCookieService.parseFromRequest(routingContext).updateOptout(optout);
        return this.uidsCookieService.toCookie(uidsCookie);
    }

    private String optUrl(boolean optout) {
        return optout ? this.optoutUrl : this.optinUrl;
    }

    private static String getRequestParam(RoutingContext routingContext, String paramName) {
        String recaptcha = routingContext.request().getFormAttribute(paramName);
        return StringUtils.isNotEmpty((CharSequence)recaptcha) ? recaptcha : routingContext.request().getParam(paramName);
    }

    public static String getOptoutRedirectUrl(String externalUrl) {
        try {
            URL url = new URL(externalUrl);
            return new URL(url.toExternalForm() + "/static/optout.html").toString();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Could not get optout redirect url", e);
        }
    }
}

