/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.handler;

import io.netty.handler.codec.http.HttpHeaderValues;
import io.vertx.core.Handler;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.RoutingContext;
import java.util.Objects;
import org.prebid.server.deals.DeliveryProgressService;
import org.prebid.server.deals.proto.report.DeliveryProgressReport;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.util.HttpUtil;

public class DealsStatusHandler
implements Handler<RoutingContext> {
    private static final Logger logger = LoggerFactory.getLogger(DealsStatusHandler.class);
    private final DeliveryProgressService deliveryProgressService;
    private final JacksonMapper mapper;

    public DealsStatusHandler(DeliveryProgressService deliveryProgressService, JacksonMapper mapper) {
        this.deliveryProgressService = Objects.requireNonNull(deliveryProgressService);
        this.mapper = Objects.requireNonNull(mapper);
    }

    public void handle(RoutingContext routingContext) {
        DeliveryProgressReport deliveryProgressReport = this.deliveryProgressService.getOverallDeliveryProgressReport();
        String body = this.mapper.encodeToString(deliveryProgressReport);
        if (routingContext.response().closed()) {
            logger.warn((Object)"The client already closed connection, response will be skipped");
            return;
        }
        routingContext.response().putHeader(HttpUtil.CONTENT_TYPE_HEADER, (CharSequence)HttpHeaderValues.APPLICATION_JSON).exceptionHandler(this::handleResponseException).end(body);
    }

    private void handleResponseException(Throwable throwable) {
        logger.warn((Object)"Failed to send deals status response: {0}", new Object[]{throwable.getMessage()});
    }
}

