/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.geolocation;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.time.Clock;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.prebid.server.execution.Timeout;
import org.prebid.server.geolocation.GeoLocationService;
import org.prebid.server.geolocation.model.GeoInfo;
import org.prebid.server.log.ConditionalLogger;
import org.prebid.server.metric.Metrics;
import org.prebid.server.vertx.CircuitBreaker;

public class CircuitBreakerSecuredGeoLocationService
implements GeoLocationService {
    private static final Logger logger = LoggerFactory.getLogger(CircuitBreakerSecuredGeoLocationService.class);
    private static final ConditionalLogger conditionalLogger = new ConditionalLogger(logger);
    private static final int LOG_PERIOD_SECONDS = 5;
    private final GeoLocationService geoLocationService;
    private final CircuitBreaker breaker;

    public CircuitBreakerSecuredGeoLocationService(Vertx vertx, GeoLocationService geoLocationService, Metrics metrics, int openingThreshold, long openingIntervalMs, long closingIntervalMs, Clock clock) {
        this.geoLocationService = Objects.requireNonNull(geoLocationService);
        this.breaker = new CircuitBreaker("geo_cb", Objects.requireNonNull(vertx), openingThreshold, openingIntervalMs, closingIntervalMs, Objects.requireNonNull(clock)).openHandler((Handler<Void>)((Handler)ignored -> this.circuitOpened())).halfOpenHandler((Handler<Void>)((Handler)ignored -> this.circuitHalfOpened())).closeHandler((Handler<Void>)((Handler)ignored -> this.circuitClosed()));
        metrics.createGeoLocationCircuitBreakerGauge(this.breaker::isOpen);
        logger.info((Object)"Initialized GeoLocation service with Circuit Breaker");
    }

    @Override
    public Future<GeoInfo> lookup(String ip, Timeout timeout) {
        return this.breaker.execute(promise -> this.geoLocationService.lookup(ip, timeout).onComplete((Handler)promise));
    }

    private void circuitOpened() {
        conditionalLogger.warn("GeoLocation service is unavailable, circuit opened.", 5L, TimeUnit.SECONDS);
    }

    private void circuitHalfOpened() {
        logger.warn((Object)"GeoLocation service is ready to try again, circuit half-opened.");
    }

    private void circuitClosed() {
        logger.warn((Object)"GeoLocation service becomes working, circuit closed.");
    }
}

