/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.floors;

import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.auction.model.AuctionParticipation;
import org.prebid.server.auction.model.BidRejectionReason;
import org.prebid.server.auction.model.BidRejectionTracker;
import org.prebid.server.auction.model.BidderRequest;
import org.prebid.server.auction.model.BidderResponse;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.BidderSeatBid;
import org.prebid.server.bidder.model.PriceFloorInfo;
import org.prebid.server.currency.CurrencyConversionService;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.floors.PriceFloorEnforcer;
import org.prebid.server.floors.model.PriceFloorEnforcement;
import org.prebid.server.floors.model.PriceFloorRules;
import org.prebid.server.log.ConditionalLogger;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.Metrics;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebid;
import org.prebid.server.settings.model.Account;
import org.prebid.server.settings.model.AccountAuctionConfig;
import org.prebid.server.settings.model.AccountPriceFloorsConfig;
import org.prebid.server.util.ObjectUtil;

public class BasicPriceFloorEnforcer
implements PriceFloorEnforcer {
    private static final Logger logger = LoggerFactory.getLogger(BasicPriceFloorEnforcer.class);
    private static final ConditionalLogger conditionalLogger = new ConditionalLogger(logger);
    private static final int ENFORCE_RATE_MIN = 0;
    private static final int ENFORCE_RATE_MAX = 100;
    private final CurrencyConversionService currencyConversionService;
    private final Metrics metrics;

    public BasicPriceFloorEnforcer(CurrencyConversionService currencyConversionService, Metrics metrics) {
        this.currencyConversionService = Objects.requireNonNull(currencyConversionService);
        this.metrics = Objects.requireNonNull(metrics);
    }

    @Override
    public AuctionParticipation enforce(BidRequest bidRequest, AuctionParticipation auctionParticipation, Account account, BidRejectionTracker rejectionTracker) {
        return BasicPriceFloorEnforcer.shouldApplyEnforcement(auctionParticipation, account) ? this.applyEnforcement(bidRequest, auctionParticipation, account, rejectionTracker) : auctionParticipation;
    }

    private static boolean shouldApplyEnforcement(AuctionParticipation auctionParticipation, Account account) {
        AccountPriceFloorsConfig accountPriceFloorsConfig = ObjectUtil.getIfNotNull(account.getAuction(), AccountAuctionConfig::getPriceFloors);
        if (accountPriceFloorsConfig == null || BooleanUtils.isFalse((Boolean)accountPriceFloorsConfig.getEnabled())) {
            return false;
        }
        Optional<PriceFloorRules> floors = BasicPriceFloorEnforcer.extractFloors(auctionParticipation);
        Boolean enabled = floors.map(PriceFloorRules::getEnabled).orElse(null);
        Boolean skipped = floors.map(PriceFloorRules::getSkipped).orElse(null);
        if (BooleanUtils.isFalse((Boolean)enabled) || BooleanUtils.isTrue((Boolean)skipped)) {
            return false;
        }
        PriceFloorEnforcement enforcement = floors.map(PriceFloorRules::getEnforcement).orElse(null);
        if (BasicPriceFloorEnforcer.isNotEnforcedByRequest(enforcement)) {
            return false;
        }
        return BasicPriceFloorEnforcer.isSatisfiedByEnforceRate(enforcement, accountPriceFloorsConfig);
    }

    private static Optional<PriceFloorRules> extractFloors(AuctionParticipation auctionParticipation) {
        return Optional.ofNullable(auctionParticipation.getBidderRequest()).map(BidderRequest::getBidRequest).map(BidRequest::getExt).map(ExtRequest::getPrebid).map(ExtRequestPrebid::getFloors);
    }

    private static boolean isNotEnforcedByRequest(PriceFloorEnforcement enforcement) {
        Boolean enforcePbs = ObjectUtil.getIfNotNull(enforcement, PriceFloorEnforcement::getEnforcePbs);
        return BooleanUtils.isFalse((Boolean)enforcePbs);
    }

    private static boolean isSatisfiedByEnforceRate(PriceFloorEnforcement enforcement, AccountPriceFloorsConfig accountPriceFloorsConfig) {
        Integer requestEnforceRate = ObjectUtil.getIfNotNull(enforcement, PriceFloorEnforcement::getEnforceRate);
        Integer accountEnforceRate = accountPriceFloorsConfig.getEnforceFloorsRate();
        if (requestEnforceRate == null && accountEnforceRate == null) {
            return true;
        }
        if (BasicPriceFloorEnforcer.isNotValidEnforceRate(requestEnforceRate) || BasicPriceFloorEnforcer.isNotValidEnforceRate(accountEnforceRate)) {
            return false;
        }
        int pickedRate = ThreadLocalRandom.current().nextInt(100);
        boolean satisfiedByRequest = requestEnforceRate == null || pickedRate < requestEnforceRate;
        boolean satisfiedByAccount = accountEnforceRate == null || pickedRate < accountEnforceRate;
        return satisfiedByRequest && satisfiedByAccount;
    }

    private static boolean isNotValidEnforceRate(Integer value) {
        return value != null && (value < 0 || value > 100);
    }

    private AuctionParticipation applyEnforcement(BidRequest bidRequest, AuctionParticipation auctionParticipation, Account account, BidRejectionTracker rejectionTracker) {
        BidderResponse bidderResponse = auctionParticipation.getBidderResponse();
        BidderSeatBid seatBid = ObjectUtil.getIfNotNull(bidderResponse, BidderResponse::getSeatBid);
        List bidderBids = ObjectUtil.getIfNotNull(seatBid, BidderSeatBid::getBids);
        if (CollectionUtils.isEmpty((Collection)bidderBids)) {
            return auctionParticipation;
        }
        ArrayList<BidderBid> updatedBidderBids = new ArrayList<BidderBid>(bidderBids);
        ArrayList<BidderError> errors = new ArrayList<BidderError>(seatBid.getErrors());
        ArrayList<BidderError> warnings = new ArrayList<BidderError>(seatBid.getWarnings());
        BidRequest bidderBidRequest = Optional.ofNullable(auctionParticipation.getBidderRequest()).map(BidderRequest::getBidRequest).orElse(null);
        boolean enforceDealFloors = BasicPriceFloorEnforcer.enforceDealFloors(auctionParticipation, account);
        for (BidderBid bidderBid : bidderBids) {
            BigDecimal floor;
            BigDecimal price;
            Bid bid = bidderBid.getBid();
            if (StringUtils.isNotEmpty((CharSequence)bid.getDealid()) && !enforceDealFloors || !BasicPriceFloorEnforcer.isPriceBelowFloor(price = bid.getPrice(), floor = this.resolveFloor(bidderBid, bidderBidRequest, bidRequest, errors))) continue;
            String impId = bid.getImpid();
            warnings.add(BidderError.rejectedIpf("Bid with id '%s' was rejected by floor enforcement: price %s is below the floor %s".formatted(bid.getId(), price, floor), impId));
            rejectionTracker.reject(impId, BidRejectionReason.REJECTED_DUE_TO_PRICE_FLOOR);
            updatedBidderBids.remove(bidderBid);
        }
        if (bidderBids.size() == updatedBidderBids.size() && seatBid.getErrors().size() == errors.size() && seatBid.getWarnings().size() == warnings.size()) {
            return auctionParticipation;
        }
        rejectionTracker.restoreFromRejection(updatedBidderBids);
        BidderSeatBid bidderSeatBid = seatBid.toBuilder().bids(updatedBidderBids).errors(errors).warnings(warnings).build();
        return auctionParticipation.with(bidderResponse.with(bidderSeatBid));
    }

    private static boolean enforceDealFloors(AuctionParticipation auctionParticipation, Account account) {
        Boolean requestEnforceDealFloors = BasicPriceFloorEnforcer.extractFloors(auctionParticipation).map(PriceFloorRules::getEnforcement).map(PriceFloorEnforcement::getFloorDeals).orElse(null);
        AccountPriceFloorsConfig accountPriceFloorsConfig = account.getAuction().getPriceFloors();
        Boolean accountEnforceDealFloors = accountPriceFloorsConfig.getEnforceDealFloors();
        return BooleanUtils.isTrue((Boolean)requestEnforceDealFloors) && BooleanUtils.isTrue((Boolean)accountEnforceDealFloors);
    }

    private BigDecimal resolveFloor(BidderBid bidderBid, BidRequest bidderBidRequest, BidRequest bidRequest, List<BidderError> errors) {
        PriceFloorInfo priceFloorInfo = bidderBid.getPriceFloorInfo();
        BigDecimal customBidderFloor = ObjectUtil.getIfNotNull(priceFloorInfo, PriceFloorInfo::getFloor);
        try {
            if (customBidderFloor != null) {
                return this.convertIfRequired(customBidderFloor, priceFloorInfo.getCurrency(), bidderBidRequest, bidRequest);
            }
            Imp imp = BasicPriceFloorEnforcer.correspondingImp(bidderBid.getBid(), bidRequest.getImp());
            String bidRequestCurrency = BasicPriceFloorEnforcer.resolveBidRequestCurrency(bidRequest);
            return this.convertCurrency(imp.getBidfloor(), bidRequest, imp.getBidfloorcur(), bidRequestCurrency);
        }
        catch (PreBidException e) {
            String logMessage = "Price floors enforcement failed for request id: %s, reason: %s".formatted(bidRequest.getId(), e.getMessage());
            logger.debug((Object)logMessage);
            conditionalLogger.error(logMessage, 0.01);
            this.metrics.updatePriceFloorGeneralAlertsMetric(MetricName.err);
            errors.add(BidderError.badServerResponse("Price floors enforcement failed: " + e.getMessage()));
            return null;
        }
    }

    private BigDecimal convertIfRequired(BigDecimal floor, String floorCurrency, BidRequest bidderBidRequest, BidRequest bidRequest) {
        String resolvedFloorCurrency = (String)ObjectUtils.defaultIfNull((Object)floorCurrency, (Object)BasicPriceFloorEnforcer.resolveBidRequestCurrency(bidderBidRequest));
        String bidRequestCurrency = BasicPriceFloorEnforcer.resolveBidRequestCurrency(bidRequest);
        return this.convertCurrency(floor, bidRequest, resolvedFloorCurrency, bidRequestCurrency);
    }

    private BigDecimal convertCurrency(BigDecimal floor, BidRequest bidRequest, String fromCurrency, String toCurrency) {
        if (fromCurrency != null && !fromCurrency.equals(toCurrency)) {
            return this.currencyConversionService.convertCurrency(floor, bidRequest, fromCurrency, toCurrency);
        }
        return floor;
    }

    private static String resolveBidRequestCurrency(BidRequest bidRequest) {
        List currencies = ObjectUtil.getIfNotNull(bidRequest, BidRequest::getCur);
        return CollectionUtils.isEmpty((Collection)currencies) ? null : (String)currencies.get(0);
    }

    private static Imp correspondingImp(Bid bid, List<Imp> imps) {
        String impId = bid.getImpid();
        return ListUtils.emptyIfNull(imps).stream().filter(imp -> Objects.equals(impId, imp.getId())).findFirst().orElseThrow(() -> new PreBidException("Bid with impId %s doesn't have matched imp".formatted(impId)));
    }

    private static boolean isPriceBelowFloor(BigDecimal price, BigDecimal bidFloor) {
        return bidFloor != null && price.compareTo(bidFloor) < 0;
    }
}

