/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.execution.retry;

import java.beans.ConstructorProperties;
import java.util.concurrent.ThreadLocalRandom;
import org.prebid.server.execution.retry.RetryPolicy;
import org.prebid.server.execution.retry.Retryable;

public final class ExponentialBackoffRetryPolicy
implements Retryable {
    private final long delay;
    private final long maxDelayMillis;
    private final double factor;
    private final double jitter;

    @Override
    public RetryPolicy next() {
        long nextDelay = (long)Math.min((double)this.delay * this.factor, (double)this.maxDelayMillis);
        long variedDelay = nextDelay + (long)ThreadLocalRandom.current().nextDouble((double)nextDelay * this.jitter);
        return ExponentialBackoffRetryPolicy.of(variedDelay, this.maxDelayMillis, this.factor, this.jitter);
    }

    @ConstructorProperties(value={"delay", "maxDelayMillis", "factor", "jitter"})
    private ExponentialBackoffRetryPolicy(long delay, long maxDelayMillis, double factor, double jitter) {
        this.delay = delay;
        this.maxDelayMillis = maxDelayMillis;
        this.factor = factor;
        this.jitter = jitter;
    }

    public static ExponentialBackoffRetryPolicy of(long delay, long maxDelayMillis, double factor, double jitter) {
        return new ExponentialBackoffRetryPolicy(delay, maxDelayMillis, factor, jitter);
    }

    @Override
    public long delay() {
        return this.delay;
    }

    public long maxDelayMillis() {
        return this.maxDelayMillis;
    }

    public double factor() {
        return this.factor;
    }

    public double jitter() {
        return this.jitter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExponentialBackoffRetryPolicy)) {
            return false;
        }
        ExponentialBackoffRetryPolicy other = (ExponentialBackoffRetryPolicy)o;
        if (this.delay() != other.delay()) {
            return false;
        }
        if (this.maxDelayMillis() != other.maxDelayMillis()) {
            return false;
        }
        if (Double.compare(this.factor(), other.factor()) != 0) {
            return false;
        }
        return Double.compare(this.jitter(), other.jitter()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $delay = this.delay();
        result = result * 59 + (int)($delay >>> 32 ^ $delay);
        long $maxDelayMillis = this.maxDelayMillis();
        result = result * 59 + (int)($maxDelayMillis >>> 32 ^ $maxDelayMillis);
        long $factor = Double.doubleToLongBits(this.factor());
        result = result * 59 + (int)($factor >>> 32 ^ $factor);
        long $jitter = Double.doubleToLongBits(this.jitter());
        result = result * 59 + (int)($jitter >>> 32 ^ $jitter);
        return result;
    }

    public String toString() {
        return "ExponentialBackoffRetryPolicy(delay=" + this.delay() + ", maxDelayMillis=" + this.maxDelayMillis() + ", factor=" + this.factor() + ", jitter=" + this.jitter() + ")";
    }
}

