/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.execution;

import java.time.Clock;
import org.prebid.server.execution.Timeout;

public class TimeoutFactory {
    private final Clock clock;

    public TimeoutFactory(Clock clock) {
        this.clock = clock;
    }

    public Timeout create(long startTime, long timeout) {
        if (startTime < 1L || timeout < 1L) {
            throw new IllegalArgumentException("Start time and timeout must be positive");
        }
        return new Timeout(this.clock, startTime + timeout);
    }

    public Timeout create(long timeout) {
        return this.create(this.clock.millis(), timeout);
    }
}

