/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals.targeting.syntax;

import java.util.Arrays;

public enum BooleanOperator {
    AND("$and"),
    OR("$or"),
    NOT("$not");

    private final String value;

    private BooleanOperator(String value) {
        this.value = value;
    }

    public static boolean isBooleanOperator(String candidate) {
        return Arrays.stream(BooleanOperator.values()).anyMatch(op -> op.value.equals(candidate));
    }

    public static BooleanOperator fromString(String candidate) {
        for (BooleanOperator op : BooleanOperator.values()) {
            if (!op.value.equals(candidate)) continue;
            return op;
        }
        throw new IllegalArgumentException("Unrecognized boolean operator: " + candidate);
    }
}

