/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals.targeting.model;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.collections4.ListUtils;

public final class LookupResult<T> {
    private static final LookupResult<Object> EMPTY = LookupResult.of(Collections.emptyList());
    private final List<T> values;

    public static <T> LookupResult<T> empty() {
        return EMPTY;
    }

    public static <T> LookupResult<T> ofValue(T value) {
        return LookupResult.of(Collections.singletonList(value));
    }

    public boolean anyMatch(Predicate<T> matcher) {
        return this.values.stream().anyMatch(matcher);
    }

    public LookupResult<T> orElse(List<T> orValues) {
        return LookupResult.of(ListUtils.union(this.values, orValues));
    }

    @ConstructorProperties(value={"values"})
    private LookupResult(List<T> values) {
        this.values = values;
    }

    public static <T> LookupResult<T> of(List<T> values) {
        return new LookupResult<T>(values);
    }

    public List<T> getValues() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LookupResult)) {
            return false;
        }
        LookupResult other = (LookupResult)o;
        List<T> this$values = this.getValues();
        List<T> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<T> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }

    public String toString() {
        return "LookupResult(values=" + this.getValues() + ")";
    }
}

