/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals.targeting.interpret;

import java.util.Objects;
import org.prebid.server.deals.targeting.RequestContext;
import org.prebid.server.deals.targeting.interpret.TerminalExpression;
import org.prebid.server.deals.targeting.model.GeoLocation;
import org.prebid.server.deals.targeting.model.GeoRegion;
import org.prebid.server.deals.targeting.syntax.TargetingCategory;

public class Within
implements TerminalExpression {
    private static final int EARTH_RADIUS_MI = 3959;
    private final TargetingCategory category;
    private final GeoRegion value;

    public Within(TargetingCategory category, GeoRegion value) {
        this.category = Objects.requireNonNull(category);
        this.value = Objects.requireNonNull(value);
    }

    @Override
    public boolean matches(RequestContext context) {
        GeoLocation location = context.lookupGeoLocation(this.category);
        return location != null && this.isLocationWithinRegion(location);
    }

    private boolean isLocationWithinRegion(GeoLocation location) {
        double distance = Within.calculateDistance(location.getLat().floatValue(), location.getLon().floatValue(), this.value.getLat().floatValue(), this.value.getLon().floatValue());
        return (double)this.value.getRadiusMiles().floatValue() > distance;
    }

    private static double calculateDistance(double startLat, double startLong, double endLat, double endLong) {
        double dLat = Math.toRadians(endLat - startLat);
        double dLong = Math.toRadians(endLong - startLong);
        double a = Math.pow(Math.sin(dLat / 2.0), 2.0) + Math.cos(Math.toRadians(startLat)) * Math.cos(Math.toRadians(endLat)) * Math.pow(Math.sin(dLong / 2.0), 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return 3959.0 * c;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Within)) {
            return false;
        }
        Within other = (Within)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TargetingCategory this$category = this.category;
        TargetingCategory other$category = other.category;
        if (this$category == null ? other$category != null : !((Object)this$category).equals(other$category)) {
            return false;
        }
        GeoRegion this$value = this.value;
        GeoRegion other$value = other.value;
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Within;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TargetingCategory $category = this.category;
        result = result * 59 + ($category == null ? 43 : ((Object)$category).hashCode());
        GeoRegion $value = this.value;
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }
}

