/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals.simulation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.Deal;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import io.vertx.core.Future;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.auction.BidderAliases;
import org.prebid.server.auction.model.BidRejectionReason;
import org.prebid.server.auction.model.BidRejectionTracker;
import org.prebid.server.auction.model.BidderRequest;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.BidderErrorNotifier;
import org.prebid.server.bidder.BidderRequestCompletionTrackerFactory;
import org.prebid.server.bidder.HttpBidderRequestEnricher;
import org.prebid.server.bidder.HttpBidderRequester;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.BidderSeatBid;
import org.prebid.server.deals.LineItemService;
import org.prebid.server.deals.lineitem.LineItem;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.execution.Timeout;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.model.CaseInsensitiveMultiMap;
import org.prebid.server.proto.openrtb.ext.request.ExtDeal;
import org.prebid.server.proto.openrtb.ext.request.ExtDealLine;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.vertx.http.HttpClient;

public class SimulationAwareHttpBidderRequester
extends HttpBidderRequester {
    private static final BigDecimal DEFAULT_CPM = BigDecimal.ONE;
    private static final String DEFAULT_ADM = "<Impression><![CDATA[]]></Impression>";
    private static final String DEFAULT_CRID = "crid";
    private static final String DEFAULT_CURRENCY = "USD";
    private static final String BID_ID_FORMAT = "%s-%s";
    private final Map<String, Double> bidRates;
    private final LineItemService lineItemService;
    private final JacksonMapper mapper;

    public SimulationAwareHttpBidderRequester(HttpClient httpClient, BidderRequestCompletionTrackerFactory bidderRequestCompletionTrackerFactory, BidderErrorNotifier bidderErrorNotifier, HttpBidderRequestEnricher requestEnricher, LineItemService lineItemService, JacksonMapper mapper) {
        super(httpClient, bidderRequestCompletionTrackerFactory, bidderErrorNotifier, requestEnricher, mapper);
        this.lineItemService = Objects.requireNonNull(lineItemService);
        this.mapper = Objects.requireNonNull(mapper);
        this.bidRates = new HashMap<String, Double>();
    }

    void setBidRates(Map<String, Double> bidRates) {
        this.bidRates.putAll(bidRates);
    }

    @Override
    public <T> Future<BidderSeatBid> requestBids(Bidder<T> bidder, BidderRequest bidderRequest, BidRejectionTracker bidRejectionTracker, Timeout timeout, CaseInsensitiveMultiMap requestHeaders, BidderAliases aliases, boolean debugEnabled) {
        List<Imp> imps = bidderRequest.getBidRequest().getImp();
        Map idToImps = imps.stream().collect(Collectors.toMap(Imp::getId, Function.identity()));
        Map<String, Set> impsToDealInfo = imps.stream().filter(imp -> imp.getPmp() != null).collect(Collectors.toMap(Imp::getId, imp -> imp.getPmp().getDeals().stream().map(deal -> DealInfo.of(deal.getId(), this.getLineItemId((Deal)deal))).filter(dealInfo -> dealInfo.getLineItemId() != null).collect(Collectors.toSet())));
        if (impsToDealInfo.values().stream().noneMatch(CollectionUtils::isNotEmpty)) {
            bidRejectionTracker.rejectAll(BidRejectionReason.FAILED_TO_REQUEST_BIDS);
            return Future.succeededFuture((Object)BidderSeatBid.builder().errors(Collections.singletonList(BidderError.failedToRequestBids("Matched or ready to serve line items were not found, but required in simulation mode"))).build());
        }
        List<BidderBid> bidderBids = impsToDealInfo.entrySet().stream().flatMap(impToDealInfo -> ((Set)impToDealInfo.getValue()).stream().map(dealInfo -> this.createBid((Imp)idToImps.get(impToDealInfo.getKey()), dealInfo.getDealId(), dealInfo.getLineItemId())).filter(Objects::nonNull)).map(bid -> BidderBid.of(bid, BidType.banner, DEFAULT_CURRENCY)).toList();
        return Future.succeededFuture((Object)BidderSeatBid.of(bidderBids));
    }

    private String getLineItemId(Deal deal) {
        ObjectNode extDealNode = deal.getExt();
        ExtDeal extDeal = extDealNode != null ? this.getExtDeal((JsonNode)extDealNode) : null;
        ExtDealLine extDealLine = extDeal != null ? extDeal.getLine() : null;
        return extDealLine != null ? extDealLine.getLineItemId() : null;
    }

    private Bid createBid(Imp imp, String dealId, String lineItemId) {
        Double rate = this.bidRates.get(lineItemId);
        if (rate == null) {
            throw new PreBidException("Bid rate for line item with id %s was not found".formatted(lineItemId));
        }
        String impId = imp.getId();
        LineItem lineItem = this.lineItemService.getLineItemById(lineItemId);
        List<Format> sizes = this.getLineItemSizes(imp);
        return Math.random() < rate ? Bid.builder().id(BID_ID_FORMAT.formatted(impId, lineItemId)).impid(impId).dealid(dealId).price(lineItem != null ? lineItem.getCpm() : DEFAULT_CPM).adm(DEFAULT_ADM).crid(DEFAULT_CRID).w(sizes.isEmpty() ? 0 : sizes.get(0).getW()).h(sizes.isEmpty() ? 0 : sizes.get(0).getH()).build() : null;
    }

    private List<Format> getLineItemSizes(Imp imp) {
        return imp.getPmp().getDeals().stream().map(Deal::getExt).filter(Objects::nonNull).map(this::getExtDeal).filter(Objects::nonNull).map(ExtDeal::getLine).filter(Objects::nonNull).map(ExtDealLine::getSizes).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).toList();
    }

    private ExtDeal getExtDeal(JsonNode extDeal) {
        try {
            return (ExtDeal)this.mapper.mapper().treeToValue((TreeNode)extDeal, ExtDeal.class);
        }
        catch (JsonProcessingException e) {
            throw new PreBidException("Error decoding bidRequest.imp.pmp.deal.ext: " + e.getMessage(), e);
        }
    }

    private static final class DealInfo {
        private final String dealId;
        private final String lineItemId;

        public String getDealId() {
            return this.dealId;
        }

        public String getLineItemId() {
            return this.lineItemId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DealInfo)) {
                return false;
            }
            DealInfo other = (DealInfo)o;
            String this$dealId = this.getDealId();
            String other$dealId = other.getDealId();
            if (this$dealId == null ? other$dealId != null : !this$dealId.equals(other$dealId)) {
                return false;
            }
            String this$lineItemId = this.getLineItemId();
            String other$lineItemId = other.getLineItemId();
            return !(this$lineItemId == null ? other$lineItemId != null : !this$lineItemId.equals(other$lineItemId));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $dealId = this.getDealId();
            result = result * 59 + ($dealId == null ? 43 : $dealId.hashCode());
            String $lineItemId = this.getLineItemId();
            result = result * 59 + ($lineItemId == null ? 43 : $lineItemId.hashCode());
            return result;
        }

        public String toString() {
            return "SimulationAwareHttpBidderRequester.DealInfo(dealId=" + this.getDealId() + ", lineItemId=" + this.getLineItemId() + ")";
        }

        @ConstructorProperties(value={"dealId", "lineItemId"})
        private DealInfo(String dealId, String lineItemId) {
            this.dealId = dealId;
            this.lineItemId = lineItemId;
        }

        public static DealInfo of(String dealId, String lineItemId) {
            return new DealInfo(dealId, lineItemId);
        }
    }
}

