/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals.model;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import org.prebid.server.deals.model.DeviceType;

public final class DeviceInfo {
    @NonNull
    private final String vendor;
    private final DeviceType deviceType;
    private final String deviceTypeRaw;
    private final String osfamily;
    private final String os;
    private final String osVersion;
    private final String manufacturer;
    private final String model;
    private final String browser;
    private final String browserVersion;
    private final String carrier;
    private final String language;

    @ConstructorProperties(value={"vendor", "deviceType", "deviceTypeRaw", "osfamily", "os", "osVersion", "manufacturer", "model", "browser", "browserVersion", "carrier", "language"})
    DeviceInfo(@NonNull String vendor, DeviceType deviceType, String deviceTypeRaw, String osfamily, String os, String osVersion, String manufacturer, String model, String browser, String browserVersion, String carrier, String language) {
        if (vendor == null) {
            throw new NullPointerException("vendor is marked non-null but is null");
        }
        this.vendor = vendor;
        this.deviceType = deviceType;
        this.deviceTypeRaw = deviceTypeRaw;
        this.osfamily = osfamily;
        this.os = os;
        this.osVersion = osVersion;
        this.manufacturer = manufacturer;
        this.model = model;
        this.browser = browser;
        this.browserVersion = browserVersion;
        this.carrier = carrier;
        this.language = language;
    }

    public static DeviceInfoBuilder builder() {
        return new DeviceInfoBuilder();
    }

    @NonNull
    public String getVendor() {
        return this.vendor;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public String getDeviceTypeRaw() {
        return this.deviceTypeRaw;
    }

    public String getOsfamily() {
        return this.osfamily;
    }

    public String getOs() {
        return this.os;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getModel() {
        return this.model;
    }

    public String getBrowser() {
        return this.browser;
    }

    public String getBrowserVersion() {
        return this.browserVersion;
    }

    public String getCarrier() {
        return this.carrier;
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceInfo)) {
            return false;
        }
        DeviceInfo other = (DeviceInfo)o;
        String this$vendor = this.getVendor();
        String other$vendor = other.getVendor();
        if (this$vendor == null ? other$vendor != null : !this$vendor.equals(other$vendor)) {
            return false;
        }
        DeviceType this$deviceType = this.getDeviceType();
        DeviceType other$deviceType = other.getDeviceType();
        if (this$deviceType == null ? other$deviceType != null : !((Object)((Object)this$deviceType)).equals((Object)other$deviceType)) {
            return false;
        }
        String this$deviceTypeRaw = this.getDeviceTypeRaw();
        String other$deviceTypeRaw = other.getDeviceTypeRaw();
        if (this$deviceTypeRaw == null ? other$deviceTypeRaw != null : !this$deviceTypeRaw.equals(other$deviceTypeRaw)) {
            return false;
        }
        String this$osfamily = this.getOsfamily();
        String other$osfamily = other.getOsfamily();
        if (this$osfamily == null ? other$osfamily != null : !this$osfamily.equals(other$osfamily)) {
            return false;
        }
        String this$os = this.getOs();
        String other$os = other.getOs();
        if (this$os == null ? other$os != null : !this$os.equals(other$os)) {
            return false;
        }
        String this$osVersion = this.getOsVersion();
        String other$osVersion = other.getOsVersion();
        if (this$osVersion == null ? other$osVersion != null : !this$osVersion.equals(other$osVersion)) {
            return false;
        }
        String this$manufacturer = this.getManufacturer();
        String other$manufacturer = other.getManufacturer();
        if (this$manufacturer == null ? other$manufacturer != null : !this$manufacturer.equals(other$manufacturer)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$browser = this.getBrowser();
        String other$browser = other.getBrowser();
        if (this$browser == null ? other$browser != null : !this$browser.equals(other$browser)) {
            return false;
        }
        String this$browserVersion = this.getBrowserVersion();
        String other$browserVersion = other.getBrowserVersion();
        if (this$browserVersion == null ? other$browserVersion != null : !this$browserVersion.equals(other$browserVersion)) {
            return false;
        }
        String this$carrier = this.getCarrier();
        String other$carrier = other.getCarrier();
        if (this$carrier == null ? other$carrier != null : !this$carrier.equals(other$carrier)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        return !(this$language == null ? other$language != null : !this$language.equals(other$language));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $vendor = this.getVendor();
        result = result * 59 + ($vendor == null ? 43 : $vendor.hashCode());
        DeviceType $deviceType = this.getDeviceType();
        result = result * 59 + ($deviceType == null ? 43 : ((Object)((Object)$deviceType)).hashCode());
        String $deviceTypeRaw = this.getDeviceTypeRaw();
        result = result * 59 + ($deviceTypeRaw == null ? 43 : $deviceTypeRaw.hashCode());
        String $osfamily = this.getOsfamily();
        result = result * 59 + ($osfamily == null ? 43 : $osfamily.hashCode());
        String $os = this.getOs();
        result = result * 59 + ($os == null ? 43 : $os.hashCode());
        String $osVersion = this.getOsVersion();
        result = result * 59 + ($osVersion == null ? 43 : $osVersion.hashCode());
        String $manufacturer = this.getManufacturer();
        result = result * 59 + ($manufacturer == null ? 43 : $manufacturer.hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $browser = this.getBrowser();
        result = result * 59 + ($browser == null ? 43 : $browser.hashCode());
        String $browserVersion = this.getBrowserVersion();
        result = result * 59 + ($browserVersion == null ? 43 : $browserVersion.hashCode());
        String $carrier = this.getCarrier();
        result = result * 59 + ($carrier == null ? 43 : $carrier.hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        return result;
    }

    public String toString() {
        return "DeviceInfo(vendor=" + this.getVendor() + ", deviceType=" + this.getDeviceType() + ", deviceTypeRaw=" + this.getDeviceTypeRaw() + ", osfamily=" + this.getOsfamily() + ", os=" + this.getOs() + ", osVersion=" + this.getOsVersion() + ", manufacturer=" + this.getManufacturer() + ", model=" + this.getModel() + ", browser=" + this.getBrowser() + ", browserVersion=" + this.getBrowserVersion() + ", carrier=" + this.getCarrier() + ", language=" + this.getLanguage() + ")";
    }

    public static class DeviceInfoBuilder {
        private String vendor;
        private DeviceType deviceType;
        private String deviceTypeRaw;
        private String osfamily;
        private String os;
        private String osVersion;
        private String manufacturer;
        private String model;
        private String browser;
        private String browserVersion;
        private String carrier;
        private String language;

        DeviceInfoBuilder() {
        }

        public DeviceInfoBuilder vendor(@NonNull String vendor) {
            if (vendor == null) {
                throw new NullPointerException("vendor is marked non-null but is null");
            }
            this.vendor = vendor;
            return this;
        }

        public DeviceInfoBuilder deviceType(DeviceType deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public DeviceInfoBuilder deviceTypeRaw(String deviceTypeRaw) {
            this.deviceTypeRaw = deviceTypeRaw;
            return this;
        }

        public DeviceInfoBuilder osfamily(String osfamily) {
            this.osfamily = osfamily;
            return this;
        }

        public DeviceInfoBuilder os(String os) {
            this.os = os;
            return this;
        }

        public DeviceInfoBuilder osVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        public DeviceInfoBuilder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            return this;
        }

        public DeviceInfoBuilder model(String model) {
            this.model = model;
            return this;
        }

        public DeviceInfoBuilder browser(String browser) {
            this.browser = browser;
            return this;
        }

        public DeviceInfoBuilder browserVersion(String browserVersion) {
            this.browserVersion = browserVersion;
            return this;
        }

        public DeviceInfoBuilder carrier(String carrier) {
            this.carrier = carrier;
            return this;
        }

        public DeviceInfoBuilder language(String language) {
            this.language = language;
            return this;
        }

        public DeviceInfo build() {
            return new DeviceInfo(this.vendor, this.deviceType, this.deviceTypeRaw, this.osfamily, this.os, this.osVersion, this.manufacturer, this.model, this.browser, this.browserVersion, this.carrier, this.language);
        }

        public String toString() {
            return "DeviceInfo.DeviceInfoBuilder(vendor=" + this.vendor + ", deviceType=" + this.deviceType + ", deviceTypeRaw=" + this.deviceTypeRaw + ", osfamily=" + this.osfamily + ", os=" + this.os + ", osVersion=" + this.osVersion + ", manufacturer=" + this.manufacturer + ", model=" + this.model + ", browser=" + this.browser + ", browserVersion=" + this.browserVersion + ", carrier=" + this.carrier + ", language=" + this.language + ")";
        }
    }
}

