/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals.lineitem;

import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.atomic.LongAdder;
import org.prebid.server.deals.proto.Token;

public class DeliveryToken
implements Comparable<DeliveryToken> {
    private static final Comparator<DeliveryToken> COMPARATOR = Comparator.comparing(DeliveryToken::getPriorityClass);
    private final Token token;
    private final LongAdder spent;

    private DeliveryToken(Token token) {
        this(token, new LongAdder());
    }

    private DeliveryToken(Token token, LongAdder spent) {
        this.token = Objects.requireNonNull(token);
        this.spent = Objects.requireNonNull(spent);
    }

    public static DeliveryToken of(DeliveryToken deliveryToken) {
        return new DeliveryToken(deliveryToken.token);
    }

    public static DeliveryToken of(Token token) {
        return new DeliveryToken(token);
    }

    public int getUnspent() {
        return (int)((long)this.token.getTotal().intValue() - this.spent.sum());
    }

    public void inc() {
        this.spent.increment();
    }

    public DeliveryToken mergeWithToken(Token nextToken, boolean sumTotal) {
        if (nextToken == null) {
            return this;
        }
        int total = sumTotal ? this.getTotal() + nextToken.getTotal() : nextToken.getTotal();
        return new DeliveryToken(Token.of(this.getPriorityClass(), total), this.spent);
    }

    public LongAdder getSpent() {
        return this.spent;
    }

    public Integer getTotal() {
        return this.token.getTotal();
    }

    public Integer getPriorityClass() {
        return this.token.getPriorityClass();
    }

    @Override
    public int compareTo(DeliveryToken another) {
        return COMPARATOR.compare(this, another);
    }
}

