/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.deals.DeliveryProgressService;
import org.prebid.server.deals.LineItemService;
import org.prebid.server.deals.Suspendable;
import org.prebid.server.deals.events.AdminEventProcessor;
import org.prebid.server.deals.model.AdminAccounts;
import org.prebid.server.deals.model.AdminCentralResponse;
import org.prebid.server.deals.model.AdminLineItems;
import org.prebid.server.deals.model.Command;
import org.prebid.server.deals.model.LogTracer;
import org.prebid.server.deals.model.ServicesCommand;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.log.CriteriaManager;
import org.prebid.server.settings.CachingApplicationSettings;
import org.prebid.server.settings.SettingsCache;
import org.prebid.server.settings.proto.request.InvalidateSettingsCacheRequest;
import org.prebid.server.settings.proto.request.UpdateSettingsCacheRequest;
import org.prebid.server.util.ObjectUtil;

public class AdminCentralService
implements AdminEventProcessor {
    private static final Logger logger = LoggerFactory.getLogger(AdminCentralService.class);
    private static final String START = "start";
    private static final String STOP = "stop";
    private static final String INVALIDATE = "invalidate";
    private static final String SAVE = "save";
    private static final String STORED_REQUEST_CACHE = "stored request cache";
    private static final String AMP_STORED_REQUEST_CACHE = "amp stored request cache";
    private final CriteriaManager criteriaManager;
    private final LineItemService lineItemService;
    private final DeliveryProgressService deliveryProgressService;
    private final SettingsCache settingsCache;
    private final SettingsCache ampSettingsCache;
    private final CachingApplicationSettings cachingApplicationSettings;
    private final JacksonMapper mapper;
    private final List<Suspendable> suspendableServices;

    public AdminCentralService(CriteriaManager criteriaManager, LineItemService lineItemService, DeliveryProgressService deliveryProgressService, SettingsCache settingsCache, SettingsCache ampSettingsCache, CachingApplicationSettings cachingApplicationSettings, JacksonMapper mapper, List<Suspendable> suspendableServices) {
        this.criteriaManager = Objects.requireNonNull(criteriaManager);
        this.lineItemService = Objects.requireNonNull(lineItemService);
        this.deliveryProgressService = Objects.requireNonNull(deliveryProgressService);
        this.settingsCache = settingsCache;
        this.ampSettingsCache = ampSettingsCache;
        this.cachingApplicationSettings = cachingApplicationSettings;
        this.mapper = Objects.requireNonNull(mapper);
        this.suspendableServices = Objects.requireNonNull(suspendableServices);
    }

    @Override
    public void processAdminCentralEvent(AdminCentralResponse centralAdminResponse) {
        ServicesCommand servicesCommand;
        Command accountCommand;
        Command storedRequestAmpCommand;
        Command storedRequestCommand;
        Command lineItemsCommand;
        LogTracer logTracer = centralAdminResponse.getTracer();
        if (logTracer != null) {
            this.handleLogTracer(centralAdminResponse.getTracer());
        }
        if ((lineItemsCommand = centralAdminResponse.getLineItems()) != null) {
            this.handleLineItems(lineItemsCommand);
        }
        if ((storedRequestCommand = centralAdminResponse.getStoredRequest()) != null && this.settingsCache != null) {
            this.handleStoredRequest(this.settingsCache, storedRequestCommand, STORED_REQUEST_CACHE);
        }
        if ((storedRequestAmpCommand = centralAdminResponse.getStoredRequestAmp()) != null && this.ampSettingsCache != null) {
            this.handleStoredRequest(this.ampSettingsCache, storedRequestAmpCommand, AMP_STORED_REQUEST_CACHE);
        }
        if ((accountCommand = centralAdminResponse.getAccount()) != null && this.cachingApplicationSettings != null) {
            this.handleAccountCommand(accountCommand);
        }
        if ((servicesCommand = centralAdminResponse.getServices()) != null) {
            this.handleServiceCommand(servicesCommand);
        }
    }

    private void handleAccountCommand(Command accountCommand) {
        AdminAccounts adminAccounts;
        String cmd = accountCommand.getCmd();
        if (StringUtils.isBlank((CharSequence)cmd)) {
            logger.warn((Object)"Command for account action was not defined in register response");
            return;
        }
        if (!Objects.equals(cmd, INVALIDATE)) {
            logger.warn((Object)"Account commands supports only `invalidate` command, but received {0}", new Object[]{cmd});
            return;
        }
        ObjectNode body = accountCommand.getBody();
        try {
            adminAccounts = body != null ? (AdminAccounts)this.mapper.mapper().convertValue((Object)body, AdminAccounts.class) : null;
        }
        catch (IllegalArgumentException e) {
            logger.warn((Object)"Can't parse admin accounts body, failed with exception message : {0}", new Object[]{e.getMessage()});
            return;
        }
        List accounts = ObjectUtil.getIfNotNull(adminAccounts, AdminAccounts::getAccounts);
        if (CollectionUtils.isNotEmpty((Collection)accounts)) {
            accounts.forEach(this.cachingApplicationSettings::invalidateAccountCache);
        } else {
            this.cachingApplicationSettings.invalidateAllAccountCache();
        }
    }

    private void handleLineItems(Command lineItemsCommand) {
        AdminLineItems adminLineItems;
        String cmd = lineItemsCommand.getCmd();
        if (StringUtils.isBlank((CharSequence)cmd)) {
            logger.warn((Object)"Command for line-items action was not defined in register response.");
            return;
        }
        if (!Objects.equals(cmd, INVALIDATE)) {
            logger.warn((Object)"Line Items section supports only `invalidate` command, but received {0}", new Object[]{cmd});
            return;
        }
        ObjectNode body = lineItemsCommand.getBody();
        try {
            adminLineItems = body != null ? (AdminLineItems)this.mapper.mapper().convertValue((Object)body, AdminLineItems.class) : null;
        }
        catch (IllegalArgumentException e) {
            logger.warn((Object)"Can't parse admin line items body, failed with exception message : {0}", new Object[]{e.getMessage()});
            return;
        }
        List lineItemIds = ObjectUtil.getIfNotNull(adminLineItems, AdminLineItems::getIds);
        if (CollectionUtils.isNotEmpty((Collection)lineItemIds)) {
            this.lineItemService.invalidateLineItemsByIds(lineItemIds);
            this.deliveryProgressService.invalidateLineItemsByIds(lineItemIds);
        } else {
            this.lineItemService.invalidateLineItems();
            this.deliveryProgressService.invalidateLineItems();
        }
    }

    private void handleStoredRequest(SettingsCache settingsCache, Command storedRequestCommand, String serviceName) {
        String cmd = storedRequestCommand.getCmd();
        if (StringUtils.isBlank((CharSequence)cmd)) {
            logger.warn((Object)"Command for {0} was not defined.", new Object[]{serviceName});
            return;
        }
        ObjectNode body = storedRequestCommand.getBody();
        if (body == null) {
            logger.warn((Object)"Command body for {0} was not defined.", new Object[]{serviceName});
            return;
        }
        switch (cmd) {
            case "invalidate": {
                this.invalidateStoredRequests(settingsCache, serviceName, body);
                break;
            }
            case "save": {
                this.saveStoredRequests(settingsCache, serviceName, body);
                break;
            }
            default: {
                logger.warn((Object)"Command for {0} should has value 'save' or 'invalidate' but was {1}.", new Object[]{serviceName, cmd});
            }
        }
    }

    private void saveStoredRequests(SettingsCache settingsCache, String serviceName, ObjectNode body) {
        UpdateSettingsCacheRequest saveRequest;
        try {
            saveRequest = (UpdateSettingsCacheRequest)this.mapper.mapper().convertValue((Object)body, UpdateSettingsCacheRequest.class);
        }
        catch (IllegalArgumentException e) {
            logger.warn((Object)"Can't parse save settings cache request object for {0}, failed with exception message : {1}", new Object[]{serviceName, e.getMessage()});
            return;
        }
        Map storedRequests = MapUtils.emptyIfNull(saveRequest.getRequests());
        Map storedImps = MapUtils.emptyIfNull(saveRequest.getImps());
        settingsCache.save(storedRequests, storedImps);
        logger.info((Object)"Stored request with ids {0} and stored impressions with ids {1} were successfully saved", new Object[]{String.join((CharSequence)", ", storedRequests.keySet()), String.join((CharSequence)", ", storedImps.keySet())});
    }

    private void invalidateStoredRequests(SettingsCache settingsCache, String serviceName, ObjectNode body) {
        InvalidateSettingsCacheRequest invalidateRequest;
        try {
            invalidateRequest = (InvalidateSettingsCacheRequest)this.mapper.mapper().convertValue((Object)body, InvalidateSettingsCacheRequest.class);
        }
        catch (IllegalArgumentException e) {
            logger.warn((Object)"Can't parse invalidate settings cache request object for {0}, failed with exception message : {1}", new Object[]{serviceName, e.getMessage()});
            return;
        }
        List requestIds = ListUtils.emptyIfNull(invalidateRequest.getRequests());
        List impIds = ListUtils.emptyIfNull(invalidateRequest.getImps());
        settingsCache.invalidate(requestIds, impIds);
        logger.info((Object)"Stored requests with ids {0} and impression with ids {1} were successfully invalidated", new Object[]{String.join((CharSequence)", ", requestIds), String.join((CharSequence)", ", impIds)});
    }

    private void handleLogTracer(LogTracer logTracer) {
        String command = logTracer.getCmd();
        if (StringUtils.isBlank((CharSequence)command)) {
            logger.warn((Object)"Command for traceLogger was not defined");
            return;
        }
        switch (command) {
            case "start": {
                this.criteriaManager.addCriteria(logTracer.getFilters(), logTracer.getDurationInSeconds());
                break;
            }
            case "stop": {
                this.criteriaManager.stop();
                break;
            }
            default: {
                logger.warn((Object)"Command for trace logger should has value 'start' or 'stop' but was {0}.", new Object[]{command});
            }
        }
    }

    private void handleServiceCommand(ServicesCommand servicesCommand) {
        String command = servicesCommand.getCmd();
        if (command != null && command.equalsIgnoreCase(STOP)) {
            this.suspendableServices.forEach(Suspendable::suspend);
        }
        logger.info((Object)"PBS services were successfully suspended");
    }
}

