/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.cookie;

import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import org.prebid.server.cookie.model.UidWithExpiry;
import org.prebid.server.cookie.proto.Uids;
import org.prebid.server.json.JacksonMapper;

public class UidsCookie {
    private final Uids uids;
    private final JacksonMapper mapper;

    public UidsCookie(Uids uids, JacksonMapper mapper) {
        this.uids = Objects.requireNonNull(uids);
        Objects.requireNonNull(uids.getUids());
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Uids getCookieUids() {
        return this.uids;
    }

    public static boolean isFacebookSentinel(String familyName, String uid) {
        return Objects.equals(familyName, "audienceNetwork") && Objects.equals(uid, "0");
    }

    public String uidFrom(String familyName) {
        UidWithExpiry uid = this.uids.getUids().get(familyName);
        return uid != null ? uid.getUid() : null;
    }

    public boolean allowsSync() {
        return !Objects.equals(this.uids.getOptout(), Boolean.TRUE);
    }

    public boolean hasLiveUids() {
        return this.uids.getUids().values().stream().anyMatch(UidsCookie::isLive);
    }

    public boolean hasLiveUidFrom(String familyName) {
        UidWithExpiry uid = this.uids.getUids().get(familyName);
        return uid != null && uid.getUid() != null && UidsCookie.isLive(uid);
    }

    public UidsCookie deleteUid(String familyName) {
        HashMap<String, UidWithExpiry> uidsMap = new HashMap<String, UidWithExpiry>(this.uids.getUids());
        uidsMap.remove(familyName);
        return new UidsCookie(this.uids.toBuilder().uids(uidsMap).build(), this.mapper);
    }

    public UidsCookie updateUid(String familyName, String uid) {
        HashMap<String, UidWithExpiry> uidsMap = new HashMap<String, UidWithExpiry>(this.uids.getUids());
        uidsMap.put(familyName, UidWithExpiry.live(uid));
        return new UidsCookie(this.uids.toBuilder().uids(uidsMap).build(), this.mapper);
    }

    public UidsCookie updateOptout(boolean optout) {
        Uids.UidsBuilder uidsBuilder = this.uids.toBuilder();
        uidsBuilder.optout(optout);
        if (optout) {
            uidsBuilder.uids(Collections.emptyMap());
        }
        return new UidsCookie(uidsBuilder.build(), this.mapper);
    }

    String toJson() {
        return this.mapper.encodeToString(this.uids);
    }

    private static boolean isLive(UidWithExpiry uid) {
        ZonedDateTime expires = uid.getExpires();
        return expires != null && expires.isAfter(ZonedDateTime.now());
    }
}

