/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.yieldmo;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.bidder.yieldmo.proto.YieldmoBidExt;
import org.prebid.server.bidder.yieldmo.proto.YieldmoImpExt;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.yieldmo.ExtImpYieldmo;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class YieldmoBidder
implements Bidder<BidRequest> {
    private static final JsonPointer PBADSLOT_POINTER = JsonPointer.valueOf((String)"/data/pbadslot");
    private static final TypeReference<ExtPrebid<?, ExtImpYieldmo>> YIELDMO_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpYieldmo>>(){};
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public YieldmoBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        ArrayList<Imp> modifiedImps = new ArrayList<Imp>();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        for (Imp imp : bidRequest.getImp()) {
            try {
                ExtImpYieldmo impExt = this.parseImpExt(imp);
                modifiedImps.add(this.modifyImp(imp, impExt));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
            }
        }
        if (modifiedImps.isEmpty()) {
            return Result.withErrors(errors);
        }
        BidRequest modifiedRequest = bidRequest.toBuilder().imp(modifiedImps).build();
        return Result.of(Collections.singletonList(this.makeRequest(modifiedRequest)), errors);
    }

    private ExtImpYieldmo parseImpExt(Imp imp) throws PreBidException {
        try {
            return (ExtImpYieldmo)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), YIELDMO_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage(), e);
        }
    }

    private Imp modifyImp(Imp imp, ExtImpYieldmo ext) {
        YieldmoImpExt modifiedExt = YieldmoImpExt.of(ext.getPlacementId(), YieldmoBidder.extractGpid(imp));
        return imp.toBuilder().ext((ObjectNode)this.mapper.mapper().valueToTree((Object)modifiedExt)).build();
    }

    private static String extractGpid(Imp imp) {
        JsonNode pbadslotNode = imp.getExt().at(PBADSLOT_POINTER);
        return pbadslotNode.isTextual() ? (String)StringUtils.defaultIfEmpty((CharSequence)pbadslotNode.asText(), null) : null;
    }

    private HttpRequest<BidRequest> makeRequest(BidRequest bidRequest) {
        return BidderUtil.defaultRequest(bidRequest, this.endpointUrl, this.mapper);
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues(this.extractBids(bidResponse));
        }
        catch (DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> {
            BidType bidType = this.resolveBidType((Bid)bid);
            return bidType != null ? BidderBid.of(bid, bidType, bidResponse.getCur()) : null;
        }).filter(Objects::nonNull).toList();
    }

    private BidType resolveBidType(Bid bid) {
        try {
            YieldmoBidExt bidExt = (YieldmoBidExt)this.mapper.mapper().treeToValue((TreeNode)bid.getExt(), YieldmoBidExt.class);
            return BidType.fromString(bidExt.getMediaType());
        }
        catch (Exception e) {
            return null;
        }
    }
}

