/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.visx;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.bidder.visx.model.VisxBid;
import org.prebid.server.bidder.visx.model.VisxResponse;
import org.prebid.server.bidder.visx.model.VisxSeatBid;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class VisxBidder
implements Bidder<BidRequest> {
    private static final String DEFAULT_REQUEST_CURRENCY = "USD";
    private static final Set<String> SUPPORTED_BID_TYPES_TEXTUAL = Set.of("banner", "video");
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public VisxBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        return Result.withValue(this.makeRequest(request));
    }

    private HttpRequest<BidRequest> makeRequest(BidRequest bidRequest) {
        BidRequest outgoingRequest = this.modifyRequest(bidRequest);
        return BidderUtil.defaultRequest(outgoingRequest, this.endpointUrl, this.mapper);
    }

    private BidRequest modifyRequest(BidRequest bidRequest) {
        return CollectionUtils.isEmpty(bidRequest.getCur()) ? bidRequest.toBuilder().cur(Collections.singletonList(DEFAULT_REQUEST_CURRENCY)).build() : bidRequest;
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            VisxResponse visxResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), VisxResponse.class);
            return Result.withValues(this.extractBids(httpCall.getRequest().getPayload(), visxResponse));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidRequest bidRequest, VisxResponse visxResponse) {
        if (visxResponse == null || CollectionUtils.isEmpty(visxResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return this.bidsFromResponse(bidRequest, visxResponse);
    }

    private List<BidderBid> bidsFromResponse(BidRequest bidRequest, VisxResponse visxResponse) {
        return visxResponse.getSeatbid().stream().filter(Objects::nonNull).map(VisxSeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(visxBid -> this.toBidderBid(bidRequest, (VisxBid)visxBid)).toList();
    }

    private BidderBid toBidderBid(BidRequest bidRequest, VisxBid visxBid) {
        Bid bid = VisxBidder.toBid(visxBid, bidRequest.getId());
        BidType bidType = VisxBidder.getBidType(bid.getExt(), bid.getImpid(), bidRequest.getImp());
        return BidderBid.of(bid, bidType, null);
    }

    private static Bid toBid(VisxBid visxBid, String id) {
        return Bid.builder().id(id).impid(visxBid.getImpid()).price(visxBid.getPrice()).adm(visxBid.getAdm()).crid(visxBid.getCrid()).dealid(visxBid.getDealid()).h(visxBid.getH()).w(visxBid.getW()).adomain(visxBid.getAdomain()).ext(visxBid.getExt()).build();
    }

    private static BidType getBidType(ObjectNode bidExt, String impId, List<Imp> imps) {
        BidType extBidType = VisxBidder.getBidTypeFromExt(bidExt);
        return extBidType != null ? extBidType : VisxBidder.getBidTypeFromImp(impId, imps);
    }

    private static BidType getBidTypeFromExt(ObjectNode bidExt) {
        JsonNode mediaTypeNode = bidExt != null ? bidExt.at("/prebid/meta/mediaType") : null;
        String bidTypeTextual = mediaTypeNode != null && mediaTypeNode.isTextual() ? mediaTypeNode.asText() : null;
        return bidTypeTextual != null && SUPPORTED_BID_TYPES_TEXTUAL.contains(bidTypeTextual) ? BidType.valueOf(bidTypeTextual) : null;
    }

    private static BidType getBidTypeFromImp(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            throw new PreBidException("Unknown impression type for ID: \"%s\"".formatted(impId));
        }
        throw new PreBidException("Failed to find impression for ID: \"%s\"".formatted(impId));
    }
}

