/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.thirtythreeacross;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Video;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.bidder.thirtythreeacross.proto.ThirtyThreeAcrossExtTtx;
import org.prebid.server.bidder.thirtythreeacross.proto.ThirtyThreeAcrossExtTtxCaller;
import org.prebid.server.bidder.thirtythreeacross.proto.ThirtyThreeAcrossImpExt;
import org.prebid.server.bidder.thirtythreeacross.proto.ThirtyThreeAcrossImpExtTtx;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.FlexibleExtension;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.thirtythreeacross.ExtImpThirtyThreeAcross;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ObjectUtil;

public class ThirtyThreeAcrossBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpThirtyThreeAcross>> THIRTY_THREE_ACROSS_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpThirtyThreeAcross>>(){};
    private static final ThirtyThreeAcrossExtTtxCaller PREBID_CALLER = ThirtyThreeAcrossExtTtxCaller.of("Prebid-Server-Java", "n/a");
    private static final JsonPointer BID_MEDIA_TYPE_POINTER = JsonPointer.valueOf((String)"/ttx/mediaType");
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public ThirtyThreeAcrossBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        HashMap<String, List> impsMap = new HashMap<String, List>();
        ArrayList<HttpRequest<BidRequest>> requests = new ArrayList<HttpRequest<BidRequest>>();
        BidRequest modifiedRequest = this.modifyRequest(request, errors);
        for (Imp imp : modifiedRequest.getImp()) {
            try {
                ThirtyThreeAcrossBidder.validateImp(imp);
                ExtImpThirtyThreeAcross extImpTtx = this.parseImpExt(imp);
                String productId = extImpTtx.getProductId();
                ThirtyThreeAcrossImpExt modifiedImpExt = ThirtyThreeAcrossBidder.createImpExt(productId, extImpTtx);
                Imp updatedImp = this.updateImp(imp, productId, modifiedImpExt);
                impsMap.computeIfAbsent(ThirtyThreeAcrossBidder.getImpGroupName(modifiedImpExt), ignored -> new ArrayList()).add(updatedImp);
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
            }
        }
        for (List imps : impsMap.values()) {
            requests.add(this.createRequest(modifiedRequest, imps));
        }
        return Result.of(requests, errors);
    }

    private BidRequest modifyRequest(BidRequest request, List<BidderError> errors) {
        try {
            return request.toBuilder().ext(this.modifyRequestExt(request.getExt())).build();
        }
        catch (PreBidException e) {
            errors.add(BidderError.badInput(e.getMessage()));
            return request;
        }
    }

    private ExtRequest modifyRequestExt(ExtRequest ext) throws PreBidException {
        ThirtyThreeAcrossExtTtx extTtx;
        Map extProperties = ObjectUtil.getIfNotNull(ext, FlexibleExtension::getProperties);
        JsonNode extTtxNode = ObjectUtil.getIfNotNull(extProperties, properties -> (JsonNode)properties.get("ttx"));
        try {
            extTtx = (ThirtyThreeAcrossExtTtx)this.mapper.mapper().convertValue((Object)extTtxNode, ThirtyThreeAcrossExtTtx.class);
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
        ExtRequest modifiedExt = ExtRequest.empty();
        if (extProperties != null) {
            modifiedExt.addProperties(extProperties);
        }
        modifiedExt.addProperty("ttx", this.mapper.mapper().valueToTree((Object)ThirtyThreeAcrossBidder.modifyRequestExtTtx(extTtx)));
        return modifiedExt;
    }

    private static ThirtyThreeAcrossExtTtx modifyRequestExtTtx(ThirtyThreeAcrossExtTtx extTtx) {
        return ThirtyThreeAcrossExtTtx.of(extTtx != null && CollectionUtils.isNotEmpty(extTtx.getCaller()) ? ListUtils.union(extTtx.getCaller(), Collections.singletonList(PREBID_CALLER)) : Collections.singletonList(PREBID_CALLER));
    }

    private static void validateImp(Imp imp) {
        if (imp.getBanner() == null && imp.getVideo() == null) {
            throw new PreBidException("Imp ID %s must have at least one of [Banner, Video] defined".formatted(imp.getId()));
        }
    }

    private ExtImpThirtyThreeAcross parseImpExt(Imp imp) {
        try {
            return (ExtImpThirtyThreeAcross)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), THIRTY_THREE_ACROSS_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private static ThirtyThreeAcrossImpExt createImpExt(String productId, ExtImpThirtyThreeAcross extImpTtx) {
        String zoneId = extImpTtx.getZoneId();
        return ThirtyThreeAcrossImpExt.of(ThirtyThreeAcrossImpExtTtx.of(productId, StringUtils.isNotEmpty((CharSequence)zoneId) ? zoneId : extImpTtx.getSiteId()));
    }

    private Imp updateImp(Imp imp, String productId, ThirtyThreeAcrossImpExt impExt) {
        return imp.toBuilder().video(ThirtyThreeAcrossBidder.updatedVideo(imp.getVideo(), productId)).ext((ObjectNode)this.mapper.mapper().valueToTree((Object)impExt)).build();
    }

    private static Video updatedVideo(Video video, String productId) {
        if (video == null) {
            return null;
        }
        if (BidderUtil.isNullOrZero(video.getW()) || BidderUtil.isNullOrZero(video.getH()) || CollectionUtils.isEmpty(video.getProtocols()) || CollectionUtils.isEmpty(video.getMimes()) || CollectionUtils.isEmpty(video.getPlaybackmethod())) {
            throw new PreBidException("One or more invalid or missing video field(s) w, h, protocols, mimes, playbackmethod");
        }
        return video.toBuilder().startdelay(ThirtyThreeAcrossBidder.resolveStartDelay(video.getStartdelay(), productId)).placement(ThirtyThreeAcrossBidder.resolvePlacement(video.getPlacement(), productId)).build();
    }

    private static Integer resolveStartDelay(Integer startDelay, String productId) {
        return Objects.equals(productId, "instream") ? Integer.valueOf(0) : startDelay;
    }

    private static Integer resolvePlacement(Integer videoPlacement, String productId) {
        if (Objects.equals(productId, "instream")) {
            return 1;
        }
        if (BidderUtil.isNullOrZero(videoPlacement)) {
            return 2;
        }
        return videoPlacement;
    }

    private static String getImpGroupName(ThirtyThreeAcrossImpExt impExt) {
        ThirtyThreeAcrossImpExtTtx impExtTtx = impExt.getTtx();
        return impExtTtx.getProd() + impExtTtx.getZoneid();
    }

    private HttpRequest<BidRequest> createRequest(BidRequest request, List<Imp> requestImps) {
        BidRequest modifiedRequest = request.toBuilder().imp(requestImps).build();
        return BidderUtil.defaultRequest(modifiedRequest, this.endpointUrl, this.mapper);
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues(ThirtyThreeAcrossBidder.extractBids(bidResponse));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> BidderBid.of(bid, ThirtyThreeAcrossBidder.getBidType(bid), bidResponse.getCur())).toList();
    }

    private static BidType getBidType(Bid bid) {
        String mediaType = ObjectUtil.getIfNotNull(bid.getExt(), ext -> ext.at(BID_MEDIA_TYPE_POINTER).asText(null));
        return "video".equals(mediaType) ? BidType.video : BidType.banner;
    }
}

