/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.silverpush;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class SilverPushDeviceTypeResolver {
    private static final Pattern MOBILE_PATTERN = Pattern.compile("(ios|ipod|ipad|iphone|android)", 2);
    private static final Pattern CTV_PATTERN = Pattern.compile("(smart[-]?tv|hbbtv|appletv|googletv|hdmi|netcast\\.tv|viera|nettv|roku|\\bdtv\\b|sonydtv|inettvbrowser|\\btv\\b)", 2);

    private SilverPushDeviceTypeResolver() {
    }

    public static String resolveOs(String userAgent) {
        if (StringUtils.containsIgnoreCase((CharSequence)userAgent, (CharSequence)"Windows")) {
            return "Windows";
        }
        if (StringUtils.containsAnyIgnoreCase((CharSequence)userAgent, (CharSequence[])new CharSequence[]{"iPhone", "iPod", "iPad"})) {
            return "iOS";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)userAgent, (CharSequence)"Mac OS X")) {
            return "macOS";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)userAgent, (CharSequence)"Android")) {
            return "Android";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)userAgent, (CharSequence)"Linux")) {
            return "Linux";
        }
        return "Unknown";
    }

    public static Integer resolveDeviceType(String userAgent) {
        if (SilverPushDeviceTypeResolver.isMobile(userAgent)) {
            return 1;
        }
        if (SilverPushDeviceTypeResolver.isCTV(userAgent)) {
            return 3;
        }
        return 2;
    }

    private static boolean isMobile(String userAgent) {
        return MOBILE_PATTERN.matcher(userAgent).find();
    }

    private static boolean isCTV(String userAgent) {
        return CTV_PATTERN.matcher(userAgent).find();
    }
}

