/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.mobfoxpb;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.mobfoxpb.ExtImpMobfoxpb;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class MobfoxpbBidder
implements Bidder<BidRequest> {
    private static final String ROUTE_RTB = "rtb";
    private static final String METHOD_RTB = "req";
    private static final String ROUTE_NATIVE = "o";
    private static final String METHOD_NATIVE = "ortb";
    private static final String URL_KEY_MACROS = "__key__";
    private static final String URL_ROUTE_MACROS = "__route__";
    private static final String URL_METHOD_MACROS = "__method__";
    private final String endpointUrl;
    private final JacksonMapper mapper;
    private static final TypeReference<ExtPrebid<?, ExtImpMobfoxpb>> MOBFOXPB_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpMobfoxpb>>(){};

    public MobfoxpbBidder(String endpoint, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpoint));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public final Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        BidRequest outgoingRequest;
        String uri;
        try {
            Imp firstImp = bidRequest.getImp().get(0);
            ExtImpMobfoxpb impExt = this.parseImpExt(firstImp);
            uri = this.buildUri(impExt.getKey());
            outgoingRequest = bidRequest.toBuilder().imp(Collections.singletonList(firstImp)).build();
        }
        catch (PreBidException e) {
            return Result.withError(BidderError.badInput(e.getMessage()));
        }
        return Result.withValue(BidderUtil.defaultRequest(outgoingRequest, uri, this.mapper));
    }

    private ExtImpMobfoxpb parseImpExt(Imp imp) {
        ExtImpMobfoxpb extImpMobfoxpb;
        try {
            extImpMobfoxpb = (ExtImpMobfoxpb)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), MOBFOXPB_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
        if (StringUtils.isEmpty((CharSequence)extImpMobfoxpb.getKey()) && StringUtils.isEmpty((CharSequence)extImpMobfoxpb.getTagId())) {
            throw new PreBidException("Invalid or non existing key and tagId, atleast one should be present");
        }
        return extImpMobfoxpb;
    }

    private String buildUri(String key) {
        String method;
        String route;
        String uri = this.endpointUrl;
        if (StringUtils.isNotEmpty((CharSequence)key)) {
            route = ROUTE_RTB;
            method = METHOD_RTB;
            uri = uri.replace(URL_KEY_MACROS, key);
        } else {
            route = ROUTE_NATIVE;
            method = METHOD_NATIVE;
        }
        return uri.replace(URL_ROUTE_MACROS, route).replace(URL_METHOD_MACROS, method);
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            BidRequest payload = httpCall.getRequest().getPayload();
            return MobfoxpbBidder.extractBids(bidResponse, payload.getImp());
        }
        catch (DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private static Result<List<BidderBid>> extractBids(BidResponse bidResponse, List<Imp> imps) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Result.of(Collections.emptyList(), Collections.emptyList());
        }
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        List<BidderBid> bidderBids = bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> MobfoxpbBidder.bidFromResponse(imps, bid, bidResponse.getCur(), errors)).filter(Objects::nonNull).toList();
        return Result.of(bidderBids, errors);
    }

    private static BidderBid bidFromResponse(List<Imp> imps, Bid bid, String currency, List<BidderError> errors) {
        try {
            return BidderBid.of(bid, MobfoxpbBidder.getBidType(bid.getImpid(), imps), currency);
        }
        catch (PreBidException e) {
            errors.add(BidderError.badInput(e.getMessage()));
            return null;
        }
    }

    private static BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getXNative() == null) continue;
            return BidType.xNative;
        }
        throw new PreBidException("Failed to find impression \"%s\"".formatted(impId));
    }
}

