/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.kidoz;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.kidoz.ExtImpKidoz;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

public class KidozBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpKidoz>> KIDOZ_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpKidoz>>(){};
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public KidozBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        ArrayList<HttpRequest<BidRequest>> result = new ArrayList<HttpRequest<BidRequest>>();
        for (Imp imp : request.getImp()) {
            try {
                this.validateImp(imp);
                result.add(this.createSingleRequest(request, imp));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
            }
        }
        return Result.of(result, errors);
    }

    private HttpRequest<BidRequest> createSingleRequest(BidRequest request, Imp imp) {
        BidRequest outgoingRequest = request.toBuilder().imp(Collections.singletonList(imp)).build();
        MultiMap headers = HttpUtil.headers().add(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)"2.5");
        return HttpRequest.builder().method(HttpMethod.POST).uri(this.endpointUrl).headers(headers).body(this.mapper.encodeToBytes(outgoingRequest)).payload(outgoingRequest).build();
    }

    private void validateImp(Imp imp) {
        ExtImpKidoz extImpKidoz;
        if (imp.getBanner() == null && imp.getVideo() == null) {
            throw new PreBidException("Kidoz only supports banner or video ads");
        }
        Banner banner = imp.getBanner();
        if (banner != null && CollectionUtils.isEmpty(banner.getFormat())) {
            throw new PreBidException("banner format required");
        }
        try {
            extImpKidoz = (ExtImpKidoz)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), KIDOZ_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
        KidozBidder.validateImpExt(extImpKidoz);
    }

    private static void validateImpExt(ExtImpKidoz extImpKidoz) {
        if (extImpKidoz == null) {
            throw new PreBidException("impression extensions required");
        }
        if (StringUtils.isBlank((CharSequence)extImpKidoz.getAccessToken())) {
            throw new PreBidException("Kidoz access_token required");
        }
        if (StringUtils.isBlank((CharSequence)extImpKidoz.getPublisherID())) {
            throw new PreBidException("Kidoz publisher_id required");
        }
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return KidozBidder.extractBids(httpCall.getRequest().getPayload(), bidResponse);
        }
        catch (DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private static Result<List<BidderBid>> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Result.empty();
        }
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        List<BidderBid> bidderBids = bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> KidozBidder.bidFromResponse(bidRequest.getImp(), bid, bidResponse.getCur(), errors)).filter(Objects::nonNull).toList();
        return Result.of(bidderBids, errors);
    }

    private static BidderBid bidFromResponse(List<Imp> imps, Bid bid, String currency, List<BidderError> errors) {
        try {
            BidType bidType = KidozBidder.getBidType(bid.getImpid(), imps);
            return BidderBid.of(bid, bidType, currency);
        }
        catch (PreBidException e) {
            errors.add(BidderError.badInput(e.getMessage()));
            return null;
        }
    }

    private static BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getXNative() != null) {
                return BidType.xNative;
            }
            if (imp.getAudio() == null) continue;
            return BidType.audio;
        }
        throw new PreBidException("Failed to find impression " + impId);
    }
}

