/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.iqzone;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.iqzone.ExtImpIqzone;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class IqzoneBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpIqzone>> IQZONE_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpIqzone>>(){};
    private final JacksonMapper mapper;
    private final String endpointUrl;

    public IqzoneBidder(String endpointUrl, JacksonMapper mapper) {
        this.mapper = Objects.requireNonNull(mapper);
        this.endpointUrl = HttpUtil.validateUrl(endpointUrl);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<HttpRequest<BidRequest>> httpRequests = new ArrayList<HttpRequest<BidRequest>>();
        for (Imp imp : request.getImp()) {
            try {
                ExtImpIqzone extImpIqzone = this.parseImpExt(imp);
                Imp modifiedImp = this.modifyImp(imp, extImpIqzone);
                httpRequests.add(this.makeHttpRequest(request, modifiedImp));
            }
            catch (IllegalArgumentException e) {
                return Result.withError(BidderError.badInput(e.getMessage()));
            }
        }
        return Result.withValues(httpRequests);
    }

    private ExtImpIqzone parseImpExt(Imp imp) {
        return (ExtImpIqzone)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), IQZONE_EXT_TYPE_REFERENCE)).getBidder();
    }

    private Imp modifyImp(Imp imp, ExtImpIqzone impExt) {
        String placementId = impExt.getPlacementId();
        ObjectNode modifiedImpExtBidder = this.mapper.mapper().createObjectNode();
        if (StringUtils.isNotEmpty((CharSequence)placementId)) {
            modifiedImpExtBidder.set("placementId", (JsonNode)TextNode.valueOf((String)placementId));
            modifiedImpExtBidder.set("type", (JsonNode)TextNode.valueOf((String)"publisher"));
        } else {
            modifiedImpExtBidder.set("endpointId", (JsonNode)TextNode.valueOf((String)impExt.getEndpointId()));
            modifiedImpExtBidder.set("type", (JsonNode)TextNode.valueOf((String)"network"));
        }
        return imp.toBuilder().ext((ObjectNode)this.mapper.mapper().createObjectNode().set("bidder", (JsonNode)modifiedImpExtBidder)).build();
    }

    private HttpRequest<BidRequest> makeHttpRequest(BidRequest request, Imp imp) {
        BidRequest outgoingRequest = request.toBuilder().imp(List.of(imp)).build();
        return BidderUtil.defaultRequest(outgoingRequest, this.endpointUrl, this.mapper);
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of(this.extractBids(httpCall.getRequest().getPayload(), bidResponse), Collections.emptyList());
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return this.bidsFromResponse(bidRequest, bidResponse);
    }

    private List<BidderBid> bidsFromResponse(BidRequest bidRequest, BidResponse bidResponse) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidderBid.of(bid, IqzoneBidder.getBidType(bid.getImpid(), bidRequest.getImp()), bidResponse.getCur())).toList();
    }

    private static BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getXNative() != null) {
                return BidType.xNative;
            }
            throw new PreBidException("Unknown impression type for ID: \"%s\"".formatted(impId));
        }
        throw new PreBidException("Failed to find impression for ID: \"%s\"".formatted(impId));
    }
}

