/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.huaweiads.model.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.util.List;
import org.prebid.server.bidder.huaweiads.model.request.AdSlot30;
import org.prebid.server.bidder.huaweiads.model.request.App;
import org.prebid.server.bidder.huaweiads.model.request.Device;
import org.prebid.server.bidder.huaweiads.model.request.Geo;
import org.prebid.server.bidder.huaweiads.model.request.Network;
import org.prebid.server.bidder.huaweiads.model.request.Regs;

public final class HuaweiAdsRequest {
    private final String version;
    @JsonProperty(value="multislot")
    private final List<AdSlot30> multislot;
    private final App app;
    private final Device device;
    private final Network network;
    private final Regs regs;
    private final Geo geo;
    private final String consent;
    @JsonProperty(value="clientAdRequestId")
    private final String clientAdRequestId;

    @ConstructorProperties(value={"version", "multislot", "app", "device", "network", "regs", "geo", "consent", "clientAdRequestId"})
    HuaweiAdsRequest(String version, List<AdSlot30> multislot, App app, Device device, Network network, Regs regs, Geo geo, String consent, String clientAdRequestId) {
        this.version = version;
        this.multislot = multislot;
        this.app = app;
        this.device = device;
        this.network = network;
        this.regs = regs;
        this.geo = geo;
        this.consent = consent;
        this.clientAdRequestId = clientAdRequestId;
    }

    public static HuaweiAdsRequestBuilder builder() {
        return new HuaweiAdsRequestBuilder();
    }

    public HuaweiAdsRequestBuilder toBuilder() {
        return new HuaweiAdsRequestBuilder().version(this.version).multislot(this.multislot).app(this.app).device(this.device).network(this.network).regs(this.regs).geo(this.geo).consent(this.consent).clientAdRequestId(this.clientAdRequestId);
    }

    public String getVersion() {
        return this.version;
    }

    public List<AdSlot30> getMultislot() {
        return this.multislot;
    }

    public App getApp() {
        return this.app;
    }

    public Device getDevice() {
        return this.device;
    }

    public Network getNetwork() {
        return this.network;
    }

    public Regs getRegs() {
        return this.regs;
    }

    public Geo getGeo() {
        return this.geo;
    }

    public String getConsent() {
        return this.consent;
    }

    public String getClientAdRequestId() {
        return this.clientAdRequestId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HuaweiAdsRequest)) {
            return false;
        }
        HuaweiAdsRequest other = (HuaweiAdsRequest)o;
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        List<AdSlot30> this$multislot = this.getMultislot();
        List<AdSlot30> other$multislot = other.getMultislot();
        if (this$multislot == null ? other$multislot != null : !((Object)this$multislot).equals(other$multislot)) {
            return false;
        }
        App this$app = this.getApp();
        App other$app = other.getApp();
        if (this$app == null ? other$app != null : !((Object)this$app).equals(other$app)) {
            return false;
        }
        Device this$device = this.getDevice();
        Device other$device = other.getDevice();
        if (this$device == null ? other$device != null : !((Object)this$device).equals(other$device)) {
            return false;
        }
        Network this$network = this.getNetwork();
        Network other$network = other.getNetwork();
        if (this$network == null ? other$network != null : !((Object)this$network).equals(other$network)) {
            return false;
        }
        Regs this$regs = this.getRegs();
        Regs other$regs = other.getRegs();
        if (this$regs == null ? other$regs != null : !((Object)this$regs).equals(other$regs)) {
            return false;
        }
        Geo this$geo = this.getGeo();
        Geo other$geo = other.getGeo();
        if (this$geo == null ? other$geo != null : !((Object)this$geo).equals(other$geo)) {
            return false;
        }
        String this$consent = this.getConsent();
        String other$consent = other.getConsent();
        if (this$consent == null ? other$consent != null : !this$consent.equals(other$consent)) {
            return false;
        }
        String this$clientAdRequestId = this.getClientAdRequestId();
        String other$clientAdRequestId = other.getClientAdRequestId();
        return !(this$clientAdRequestId == null ? other$clientAdRequestId != null : !this$clientAdRequestId.equals(other$clientAdRequestId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        List<AdSlot30> $multislot = this.getMultislot();
        result = result * 59 + ($multislot == null ? 43 : ((Object)$multislot).hashCode());
        App $app = this.getApp();
        result = result * 59 + ($app == null ? 43 : ((Object)$app).hashCode());
        Device $device = this.getDevice();
        result = result * 59 + ($device == null ? 43 : ((Object)$device).hashCode());
        Network $network = this.getNetwork();
        result = result * 59 + ($network == null ? 43 : ((Object)$network).hashCode());
        Regs $regs = this.getRegs();
        result = result * 59 + ($regs == null ? 43 : ((Object)$regs).hashCode());
        Geo $geo = this.getGeo();
        result = result * 59 + ($geo == null ? 43 : ((Object)$geo).hashCode());
        String $consent = this.getConsent();
        result = result * 59 + ($consent == null ? 43 : $consent.hashCode());
        String $clientAdRequestId = this.getClientAdRequestId();
        result = result * 59 + ($clientAdRequestId == null ? 43 : $clientAdRequestId.hashCode());
        return result;
    }

    public String toString() {
        return "HuaweiAdsRequest(version=" + this.getVersion() + ", multislot=" + this.getMultislot() + ", app=" + this.getApp() + ", device=" + this.getDevice() + ", network=" + this.getNetwork() + ", regs=" + this.getRegs() + ", geo=" + this.getGeo() + ", consent=" + this.getConsent() + ", clientAdRequestId=" + this.getClientAdRequestId() + ")";
    }

    public static class HuaweiAdsRequestBuilder {
        private String version;
        private List<AdSlot30> multislot;
        private App app;
        private Device device;
        private Network network;
        private Regs regs;
        private Geo geo;
        private String consent;
        private String clientAdRequestId;

        HuaweiAdsRequestBuilder() {
        }

        public HuaweiAdsRequestBuilder version(String version) {
            this.version = version;
            return this;
        }

        @JsonProperty(value="multislot")
        public HuaweiAdsRequestBuilder multislot(List<AdSlot30> multislot) {
            this.multislot = multislot;
            return this;
        }

        public HuaweiAdsRequestBuilder app(App app) {
            this.app = app;
            return this;
        }

        public HuaweiAdsRequestBuilder device(Device device) {
            this.device = device;
            return this;
        }

        public HuaweiAdsRequestBuilder network(Network network) {
            this.network = network;
            return this;
        }

        public HuaweiAdsRequestBuilder regs(Regs regs) {
            this.regs = regs;
            return this;
        }

        public HuaweiAdsRequestBuilder geo(Geo geo) {
            this.geo = geo;
            return this;
        }

        public HuaweiAdsRequestBuilder consent(String consent) {
            this.consent = consent;
            return this;
        }

        @JsonProperty(value="clientAdRequestId")
        public HuaweiAdsRequestBuilder clientAdRequestId(String clientAdRequestId) {
            this.clientAdRequestId = clientAdRequestId;
            return this;
        }

        public HuaweiAdsRequest build() {
            return new HuaweiAdsRequest(this.version, this.multislot, this.app, this.device, this.network, this.regs, this.geo, this.consent, this.clientAdRequestId);
        }

        public String toString() {
            return "HuaweiAdsRequest.HuaweiAdsRequestBuilder(version=" + this.version + ", multislot=" + this.multislot + ", app=" + this.app + ", device=" + this.device + ", network=" + this.network + ", regs=" + this.regs + ", geo=" + this.geo + ", consent=" + this.consent + ", clientAdRequestId=" + this.clientAdRequestId + ")";
        }
    }
}

