/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.huaweiads;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.User;
import com.iab.openrtb.response.Bid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.crypto.Mac;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.huaweiads.CountryCodeResolver;
import org.prebid.server.bidder.huaweiads.HuaweiAdSlotBuilder;
import org.prebid.server.bidder.huaweiads.HuaweiAdmBuilder;
import org.prebid.server.bidder.huaweiads.HuaweiAppBuilder;
import org.prebid.server.bidder.huaweiads.HuaweiDeviceBuilder;
import org.prebid.server.bidder.huaweiads.HuaweiEndpointResolver;
import org.prebid.server.bidder.huaweiads.HuaweiNetworkBuilder;
import org.prebid.server.bidder.huaweiads.model.AdsType;
import org.prebid.server.bidder.huaweiads.model.request.AdSlot30;
import org.prebid.server.bidder.huaweiads.model.request.Geo;
import org.prebid.server.bidder.huaweiads.model.request.HuaweiAdsRequest;
import org.prebid.server.bidder.huaweiads.model.request.Regs;
import org.prebid.server.bidder.huaweiads.model.response.Ad30;
import org.prebid.server.bidder.huaweiads.model.response.Content;
import org.prebid.server.bidder.huaweiads.model.response.HuaweiAdm;
import org.prebid.server.bidder.huaweiads.model.response.HuaweiAdsResponse;
import org.prebid.server.bidder.huaweiads.model.response.Monitor;
import org.prebid.server.bidder.huaweiads.model.response.MonitorEventType;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtUser;
import org.prebid.server.proto.openrtb.ext.request.huaweiads.ExtImpHuaweiAds;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class HuaweiAdsBidder
implements Bidder<HuaweiAdsRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpHuaweiAds>> EXT_IMP_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpHuaweiAds>>(){};
    private static final String HUAWEI_ADX_API_VERSION = "3.4";
    private static final String DEFAULT_COUNTRY_CODE = "ZA";
    private static final String DEFAULT_BID_CURRENCY = "CNY";
    private static final List<String> HUAWEIADS_DOMAIN = List.of("huaweiads");
    private final JacksonMapper mapper;
    private final HuaweiAdSlotBuilder adSlotBuilder;
    private final HuaweiAppBuilder appBuilder;
    private final HuaweiDeviceBuilder deviceBuilder;
    private final HuaweiNetworkBuilder networkBuilder;
    private final HuaweiAdmBuilder admBuilder;
    private final CountryCodeResolver countryCodeResolver;
    private final HuaweiEndpointResolver endpointResolver;

    public HuaweiAdsBidder(JacksonMapper mapper, HuaweiAdSlotBuilder adSlotBuilder, HuaweiAppBuilder appBuilder, HuaweiDeviceBuilder deviceBuilder, HuaweiNetworkBuilder networkBuilder, HuaweiAdmBuilder admBuilder, CountryCodeResolver countryCodeResolver, HuaweiEndpointResolver endpointResolver) {
        this.mapper = Objects.requireNonNull(mapper);
        this.adSlotBuilder = Objects.requireNonNull(adSlotBuilder);
        this.appBuilder = Objects.requireNonNull(appBuilder);
        this.deviceBuilder = Objects.requireNonNull(deviceBuilder);
        this.networkBuilder = Objects.requireNonNull(networkBuilder);
        this.admBuilder = Objects.requireNonNull(admBuilder);
        this.countryCodeResolver = Objects.requireNonNull(countryCodeResolver);
        this.endpointResolver = Objects.requireNonNull(endpointResolver);
    }

    @Override
    public Result<List<HttpRequest<HuaweiAdsRequest>>> makeHttpRequests(BidRequest bidRequest) {
        HuaweiAdsRequest huaweiAdsRequest;
        String countryCode = this.countryCodeResolver.resolve(bidRequest).orElse(DEFAULT_COUNTRY_CODE);
        ExtImpHuaweiAds impExt = null;
        try {
            ArrayList<AdSlot30> adSlots = new ArrayList<AdSlot30>();
            for (Imp imp : bidRequest.getImp()) {
                impExt = this.parseImpExt(imp);
                this.validate(impExt);
                AdSlot30 adSlot30 = this.adSlotBuilder.build(imp, impExt);
                adSlots.add(adSlot30);
            }
            huaweiAdsRequest = this.makeHuaweiAdsRequest(bidRequest, adSlots, countryCode);
        }
        catch (PreBidException e) {
            return Result.withError(BidderError.badInput(e.getMessage()));
        }
        HttpRequest<HuaweiAdsRequest> httpRequest = HttpRequest.builder().method(HttpMethod.POST).uri(this.endpointResolver.resolve(countryCode)).headers(HuaweiAdsBidder.makeHeaders(bidRequest, impExt)).impIds(BidderUtil.impIds(bidRequest)).body(this.mapper.encodeToBytes(huaweiAdsRequest)).payload(huaweiAdsRequest).build();
        return Result.withValue(httpRequest);
    }

    private ExtImpHuaweiAds parseImpExt(Imp imp) {
        try {
            return (ExtImpHuaweiAds)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), EXT_IMP_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private void validate(ExtImpHuaweiAds impExt) {
        if (impExt == null) {
            throw new PreBidException("ExtImpHuaweiAds is null.");
        }
        if (StringUtils.isBlank((CharSequence)impExt.getSlotId())) {
            throw new PreBidException("ExtImpHuaweiAds: slotid is empty.");
        }
        if (StringUtils.isBlank((CharSequence)impExt.getAdType())) {
            throw new PreBidException("ExtImpHuaweiAds: adtype is empty.");
        }
        if (StringUtils.isBlank((CharSequence)impExt.getPublisherId())) {
            throw new PreBidException("ExtImpHuaweiAds: publisherid is empty.");
        }
        if (StringUtils.isBlank((CharSequence)impExt.getSignKey())) {
            throw new PreBidException("ExtImpHuaweiAds: signkey is empty.");
        }
        if (StringUtils.isBlank((CharSequence)impExt.getKeyId())) {
            throw new PreBidException("ExtImpHuaweiAds: keyid is empty.");
        }
    }

    private HuaweiAdsRequest makeHuaweiAdsRequest(BidRequest bidRequest, List<AdSlot30> adSlots, String countryCode) {
        return HuaweiAdsRequest.builder().clientAdRequestId(bidRequest.getId()).multislot(adSlots).version(HUAWEI_ADX_API_VERSION).app(this.appBuilder.build(bidRequest.getApp(), countryCode)).device(this.deviceBuilder.build(bidRequest.getDevice(), bidRequest.getUser(), countryCode)).network(this.networkBuilder.build(bidRequest.getDevice())).regs(this.makeRegs(bidRequest.getRegs())).geo(this.makeGeo(bidRequest.getDevice())).consent(this.makeConsent(bidRequest.getUser())).build();
    }

    private Regs makeRegs(com.iab.openrtb.request.Regs regs) {
        return Optional.ofNullable(regs).map(com.iab.openrtb.request.Regs::getCoppa).filter(coppa -> coppa >= 0).map(Regs::of).orElseGet(() -> Regs.of(null));
    }

    private Geo makeGeo(Device device) {
        return Optional.ofNullable(device).map(Device::getGeo).map(geo -> Geo.of(geo.getLon(), geo.getLat(), geo.getAccuracy(), geo.getLastfix())).orElse(null);
    }

    private String makeConsent(User user) {
        return Optional.ofNullable(user).map(User::getExt).map(ExtUser::getConsent).orElse(null);
    }

    private static MultiMap makeHeaders(BidRequest bidRequest, ExtImpHuaweiAds extImp) {
        MultiMap headers = HttpUtil.headers();
        headers.set(HttpUtil.AUTHORIZATION_HEADER, (CharSequence)HuaweiAdsBidder.makeAuthorization(extImp));
        Optional.ofNullable(bidRequest.getDevice()).map(Device::getUa).filter(StringUtils::isNotBlank).ifPresent(ua -> headers.set(HttpUtil.USER_AGENT_HEADER, (CharSequence)ua));
        return headers;
    }

    private static String makeAuthorization(ExtImpHuaweiAds extImp) {
        String nonce = String.valueOf(System.currentTimeMillis());
        String publisherId = extImp.getPublisherId().trim();
        String apiKey = publisherId + ":ppsadx/getResult:" + extImp.getSignKey().trim();
        String data = nonce + ":POST:/ppsadx/getResult";
        String encryptedData = HuaweiAdsBidder.encrypt(data, apiKey);
        return "Digest username=%s,realm=ppsadx/getResult,nonce=%s,response=%s,algorithm=%s,usertype=1,keyid=%s".formatted(publisherId, nonce, encryptedData, HmacAlgorithms.HMAC_SHA_256.getName(), extImp.getKeyId().trim());
    }

    private static String encrypt(String message, String key) {
        try {
            Mac mac = HmacUtils.getInitializedMac((HmacAlgorithms)HmacAlgorithms.HMAC_SHA_256, (byte[])key.getBytes(StandardCharsets.UTF_8));
            byte[] hmac = mac.doFinal(message.getBytes(StandardCharsets.UTF_8));
            return Hex.encodeHexString((byte[])hmac);
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<HuaweiAdsRequest> httpCall, BidRequest bidRequest) {
        try {
            HuaweiAdsResponse response = this.mapper.decodeValue(httpCall.getResponse().getBody(), HuaweiAdsResponse.class);
            HuaweiAdsBidder.validateRetcode(response.getRetcode(), response.getReason());
            return Result.withValues(this.extractBids(response, bidRequest));
        }
        catch (DecodeException e) {
            return Result.withError(BidderError.badServerResponse("Bad Server Response"));
        }
        catch (PreBidException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private static void validateRetcode(Integer retcode, String reason) {
        boolean isBetween400And599Inclusively;
        boolean isBetween200And300Exclusively = retcode > 200 && retcode < 300;
        boolean bl = isBetween400And599Inclusively = retcode >= 400 && retcode < 600;
        if (isBetween200And300Exclusively && retcode != 204 && retcode != 206 || isBetween400And599Inclusively) {
            throw new PreBidException("HuaweiAdsResponse retcode: " + retcode + " , reason: " + reason);
        }
    }

    private List<BidderBid> extractBids(HuaweiAdsResponse response, BidRequest bidRequest) {
        if (CollectionUtils.isEmpty(response.getMultiad())) {
            throw new PreBidException("convert huaweiads response to bidder response failed: multiad length is 0, get no ads from huawei side.");
        }
        if (CollectionUtils.isEmpty(bidRequest.getImp())) {
            throw new PreBidException("convert huaweiads response to bidder response failed: openRTBRequest.imp is empty");
        }
        HashMap<String, Imp> slotIdToImpMap = new HashMap<String, Imp>();
        for (Imp imp : bidRequest.getImp()) {
            ExtImpHuaweiAds impExt = this.parseImpExt(imp);
            this.validate(impExt);
            slotIdToImpMap.put(impExt.getSlotId(), imp);
        }
        return this.makeBidderBids(response, slotIdToImpMap);
    }

    private List<BidderBid> makeBidderBids(HuaweiAdsResponse response, Map<String, Imp> slotIdToImpMap) {
        ArrayList<BidderBid> bids = new ArrayList<BidderBid>();
        for (Ad30 ad : response.getMultiad()) {
            Optional<String> optionalImpId = Optional.ofNullable(ad.getSlotId()).map(slotIdToImpMap::get).map(Imp::getId).filter(StringUtils::isNotBlank);
            if (optionalImpId.isEmpty() || !Objects.equals(ad.getRetCode(), 200)) continue;
            Imp imp = slotIdToImpMap.get(ad.getSlotId());
            BidType mediaType = HuaweiAdsBidder.getMediaType(imp);
            String currency = HuaweiAdsBidder.getCurrency(ad.getContentList()).orElse(DEFAULT_BID_CURRENCY);
            for (Content content : ad.getContentList()) {
                if (content == null) {
                    throw new PreBidException("extract Adm failed: content is empty");
                }
                Bid bid = this.makeBid(ad, imp, mediaType, content);
                bids.add(BidderBid.of(bid, mediaType, currency));
            }
        }
        return bids;
    }

    private static BidType getMediaType(Imp imp) {
        if (imp.getVideo() != null) {
            return BidType.video;
        }
        if (imp.getXNative() != null) {
            return BidType.xNative;
        }
        if (imp.getAudio() != null) {
            return BidType.audio;
        }
        return BidType.banner;
    }

    private static Optional<String> getCurrency(List<Content> contentList) {
        return contentList.stream().filter(Objects::nonNull).map(Content::getCur).filter(StringUtils::isNotBlank).findFirst();
    }

    private Bid makeBid(Ad30 ad, Imp imp, BidType mediaType, Content content) {
        AdsType adType = AdsType.ofTypeNumber(ad.getAdType());
        HuaweiAdm huaweiAdm = switch (mediaType) {
            case BidType.banner -> this.admBuilder.buildBanner(adType, content);
            case BidType.video -> this.admBuilder.buildVideo(adType, content, imp.getVideo());
            case BidType.xNative -> this.admBuilder.buildNative(adType, content, imp.getXNative());
            default -> throw new PreBidException("no support bidtype: audio");
        };
        return Bid.builder().id(imp.getId()).impid(imp.getId()).price(content.getPrice()).crid(content.getContentId()).adm(huaweiAdm.getAdm()).w(huaweiAdm.getWidth()).h(huaweiAdm.getHeight()).adomain(HUAWEIADS_DOMAIN).nurl(this.getNurl(content.getMonitorList())).build();
    }

    private String getNurl(List<Monitor> monitorList) {
        return Stream.ofNullable(monitorList).flatMap(Collection::stream).filter(monitor -> MonitorEventType.of(monitor.getEventType()) == MonitorEventType.WIN && CollectionUtils.isNotEmpty(monitor.getUrlList())).map(Monitor::getUrlList).flatMap(Collection::stream).findFirst().orElse("");
    }
}

