/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.dxkulture;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.http.client.utils.URIBuilder;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.dxkulture.ExtImpDxKulture;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ObjectUtil;

public class DxKultureBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpDxKulture>> DXKULTURE_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpDxKulture>>(){};
    private static final String X_OPENRTB_VERSION = "2.5";
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public DxKultureBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        ArrayList<HttpRequest<BidRequest>> result = new ArrayList<HttpRequest<BidRequest>>();
        for (Imp imp : request.getImp()) {
            String uri;
            try {
                uri = this.getUri(this.parseImpExt(imp));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
                continue;
            }
            result.add(BidderUtil.defaultRequest(request, DxKultureBidder.resolveHeaders(request), uri, this.mapper));
        }
        return Result.of(result, errors);
    }

    private ExtImpDxKulture parseImpExt(Imp imp) {
        try {
            return (ExtImpDxKulture)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), DXKULTURE_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage(), e);
        }
    }

    private String getUri(ExtImpDxKulture extImpDxKulture) {
        URIBuilder uriBuilder;
        try {
            uriBuilder = new URIBuilder(this.endpointUrl);
        }
        catch (URISyntaxException e) {
            throw new PreBidException("Invalid url: %s, error: %s".formatted(this.endpointUrl, e.getMessage()));
        }
        uriBuilder.addParameter("publisher_id", extImpDxKulture.getPublisherId()).addParameter("placement_id", extImpDxKulture.getPlacementId());
        return uriBuilder.toString();
    }

    private static MultiMap resolveHeaders(BidRequest bidRequest) {
        Device device = bidRequest.getDevice();
        Site site = bidRequest.getSite();
        MultiMap headers = HttpUtil.headers();
        headers.set(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)X_OPENRTB_VERSION);
        HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.USER_AGENT_HEADER, ObjectUtil.getIfNotNull(device, Device::getUa));
        HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.X_FORWARDED_FOR_HEADER, ObjectUtil.getIfNotNull(device, Device::getIpv6));
        HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.X_FORWARDED_FOR_HEADER, ObjectUtil.getIfNotNull(device, Device::getIp));
        HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.REFERER_HEADER, ObjectUtil.getIfNotNull(site, Site::getRef));
        HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.ORIGIN_HEADER, ObjectUtil.getIfNotNull(site, Site::getDomain));
        return headers;
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        BidResponse bidResponse;
        try {
            bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
        }
        catch (DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        List<BidderBid> bids = DxKultureBidder.extractBids(httpCall.getRequest().getPayload(), bidResponse, errors);
        return Result.of(bids, errors);
    }

    private static List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse, List<BidderError> errors) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> DxKultureBidder.makeBidderBid(bid, bidRequest.getImp(), bidResponse.getCur(), errors)).filter(Objects::nonNull).toList();
    }

    private static BidderBid makeBidderBid(Bid bid, List<Imp> imps, String currency, List<BidderError> errors) {
        try {
            return BidderBid.of(bid, DxKultureBidder.resolveBidType(bid), currency);
        }
        catch (PreBidException e) {
            errors.add(BidderError.badServerResponse(e.getMessage()));
            return null;
        }
    }

    private static BidType resolveBidType(Bid bid) throws PreBidException {
        Integer markupType = bid.getMtype();
        if (markupType == null) {
            throw new PreBidException("Missing MType for bid: " + bid.getId());
        }
        return switch (markupType) {
            case 1 -> BidType.banner;
            case 2 -> BidType.video;
            default -> throw new PreBidException("Unsupported MType: %s, for bid: %s".formatted(markupType, bid.getId()));
        };
    }
}

