/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.connectad;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.connectad.ExtImpConnectAd;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class ConnectadBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpConnectAd>> CONNECTAD_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpConnectAd>>(){};
    private static final String HTTPS_PREFIX = "https";
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public ConnectadBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        int secure = ConnectadBidder.secureFrom(request.getSite());
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        ArrayList<Imp> processedImps = new ArrayList<Imp>();
        for (Imp imp : request.getImp()) {
            try {
                ExtImpConnectAd impExt = this.parseImpExt(imp);
                Imp updatedImp = this.updateImp(imp, secure, impExt.getSiteId(), impExt.getBidfloor());
                processedImps.add(updatedImp);
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
            }
        }
        if (CollectionUtils.isNotEmpty(errors)) {
            errors.add(BidderError.badInput("Error in preprocess of Imp"));
            return Result.withErrors(errors);
        }
        BidRequest outgoingRequest = request.toBuilder().imp(processedImps).build();
        return Result.of(Collections.singletonList(HttpRequest.builder().method(HttpMethod.POST).uri(this.endpointUrl).headers(ConnectadBidder.resolveHeaders(request.getDevice())).payload(outgoingRequest).body(this.mapper.encodeToBytes(outgoingRequest)).build()), errors);
    }

    private static int secureFrom(Site site) {
        String page = site != null ? site.getPage() : null;
        return page != null && page.startsWith(HTTPS_PREFIX) ? 1 : 0;
    }

    private ExtImpConnectAd parseImpExt(Imp imp) {
        ExtImpConnectAd extImpConnectAd;
        try {
            extImpConnectAd = (ExtImpConnectAd)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), CONNECTAD_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("Impression id=%s, has invalid Ext".formatted(imp.getId()));
        }
        Integer siteId = extImpConnectAd.getSiteId();
        if (siteId == null || siteId.equals(0)) {
            throw new PreBidException("Impression id=%s, has no siteId present".formatted(imp.getId()));
        }
        return extImpConnectAd;
    }

    private Imp updateImp(Imp imp, Integer secure, Integer siteId, BigDecimal bidFloor) {
        Banner banner;
        Imp.ImpBuilder updatedImp = imp.toBuilder().tagid(siteId.toString()).secure(secure);
        if (BidderUtil.isValidPrice(bidFloor)) {
            updatedImp.bidfloor(bidFloor).bidfloorcur("USD");
        }
        if ((banner = imp.getBanner()) == null) {
            throw new PreBidException("We need a Banner Object in the request");
        }
        if (banner.getW() == null && banner.getH() == null) {
            if (CollectionUtils.isEmpty(banner.getFormat())) {
                throw new PreBidException("At least one size is required");
            }
            Format format = banner.getFormat().get(0);
            ArrayList<Format> slicedFormatList = new ArrayList<Format>(banner.getFormat());
            slicedFormatList.remove(0);
            updatedImp.banner(banner.toBuilder().format(slicedFormatList).w(format.getW()).h(format.getH()).build());
        }
        return updatedImp.build();
    }

    private static MultiMap resolveHeaders(Device device) {
        MultiMap headers = HttpUtil.headers();
        if (device != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.USER_AGENT_HEADER, device.getUa());
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.ACCEPT_LANGUAGE_HEADER, device.getLanguage());
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.X_FORWARDED_FOR_HEADER, device.getIp());
            HttpUtil.addHeaderIfValueIsNotEmpty(headers, HttpUtil.X_FORWARDED_FOR_HEADER, device.getIpv6());
            Integer dnt = device.getDnt();
            headers.add(HttpUtil.DNT_HEADER, (CharSequence)(dnt != null ? dnt.toString() : "0"));
        }
        return headers;
    }

    @Override
    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of(this.extractBids(bidResponse), Collections.emptyList());
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return this.bidsFromResponse(bidResponse);
    }

    private List<BidderBid> bidsFromResponse(BidResponse bidResponse) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidderBid.of(bid, BidType.banner, bidResponse.getCur())).toList();
    }
}

